/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import * as models from "./Models";
/**
 * Contains information on what directory to (recursively monitor), and any
 * filters that should be applied (eg to ignore changes to files/directories with
 * specific names/paths).
 *
 * The fields correspond to the array of projects JSON from
 * the 'GET api/v1/projects/watchlist' API. See docs for format restrictions for
 * these fields.
 */
export declare class ProjectToWatch {
    readonly projectId: string;
    readonly pathToMonitor: string;
    readonly ignoredPaths: string[];
    readonly ignoredFilenames: string[];
    readonly projectWatchStateId: string;
    readonly external: boolean;
    readonly projectCreationTimeInAbsoluteMsecs: number;
    /** Create an instance of this class from the given JSON object. */
    static createFromJson(json: models.IWatchedProjectJson, deleteChangeType: boolean): ProjectToWatch;
    /**
     * Create a new ProjectToWatch (not ProjectToWatchFromWebSocket), copy the values from the old param,
     * but replace the projectCreationTimeInAbsoluteMsecs param
     */
    static cloneWithNewProjectCreationTime(old: ProjectToWatch, projectCreationTimeInAbsoluteMsecsParam: number): ProjectToWatch;
    /**
     * Copy values from old to result, but replace projectCreationTimeInAbsoluteMsecsParam param in result.
     * Called only by above method, and from ProjectToWatchFromWebSocket.
     */
    protected static copyWithNewProjectCreationTime(result: ProjectToWatch, old: ProjectToWatch, projectCreationTimeInAbsoluteMsecsParam: number): void;
    /** Copy the values from the JSON object into the given ProjectToWatch. */
    protected static innerCreateFromJson(result: ProjectToWatch, json: models.IWatchedProjectJson, deleteChangeType: boolean): void;
    /**
     * The contents of this class are defacto immutable after creation, and should not be changed.
     * However, the fields are not read-only because we need multiple constructing methods.
     */
    private _projectId;
    private _pathToMonitor;
    private _ignoredPaths;
    private _ignoredFilenames;
    private _projectWatchStateId;
    private _external;
    /** undefined if project time is not specified, a >0 value otherwise. */
    private _projectCreationTimeInAbsoluteMsecs;
    protected constructor();
    private validatePathToMonitor;
}
