/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.modelqualitychecks;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.modelqualitychecks.SnakesHelper;

class PToken {
    private final List<String> variables;
    private final Map<String, Expression> values;

    PToken() {
        this.variables = null;
        this.values = null;
    }

    PToken(List<String> variables) {
        this.variables = variables;
        this.values = null;
    }

    PToken(Map<String, Expression> values) {
        this.variables = null;
        this.values = values;
    }

    String toSnakes() {
        if (this.variables != null) {
            String variables = this.variables.stream().map(s -> String.format("'%s': %s", s, s)).collect(Collectors.joining(","));
            return String.format("Variables({%s})", variables);
        }
        if (this.values != null) {
            String variables = this.values.entrySet().stream().map(s -> String.format("'%s': %s", s.getKey(), SnakesHelper.expression((Expression)s.getValue(), variable -> ""))).collect(Collectors.joining(","));
            return String.format("Variables({%s})", variables);
        }
        return "''";
    }
}

