/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.helpgenerator.sunapi;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import org.eclipse.ease.helpgenerator.AbstractModuleDoclet;
import org.eclipse.ease.helpgenerator.IReporter;
import org.eclipse.ease.helpgenerator.model.AbstractClassModel;
import org.eclipse.ease.helpgenerator.model.ModuleDefinition;
import org.eclipse.ease.helpgenerator.sunapi.Java5ClassModel;

public class Java5ModuleDoclet
extends AbstractModuleDoclet {
    private RootDoc fRootDoc;

    @Override
    protected IReporter createReporter() {
        return new OutputStreamReporter();
    }

    public void setRootDoc(RootDoc rootDoc) {
        this.fRootDoc = rootDoc;
    }

    @Override
    protected AbstractClassModel getClassModel(ModuleDefinition module) {
        for (ClassDoc classDoc : this.fRootDoc.classes()) {
            if (!classDoc.qualifiedName().equals(module.getClassName())) continue;
            Java5ClassModel classModel = new Java5ClassModel(classDoc);
            ((AbstractClassModel)classModel).populateModel();
            return classModel;
        }
        return null;
    }

    private class OutputStreamReporter
    implements IReporter {
        private boolean fHasErrors = false;

        private OutputStreamReporter() {
        }

        @Override
        public void report(int status, String message) {
            switch (status) {
                case 0: {
                    System.out.println(message);
                    break;
                }
                case 1: {
                    System.out.println("WARNING: " + message);
                    break;
                }
                default: {
                    System.err.println("ERROR: " + message);
                    this.fHasErrors = true;
                }
            }
        }

        @Override
        public boolean hasErrors() {
            return this.fHasErrors;
        }

        @Override
        public void reportMissingDocs(String message) {
            this.report(Java5ModuleDoclet.this.failOnMissingDocs() ? 2 : 1, message);
        }

        @Override
        public void reportInvalidHtml(String message) {
            this.report(Java5ModuleDoclet.this.failOnHtmlErrors() ? 2 : 1, message);
        }
    }
}

