/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.parser.ScanException;
import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.util.IEscapeUtil;
import ch.qos.logback.core.pattern.util.RegularEscapeUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TokenStream {
    private static final char ESCAPE_CHAR = '\\';
    private static final char PERCENT_CHAR = '%';
    private static final char CURLY_LEFT = '{';
    private static final char CURLY_RIGHT = '}';
    private static final int LITERAL_STATE = 0;
    private static final int FORMAT_MODIFIER_STATE = 1;
    private static final int KEYWORD_STATE = 2;
    private static final int OPTION_STATE = 3;
    final String pattern;
    final int patternLength;
    final IEscapeUtil escapeUtil;
    int state = 0;
    int pointer = 0;

    TokenStream(String pattern) {
        this(pattern, new RegularEscapeUtil());
    }

    TokenStream(String pattern, IEscapeUtil escapeUtil) {
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("null or empty pattern string not allowed");
        }
        this.pattern = pattern;
        this.patternLength = pattern.length();
        this.escapeUtil = escapeUtil;
    }

    List tokenize() throws ScanException {
        ArrayList<Token> tokenList = new ArrayList<Token>();
        StringBuffer buf = new StringBuffer();
        while (this.pointer < this.patternLength) {
            char c = this.pattern.charAt(this.pointer);
            ++this.pointer;
            block0 : switch (this.state) {
                case 0: {
                    switch (c) {
                        case '\\': {
                            this.escape("%()", buf);
                            break block0;
                        }
                        case '%': {
                            this.addValuedToken(1000, buf, tokenList);
                            tokenList.add(Token.PERCENT_TOKEN);
                            this.state = 1;
                            break block0;
                        }
                        case ')': {
                            if (buf.length() >= 1 && buf.charAt(buf.length() - 1) == '\\') {
                                buf.deleteCharAt(buf.length() - 1);
                                buf.append(')');
                                break block0;
                            }
                            this.addValuedToken(1000, buf, tokenList);
                            tokenList.add(Token.RIGHT_PARENTHESIS_TOKEN);
                            break block0;
                        }
                    }
                    buf.append(c);
                    break;
                }
                case 1: {
                    if (c == '(') {
                        this.addValuedToken(1002, buf, tokenList);
                        tokenList.add(Token.LEFT_PARENTHESIS_TOKEN);
                        this.state = 0;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(c)) {
                        this.addValuedToken(1002, buf, tokenList);
                        this.state = 2;
                        buf.append(c);
                        break;
                    }
                    buf.append(c);
                    break;
                }
                case 3: {
                    switch (c) {
                        case '}': {
                            this.addValuedToken(1006, buf, tokenList);
                            this.state = 0;
                            break block0;
                        }
                        case '\\': {
                            this.escape("%{}", buf);
                            break block0;
                        }
                    }
                    buf.append(c);
                    break;
                }
                case 2: {
                    if (c == '{') {
                        this.addValuedToken(1004, buf, tokenList);
                        this.state = 3;
                        break;
                    }
                    if (Character.isJavaIdentifierPart(c)) {
                        buf.append(c);
                        break;
                    }
                    if (c == '%') {
                        this.addValuedToken(1004, buf, tokenList);
                        tokenList.add(Token.PERCENT_TOKEN);
                        this.state = 1;
                        break;
                    }
                    this.addValuedToken(1004, buf, tokenList);
                    if (c == ')') {
                        tokenList.add(Token.RIGHT_PARENTHESIS_TOKEN);
                    } else if (c == '\\') {
                        if (this.pointer < this.patternLength) {
                            char next = this.pattern.charAt(this.pointer++);
                            this.escapeUtil.escape("%()", buf, next, this.pointer);
                        }
                    } else {
                        buf.append(c);
                    }
                    this.state = 0;
                    break;
                }
            }
        }
        switch (this.state) {
            case 0: {
                this.addValuedToken(1000, buf, tokenList);
                break;
            }
            case 2: {
                tokenList.add(new Token(1004, buf.toString()));
                buf.setLength(0);
                break;
            }
            case 1: 
            case 3: {
                throw new ScanException("Unexpected end of pattern string");
            }
        }
        return tokenList;
    }

    void escape(String escapeChars, StringBuffer buf) {
        if (this.pointer < this.patternLength) {
            char next = this.pattern.charAt(this.pointer++);
            this.escapeUtil.escape(escapeChars, buf, next, this.pointer);
        }
    }

    private void addValuedToken(int type, StringBuffer buf, List<Token> tokenList) {
        if (buf.length() > 0) {
            tokenList.add(new Token(type, buf.toString()));
            buf.setLength(0);
        }
    }
}

