/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;

public class AlterTableAlterColumn
extends SchemaCommand {
    public static final int NOT_NULL = 0;
    public static final int NULL = 1;
    public static final int DEFAULT = 2;
    public static final int CHANGE_TYPE = 3;
    public static final int ADD = 4;
    public static final int DROP = 5;
    public static final int SELECTIVITY = 6;
    private Table table;
    private Column oldColumn;
    private Column newColumn;
    private int type;
    private Expression defaultExpression;
    private Expression newSelectivity;
    private String addBefore;

    public AlterTableAlterColumn(Session session, Schema schema) {
        super(session, schema);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setOldColumn(Column column) {
        this.oldColumn = column;
    }

    public void setAddBefore(String string) {
        this.addBefore = string;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkRight(this.table, 15);
        this.table.checkSupportAlter();
        this.table.lock(this.session, true, true);
        Sequence sequence = this.oldColumn == null ? null : this.oldColumn.getSequence();
        switch (this.type) {
            case 0: {
                if (!this.oldColumn.isNullable()) break;
                this.checkNoNullValues();
                this.oldColumn.setNullable(false);
                database.update(this.session, this.table);
                break;
            }
            case 1: {
                if (this.oldColumn.isNullable()) break;
                this.checkNullable();
                this.oldColumn.setNullable(true);
                database.update(this.session, this.table);
                break;
            }
            case 2: {
                this.oldColumn.setSequence(null);
                this.oldColumn.setDefaultExpression(this.session, this.defaultExpression);
                this.removeSequence(sequence);
                database.update(this.session, this.table);
                break;
            }
            case 3: {
                this.checkNoViews();
                this.oldColumn.setSequence(null);
                this.oldColumn.setDefaultExpression(this.session, null);
                this.oldColumn.setConvertNullToDefault(false);
                if (this.oldColumn.isNullable() && !this.newColumn.isNullable()) {
                    this.checkNoNullValues();
                } else if (!this.oldColumn.isNullable() && this.newColumn.isNullable()) {
                    this.checkNullable();
                }
                this.convertToIdentityIfRequired(this.newColumn);
                this.copyData();
                break;
            }
            case 4: {
                this.checkNoViews();
                this.convertToIdentityIfRequired(this.newColumn);
                this.copyData();
                break;
            }
            case 5: {
                this.checkNoViews();
                if (this.table.getColumns().length == 1) {
                    throw Message.getSQLException(90084, this.oldColumn.getSQL());
                }
                this.table.checkColumnIsNotReferenced(this.oldColumn);
                this.dropSingleColumnIndexes();
                this.copyData();
                break;
            }
            case 6: {
                int n = this.newSelectivity.optimize(this.session).getValue(this.session).getInt();
                this.oldColumn.setSelectivity(n);
                database.update(this.session, this.table);
                break;
            }
            default: {
                Message.throwInternalError("type=" + this.type);
            }
        }
        return 0;
    }

    private void convertToIdentityIfRequired(Column column) {
        if (column.isAutoIncrement()) {
            column.setOriginalSQL("IDENTITY");
        }
    }

    private void removeSequence(Sequence sequence) throws SQLException {
        if (sequence != null) {
            this.table.removeSequence(this.session, sequence);
            sequence.setBelongsToTable(false);
            Database database = this.session.getDatabase();
            database.removeSchemaObject(this.session, sequence);
        }
    }

    private void checkNoViews() throws SQLException {
        for (DbObject dbObject : this.table.getChildren()) {
            if (dbObject.getType() != 0) continue;
            throw Message.getSQLException(90122, new String[]{this.table.getName(), dbObject.getName()});
        }
    }

    private void copyData() throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Database database = this.session.getDatabase();
        String string = database.getTempTableName(this.session.getId());
        Column[] columnArray = this.table.getColumns();
        ObjectArray<Column> objectArray = ObjectArray.newInstance();
        for (Column object52 : columnArray) {
            objectArray.add(object52.getClone());
        }
        if (this.type == 5) {
            int n = this.oldColumn.getColumnId();
            objectArray.remove(n);
        } else if (this.type == 4) {
            int n = this.addBefore == null ? columnArray.length : this.table.getColumn(this.addBefore).getColumnId();
            objectArray.add(n, this.newColumn);
        } else if (this.type == 3) {
            int n = this.oldColumn.getColumnId();
            objectArray.remove(n);
            objectArray.add(n, this.newColumn);
        }
        int n = database.allocateObjectId(true, true);
        TableData tableData = this.getSchema().createTable(string, n, objectArray, this.table.isTemporary(), this.table.isPersistIndexes(), this.table.isPersistData(), false, -1, this.session);
        tableData.setComment(this.table.getComment());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(tableData.getCreateSQL());
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Column column : objectArray) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(", ");
            }
            if (this.type == 4 && column == this.newColumn) {
                object3 = column.getDefaultExpression();
                stringBuilder2.append(object3 == null ? "NULL" : ((Expression)object3).getSQL());
                continue;
            }
            stringBuilder2.append(column.getSQL());
        }
        stringBuilder.append(" AS SELECT ");
        if (stringBuilder2.length() == 0) {
            stringBuilder.append('*');
        } else {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        stringBuilder.append(" FROM ").append(this.table.getSQL());
        String string2 = stringBuilder.toString();
        String string3 = tableData.getName();
        object3 = tableData.getSchema();
        tableData.removeChildrenAndResources(this.session);
        this.execute(string2, true);
        tableData = (TableData)((Schema)object3).getTableOrView(this.session, string3);
        ObjectArray<String> objectArray2 = ObjectArray.newInstance();
        for (DbObject dbObject : this.table.getChildren()) {
            ConstraintReferential constraintReferential;
            String string4;
            Index index;
            if (dbObject instanceof Sequence || dbObject instanceof Index && (index = (Index)dbObject).getIndexType().getBelongsToConstraint() || (string4 = dbObject.getCreateSQL()) == null) continue;
            if (dbObject.getType() == 0) {
                Message.throwInternalError();
            }
            object2 = Parser.quoteIdentifier(string + "_" + dbObject.getName());
            object = null;
            if (dbObject instanceof ConstraintReferential && (constraintReferential = (ConstraintReferential)dbObject).getTable() != this.table) {
                object = constraintReferential.getCreateSQLForCopy(constraintReferential.getTable(), tableData, (String)object2, false);
            }
            if (object == null) {
                object = dbObject.getCreateSQLForCopy(tableData, (String)object2);
            }
            if (object == null) continue;
            if (dbObject instanceof TriggerObject) {
                objectArray2.add((String)object);
                continue;
            }
            this.execute((String)object, true);
        }
        String string5 = this.table.getName();
        this.table.setModified();
        for (Column column : objectArray) {
            object2 = column.getSequence();
            if (object2 == null) continue;
            this.table.removeSequence(this.session, (Sequence)object2);
            column.setSequence(null);
        }
        for (String string6 : objectArray2) {
            this.execute(string6, true);
        }
        this.execute("DROP TABLE " + this.table.getSQL(), true);
        database.renameSchemaObject(this.session, tableData, string5);
        for (DbObject dbObject : tableData.getChildren()) {
            if (dbObject instanceof Sequence || (object2 = dbObject.getName()) == null || dbObject.getCreateSQL() == null || !((String)object2).startsWith(string + "_")) continue;
            object2 = ((String)object2).substring(string.length() + 1);
            object = (SchemaObject)dbObject;
            if (object instanceof Constraint) {
                if (object.getSchema().findConstraint(this.session, (String)object2) != null) {
                    object2 = object.getSchema().getUniqueConstraintName(this.session, tableData);
                }
            } else if (object instanceof Index && object.getSchema().findIndex(this.session, (String)object2) != null) {
                object2 = object.getSchema().getUniqueIndexName(this.session, tableData, (String)object2);
            }
            database.renameSchemaObject(this.session, (SchemaObject)object, (String)object2);
        }
    }

    private void execute(String string, boolean bl) throws SQLException {
        Prepared prepared = this.session.prepare(string);
        prepared.update();
        if (bl && this.session.getDatabase().isMultiVersion()) {
            this.session.commit(true);
        }
    }

    private void dropSingleColumnIndexes() throws SQLException {
        Database database = this.session.getDatabase();
        ObjectArray<Index> objectArray = this.table.getIndexes();
        for (int i = 0; i < objectArray.size(); ++i) {
            Column[] columnArray;
            Index index = objectArray.get(i);
            if (index.getCreateSQL() == null) continue;
            boolean bl = false;
            for (Column column : columnArray = index.getColumns()) {
                if (column != this.oldColumn) continue;
                if (columnArray.length == 1) {
                    bl = true;
                    continue;
                }
                throw Message.getSQLException(90075, index.getSQL());
            }
            if (!bl) continue;
            database.removeSchemaObject(this.session, index);
            objectArray = this.table.getIndexes();
            i = -1;
        }
    }

    private void checkNullable() throws SQLException {
        for (Index index : this.table.getIndexes()) {
            IndexType indexType;
            if (index.getColumnIndex(this.oldColumn) < 0 || !(indexType = index.getIndexType()).isPrimaryKey() && !indexType.isHash()) continue;
            throw Message.getSQLException(90075, index.getSQL());
        }
    }

    private void checkNoNullValues() throws SQLException {
        String string = "SELECT COUNT(*) FROM " + this.table.getSQL() + " WHERE " + this.oldColumn.getSQL() + " IS NULL";
        Prepared prepared = this.session.prepare(string);
        LocalResult localResult = prepared.query(0);
        localResult.next();
        if (localResult.currentRow()[0].getInt() > 0) {
            throw Message.getSQLException(90081, this.oldColumn.getSQL());
        }
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setSelectivity(Expression expression) {
        this.newSelectivity = expression;
    }

    public void setDefaultExpression(Expression expression) {
        this.defaultExpression = expression;
    }

    public void setNewColumn(Column column) {
        this.newColumn = column;
    }
}

