/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.dispatcher;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.ebam.adapters.AdapterConfiguration;
import org.eclipse.ebam.adapters.IAdapterManager;
import org.eclipse.ebam.dispatcher.IMsgDispatcher;
import org.eclipse.ebam.engine.interfaces.IEventProcessor;
import org.eclipse.ebam.messages.IEbamMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsgDispatcher
implements IMsgDispatcher {
    private AdapterConfiguration configuration = AdapterConfiguration.getInstance();
    private static Logger logger = LoggerFactory.getLogger(MsgDispatcher.class);
    private ConcurrentHashMap<String, IEventProcessor> processors;
    private IAdapterManager adapterManager;

    public MsgDispatcher(IAdapterManager adapt) {
        this.adapterManager = adapt;
    }

    public final ConcurrentHashMap<String, IEventProcessor> getProcessors() {
        return this.processors;
    }

    @Override
    public final void setProcessors(ConcurrentHashMap<String, IEventProcessor> processors) {
        this.processors = processors;
    }

    @Override
    public final void init() {
        String typeEngine = this.configuration.getManagerType();
        if ("java".equals(typeEngine)) {
            logger.info("Start to initialize the Event Processors");
            Map<String, String> engineConfigurations = this.retrieveEngine();
            Set<String> engineNames = engineConfigurations.keySet();
            for (String engineName : engineNames) {
                IEventProcessor eventprocessor = null;
                try {
                    Class<?> c = Class.forName(engineConfigurations.get(engineName));
                    eventprocessor = (IEventProcessor)c.newInstance();
                }
                catch (ClassNotFoundException e) {
                    logger.error("ClassNotFoundException", (Throwable)e);
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    logger.error("InstantiationException", (Throwable)e);
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    logger.error("IllegalAccessException", (Throwable)e);
                    e.printStackTrace();
                }
                this.processors.put(engineName, eventprocessor);
            }
            this.startEngines();
        }
        if ("osgi".equals(typeEngine)) {
            this.initFalse();
        }
    }

    private void startEngines() {
        Set engineNames = this.processors.keySet();
        for (String engineName : engineNames) {
            EventThread eventThread = new EventThread(this.processors.get(engineName));
            eventThread.run();
        }
    }

    @Override
    public final void sendToMsgDispatch(IEbamMessage message) {
        logger.info(" Message received " + message.getMsg());
        List enginesToSend = message.getTargetEngines();
        if (enginesToSend != null) {
            for (String s : enginesToSend) {
                logger.debug(" Engines to send the message :" + s);
            }
        }
        for (String name : enginesToSend) {
            IEventProcessor processor = this.processors.get(name);
            if (processor == null) continue;
            processor.sendToEventProcessor(message);
        }
    }

    private Map<String, String> retrieveEngine() {
        return this.configuration.getEventProcessors();
    }

    public final void initFalse() {
        logger.info("-------dispatcher in configurazione OSGI inizializzato++++++++++");
    }

    private class EventThread
    extends Thread {
        private IEventProcessor engine;

        public EventThread(IEventProcessor e) {
            this.engine = e;
        }

        public void run() {
            this.engine.init();
        }
    }
}

