/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.db;

import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.db.ConnectionSource;
import ch.qos.logback.core.db.DBHelper;
import ch.qos.logback.core.db.dialect.DBUtil;
import ch.qos.logback.core.db.dialect.SQLDialect;
import ch.qos.logback.core.db.dialect.SQLDialectCode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBAppenderBase<E>
extends UnsynchronizedAppenderBase<E> {
    protected ConnectionSource connectionSource;
    protected boolean cnxSupportsGetGeneratedKeys = false;
    protected boolean cnxSupportsBatchUpdates = false;
    protected SQLDialect sqlDialect;

    protected abstract Method getGeneratedKeysMethod();

    protected abstract String getInsertSQL();

    @Override
    public void start() {
        if (this.connectionSource == null) {
            throw new IllegalStateException("DBAppender cannot function without a connection source");
        }
        this.sqlDialect = DBUtil.getDialectFromCode(this.connectionSource.getSQLDialectCode());
        this.cnxSupportsGetGeneratedKeys = this.getGeneratedKeysMethod() != null ? this.connectionSource.supportsGetGeneratedKeys() : false;
        this.cnxSupportsBatchUpdates = this.connectionSource.supportsBatchUpdates();
        if (!this.cnxSupportsGetGeneratedKeys && this.sqlDialect == null) {
            throw new IllegalStateException("DBAppender cannot function if the JDBC driver does not support getGeneratedKeys method *and* without a specific SQL dialect");
        }
        super.start();
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(E eventObject) {
        Connection connection = null;
        try {
            long eventId;
            PreparedStatement insertStatement;
            connection = this.connectionSource.getConnection();
            connection.setAutoCommit(false);
            if (this.cnxSupportsGetGeneratedKeys) {
                String EVENT_ID_COL_NAME = "EVENT_ID";
                if (this.connectionSource.getSQLDialectCode() == SQLDialectCode.POSTGRES_DIALECT) {
                    EVENT_ID_COL_NAME = EVENT_ID_COL_NAME.toLowerCase();
                }
                insertStatement = connection.prepareStatement(this.getInsertSQL(), new String[]{EVENT_ID_COL_NAME});
            } else {
                insertStatement = connection.prepareStatement(this.getInsertSQL());
            }
            DBAppenderBase dBAppenderBase = this;
            synchronized (dBAppenderBase) {
                this.subAppend(eventObject, connection, insertStatement);
                eventId = this.selectEventId(insertStatement, connection);
            }
            System.out.println("eventid=" + eventId);
            this.secondarySubAppend(eventObject, connection, eventId);
            this.close(insertStatement);
            insertStatement = null;
            connection.commit();
        }
        catch (Throwable sqle) {
            this.addError("problem appending event", sqle);
        }
        finally {
            DBHelper.closeConnection(connection);
        }
    }

    protected abstract void subAppend(E var1, Connection var2, PreparedStatement var3) throws Throwable;

    protected abstract void secondarySubAppend(E var1, Connection var2, long var3) throws Throwable;

    protected long selectEventId(PreparedStatement insertStatement, Connection connection) throws SQLException, InvocationTargetException {
        ResultSet rs = null;
        Statement idStatement = null;
        boolean gotGeneratedKeys = false;
        if (this.cnxSupportsGetGeneratedKeys) {
            try {
                rs = (ResultSet)this.getGeneratedKeysMethod().invoke((Object)insertStatement, (Object[])null);
                gotGeneratedKeys = true;
            }
            catch (InvocationTargetException ex) {
                Throwable target = ex.getTargetException();
                if (target instanceof SQLException) {
                    throw (SQLException)target;
                }
                throw ex;
            }
            catch (IllegalAccessException ex) {
                this.addWarn("IllegalAccessException invoking PreparedStatement.getGeneratedKeys", ex);
            }
        }
        if (!gotGeneratedKeys) {
            idStatement = connection.createStatement();
            idStatement.setMaxRows(1);
            String selectInsertIdStr = this.sqlDialect.getSelectInsertId();
            rs = idStatement.executeQuery(selectInsertIdStr);
        }
        rs.next();
        long eventId = rs.getLong(1);
        rs.close();
        this.close(idStatement);
        idStatement = null;
        return eventId;
    }

    void close(Statement statement) throws SQLException {
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public void stop() {
        super.stop();
    }
}

