/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.store.Data;
import org.h2.store.DataPage;
import org.h2.store.PageStore;
import org.h2.store.Record;

public class PageStreamData
extends Record {
    private static final int LENGTH_START = 5;
    private static final int DATA_START = 9;
    private final PageStore store;
    private int trunk;
    private Data data;
    private int remaining;
    private int length;

    PageStreamData(PageStore pageStore, int n, int n2) {
        this.setPos(n);
        this.store = pageStore;
        this.trunk = n2;
    }

    void read() throws SQLException {
        this.data = this.store.createData();
        this.store.readPage(this.getPos(), this.data);
        this.trunk = this.data.readInt();
        this.data.setPos(4);
        int n = this.data.readByte();
        if (n != 8) {
            throw Message.getSQLException(90030, "pos:" + this.getPos() + " type:" + n + " expected type:" + 8);
        }
        this.length = this.data.readInt();
    }

    public int getByteCount(DataPage dataPage) {
        return this.store.getPageSize();
    }

    void initWrite() {
        this.data = this.store.createData();
        this.data.writeInt(this.trunk);
        this.data.writeByte((byte)8);
        this.data.writeInt(0);
        this.remaining = this.store.getPageSize() - this.data.length();
        this.length = 0;
    }

    int write(byte[] byArray, int n, int n2) {
        int n3 = Math.min(this.remaining, n2);
        this.data.write(byArray, n, n3);
        this.length += n3;
        this.remaining -= n3;
        return n3;
    }

    public void write(DataPage dataPage) throws SQLException {
        this.data.setInt(5, this.length);
        this.store.writePage(this.getPos(), this.data);
    }

    static int getCapacity(int n) {
        return n - 9;
    }

    int getLength() {
        return this.length;
    }

    void read(byte[] byArray, int n, int n2) {
        this.data.read(byArray, n, n2);
    }

    int getRemaining() {
        return this.remaining;
    }

    public int getMemorySize() {
        return this.store.getPageSize() >> 2;
    }
}

