/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.FunctionCall;
import org.h2.expression.TableFunction;
import org.h2.index.FunctionIndex;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionTable
extends Table {
    private final FunctionCall function;
    private final long rowCount;
    private Expression functionExpr;
    private LocalResult cachedResult;
    private Value cachedValue;

    public FunctionTable(Schema schema, Session session, Expression expression, FunctionCall functionCall) throws SQLException {
        super(schema, 0, functionCall.getName(), false, true);
        this.functionExpr = expression;
        this.function = functionCall;
        this.rowCount = functionCall instanceof TableFunction ? ((TableFunction)functionCall).getRowCount() : Long.MAX_VALUE;
        functionCall.optimize(session);
        int n = functionCall.getType();
        if (n != 18) {
            throw Message.getSQLException(90000, functionCall.getName());
        }
        int n2 = functionCall.getParameterCount();
        Expression[] expressionArray = new Expression[n2];
        Expression[] expressionArray2 = functionCall.getArgs();
        for (int i = 0; i < n2; ++i) {
            expressionArray2[i] = expressionArray2[i].optimize(session);
            expressionArray[i] = expressionArray2[i];
        }
        ValueResultSet valueResultSet = functionCall.getValueForColumnList(session, expressionArray);
        if (valueResultSet == null) {
            throw Message.getSQLException(90000, functionCall.getName());
        }
        ResultSet resultSet = valueResultSet.getResultSet();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        Column[] columnArray = new Column[n3];
        for (int i = 0; i < n3; ++i) {
            columnArray[i] = new Column(resultSetMetaData.getColumnName(i + 1), DataType.convertSQLTypeToValueType(resultSetMetaData.getColumnType(i + 1)), resultSetMetaData.getPrecision(i + 1), resultSetMetaData.getScale(i + 1), resultSetMetaData.getColumnDisplaySize(i + 1));
        }
        this.setColumns(columnArray);
    }

    @Override
    public void lock(Session session, boolean bl, boolean bl2) {
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2, String string2) throws SQLException {
        throw Message.getUnsupportedException("ALIAS");
    }

    @Override
    public void removeRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException("ALIAS");
    }

    @Override
    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException("ALIAS");
    }

    @Override
    public boolean canDrop() {
        throw Message.throwInternalError();
    }

    @Override
    public void addRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException("ALIAS");
    }

    @Override
    public void checkSupportAlter() throws SQLException {
        throw Message.getUnsupportedException("ALIAS");
    }

    @Override
    public String getTableType() {
        return null;
    }

    @Override
    public Index getScanIndex(Session session) {
        return new FunctionIndex(this, IndexColumn.wrap(this.columns));
    }

    @Override
    public ObjectArray<Index> getIndexes() {
        return null;
    }

    @Override
    public boolean canGetRowCount() {
        return this.rowCount != Long.MAX_VALUE;
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException("ALIAS");
    }

    public LocalResult getResult(Session session) throws SQLException {
        this.functionExpr = this.functionExpr.optimize(session);
        Value value = this.functionExpr.getValue(session);
        if (this.cachedResult != null && this.cachedValue == value) {
            this.cachedResult.reset();
            return this.cachedResult;
        }
        if (value == ValueNull.INSTANCE) {
            return new LocalResult();
        }
        ValueResultSet valueResultSet = (ValueResultSet)value;
        ResultSet resultSet = valueResultSet.getResultSet();
        LocalResult localResult = LocalResult.read(session, resultSet, 0);
        if (this.function.isDeterministic()) {
            this.cachedResult = localResult;
            this.cachedValue = value;
        }
        return localResult;
    }

    @Override
    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public String getSQL() {
        return this.function.getSQL();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public boolean isDeterministic() {
        return this.function.isDeterministic();
    }
}

