/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.customengine.rules.pingSco;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.ebam.customengine.IEbamBaseRule;
import org.eclipse.ebam.customengine.utils.MsgReadUtils;
import org.eclipse.ebam.event.EbamEvent;
import org.eclipse.ebam.event.IEbamEvent;
import org.eclipse.ebam.messages.EbamMessage;
import org.eclipse.ebam.messages.IEbamMessage;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingScoNumberErrorRule
implements IEbamBaseRule {
    Map<String, AziendaMessages> aziendaErrors = new HashMap<String, AziendaMessages>();
    SbiAlarm sbiAlarm = null;
    public static final String STATO = "//*/DTL/STATO";
    public static final String AZIENDA = "//*/DTL/AZND";
    public static final String ERRORE = "//*/DTL/ERRORE";
    public static final String INATTIVO = "INATTIVO";
    int maxErrors = -1;
    private static Logger logger = LoggerFactory.getLogger(PingScoNumberErrorRule.class);
    private int maxErrorDefault = 3;
    private int monitorInterval = 10;

    public void init(String config) {
        logger.debug("IN");
        EbamMessage tempM = new EbamMessage();
        tempM.setMsg(config);
        String maxErrorDefaultS = MsgReadUtils.extractByQuery((IEbamMessage)tempM, "//*/MAX_ERROR_DEFAULT", null);
        String monitorIntervalS = MsgReadUtils.extractByQuery((IEbamMessage)tempM, "//*/MONITOR_INTERVAL", null);
        if (maxErrorDefaultS != null) {
            this.maxErrorDefault = Integer.valueOf(maxErrorDefaultS);
            logger.debug("max errors default get by rule definition is " + maxErrorDefaultS);
        }
        if (monitorIntervalS != null) {
            this.monitorInterval = Integer.valueOf(monitorIntervalS);
            logger.debug("monitor interval default get by rule definition is " + monitorIntervalS);
        }
        logger.debug("OUT");
    }

    public IEbamEvent executeRule(IEbamMessage msg) {
        logger.debug("IN");
        IEbamEvent toReturn = null;
        String azienda = MsgReadUtils.extractByQuery(msg, AZIENDA, null);
        logger.info("Azienda=" + azienda);
        boolean generateEvent = this.checkErrors(azienda, msg);
        if (generateEvent) {
            toReturn = this.createEvent();
        }
        logger.debug("OUT");
        return toReturn;
    }

    public boolean checkErrors(String azienda, IEbamMessage msg) {
        AziendaMessages aziendaMessages;
        String stato;
        logger.debug("IN");
        boolean toReturn = false;
        String errore = MsgReadUtils.extractByQuery(msg, ERRORE, null);
        boolean isAnError = false;
        if (errore != null && !errore.equals("")) {
            logger.debug("E' un errore per l'azienda: " + azienda);
            isAnError = true;
        }
        if ((stato = MsgReadUtils.extractByQuery(msg, STATO, null)) != null && stato.equals(INATTIVO)) {
            logger.debug("E' uno stato inattivo per l'azienda: " + azienda);
            isAnError = true;
        }
        if (!isAnError) {
            logger.debug("It's not an inportant message, skip ");
            return false;
        }
        if (this.maxErrors == -1) {
            this.maxErrors = this.maxErrorDefault;
            if (this.sbiAlarm != null && this.sbiAlarm.getSbiThresholdValue() != null) {
                this.maxErrors = (int)this.sbiAlarm.getSbiThresholdValue().getMinValue();
                logger.debug("Threshold readed (" + this.sbiAlarm.getSbiThresholdValue().getLabel() + "), maxErrors=" + this.maxErrors);
            }
        }
        if ((aziendaMessages = this.aziendaErrors.get(azienda)) == null) {
            aziendaMessages = new AziendaMessages();
            this.aziendaErrors.put(azienda, aziendaMessages);
            logger.debug("first message for azienda " + azienda + " cretae inner clas AziendaMessages");
        }
        aziendaMessages.addMessage(isAnError);
        if (aziendaMessages.getErrorCounter() >= this.maxErrors) {
            toReturn = true;
            logger.info("More than limit error for azienda " + azienda + "there are " + aziendaMessages.getErrorCounter() + " errors");
        }
        if (aziendaMessages.getMessages().size() >= this.monitorInterval) {
            aziendaMessages.cleanFirstMessage();
        }
        logger.debug("Return:" + toReturn);
        return toReturn;
    }

    public IEbamEvent createEvent() {
        EbamEvent ev = new EbamEvent();
        ev.setType("ALARM");
        if (this.sbiAlarm != null) {
            ev.setAlarm(this.sbiAlarm);
        } else {
            logger.warn("alarm not found");
        }
        return ev;
    }

    public SbiAlarm getSbiAlarm() {
        return this.sbiAlarm;
    }

    public void setSbiAlarm(SbiAlarm sbiAlarm) {
        this.sbiAlarm = sbiAlarm;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AziendaMessages {
        private Vector<Boolean> messages = new Vector();
        int errorCounter = 0;

        public void addMessage(Boolean error) {
            this.messages.add(error);
            if (error.booleanValue()) {
                ++this.errorCounter;
            }
        }

        public void cleanFirstMessage() {
            if (this.messages.get(0).booleanValue()) {
                --this.errorCounter;
            }
            this.messages.remove(0);
        }

        public Vector<Boolean> getMessages() {
            return this.messages;
        }

        public void setMessages(Vector<Boolean> messages) {
            this.messages = messages;
        }

        public int getErrorCounter() {
            return this.errorCounter;
        }

        public void setErrorCounter(int errorCounter) {
            this.errorCounter = errorCounter;
        }
    }
}

