/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.dynamic;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.dynamic.DynamicClassWriter;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicClassLoader
extends ClassLoader {
    protected Map<String, DynamicClassWriter> classWriters = new HashMap<String, DynamicClassWriter>();
    public DynamicClassWriter defaultWriter = new DynamicClassWriter();

    public DynamicClassLoader(ClassLoader delegate) {
        super(delegate);
    }

    public DynamicClassLoader(ClassLoader delegate, DynamicClassWriter writer) {
        this(delegate);
        this.defaultWriter = writer;
    }

    public DynamicClassWriter getDefaultWriter() {
        return this.defaultWriter;
    }

    protected Map<String, DynamicClassWriter> getClassWriters() {
        return this.classWriters;
    }

    public DynamicClassWriter getClassWriter(String className) {
        return this.getClassWriters().get(className);
    }

    public void addClass(String className) {
        this.addClass(className, this.getDefaultWriter());
    }

    public void addClass(String className, Class<?> parentClass) {
        this.addClass(className, this.getDefaultWriter().createCopy(parentClass));
    }

    public void addClass(String className, DynamicClassWriter writer) throws DynamicException {
        DynamicClassWriter existingWriter = this.getClassWriter(className);
        if (existingWriter != null) {
            if (!existingWriter.isCompatible(writer)) {
                throw DynamicException.incompatibleDuplicateWriters(className, existingWriter, writer);
            }
        } else {
            this.getClassWriters().put(className, writer == null ? this.getDefaultWriter() : writer);
        }
    }

    public Class<?> createDynamicClass(String className, DynamicClassWriter writer) {
        this.addClass(className, writer);
        Class<?> newDynamicClass = null;
        try {
            newDynamicClass = this.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("DyanmicClassLoader: could not create class " + className);
        }
        return this.checkAssignable(newDynamicClass);
    }

    protected Class<?> checkAssignable(Class<?> clz) {
        DynamicClassWriter assignedClassWriter = this.getClassWriters().get(clz.getName());
        if (!assignedClassWriter.parentClass.isAssignableFrom(clz)) {
            throw new IllegalArgumentException("DyanmicClassLoader: " + clz.getName() + " not compatible with parent class " + assignedClassWriter.parentClass.getName());
        }
        return clz;
    }

    public Class<?> createDynamicClass(String className) {
        return this.createDynamicClass(className, this.getDefaultWriter());
    }

    public Class<?> createDynamicClass(String className, Class<?> parentClass) {
        return this.createDynamicClass(className, new DynamicClassWriter(parentClass));
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        DynamicClassWriter writer = this.getClassWriter(className);
        if (writer != null) {
            try {
                byte[] bytes = writer.writeClass(this, className);
                return this.defineClass(className, bytes, 0, bytes.length);
            }
            catch (ClassFormatError cfe) {
                throw new ClassNotFoundException(className, cfe);
            }
            catch (ClassCircularityError cce) {
                throw new ClassNotFoundException(className, cce);
            }
        }
        return super.findClass(className);
    }

    public static DynamicClassLoader lookup(Session session) {
        ConversionManager cm = null;
        cm = session == null ? ConversionManager.getDefaultManager() : session.getPlatform().getConversionManager();
        if (cm.getLoader() instanceof DynamicClassLoader) {
            return (DynamicClassLoader)cm.getLoader();
        }
        DynamicClassLoader dcl = new DynamicClassLoader(cm.getLoader());
        cm.setLoader(dcl);
        if (session == null) {
            ConversionManager.setDefaultLoader(dcl);
        }
        return dcl;
    }
}

