/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.h2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;
import org.h2.tools.Server;
import org.h2.util.JdbcUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBaseActivator
implements BundleActivator {
    private static Logger logger = LoggerFactory.getLogger(DataBaseActivator.class);

    public void start(BundleContext context) throws Exception {
        logger.info("IN");
        ResourceBundle res = ResourceBundle.getBundle("ebamDB/url");
        String ebamDbUrl = res.getString("h2Url");
        logger.info(" Url of the H2 Database: " + ebamDbUrl);
        try {
            logger.info("Starting up embedded database");
            Thread h2 = new Thread(new Runnable(){
                String[] h2Parameters = new String[]{"-tcp", "-web"};

                public void run() {
                    try {
                        Server.main((String[])this.h2Parameters);
                    }
                    catch (SQLException e) {
                        logger.error("SQLException", (Throwable)e);
                    }
                }
            });
            h2.start();
            logger.info("Countdown waiting for H2 to start");
            logger.info("5...");
            Thread.sleep(1000L);
            logger.info("4...");
            Thread.sleep(1000L);
            logger.info("3...");
            Thread.sleep(1000L);
            logger.info("2...");
            Thread.sleep(1000L);
            logger.info("1...");
            Thread.sleep(1000L);
            logger.info("Starting H2 Database");
            Thread.sleep(1000L);
        }
        catch (Throwable e) {
            logger.error("Warning has Occured in H2database Activator", e);
        }
        logger.info("OUT");
    }

    private void executeSQLSilently(String url, String user, String password, String sql) {
        try {
            DataBaseActivator.executeSQL(url, user, password, sql);
        }
        catch (Throwable t) {
            logger.error("Throwable", t);
        }
    }

    private static void executeSQL(String url, String user, String password, String sql) throws SQLException {
        block5: {
            Connection conn = null;
            Statement stat = null;
            try {
                try {
                    Connection connection = DriverManager.getConnection(url, user, password);
                    stat = connection.createStatement();
                    stat.execute(sql);
                }
                catch (Throwable t) {
                    logger.error("Throwable", t);
                    JdbcUtils.closeSilently((Statement)stat);
                    JdbcUtils.closeSilently(conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.closeSilently(stat);
                JdbcUtils.closeSilently(conn);
                throw throwable;
            }
            JdbcUtils.closeSilently((Statement)stat);
            JdbcUtils.closeSilently(conn);
        }
    }

    public void stop(BundleContext context) throws Exception {
    }
}

