/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.filters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.internal.filters.FilterAtomImpl;
import org.eclipse.hyades.logging.adapter.internal.filters.FilterElementImpl;
import org.eclipse.hyades.logging.adapter.internal.filters.IFilterAtom;
import org.eclipse.hyades.logging.adapter.internal.filters.IFilterBlock;
import org.eclipse.hyades.logging.adapter.internal.filters.IFilterElement;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FilterBlockImpl
extends FilterElementImpl
implements IFilterBlock {
    public static final String AND = "AND";
    public static final String OR = "OR";
    private List childFilters = new ArrayList();

    public void prepareFilter(Element node) throws AdapterInvalidConfig {
        super.prepareFilter(node);
        if (!this.getOperator().equals(AND) && !this.getOperator().equals(OR)) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAFilter_FilterRuleBlock_Invalid_Operator_ERROR_", this.getOperator()));
        }
        this.childFilters = new ArrayList();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            block7: {
                FilterElementImpl element;
                Element child = null;
                try {
                    child = (Element)children.item(i);
                }
                catch (ClassCastException classCastException) {
                    break block7;
                }
                if (child.getNodeName().endsWith(Messages.getString("HyadesGAFilterRuleBlockElementTagName"))) {
                    element = new FilterBlockImpl();
                    element.prepareFilter(child);
                    this.childFilters.add(element);
                } else if (child.getNodeName().endsWith(Messages.getString("HyadesGAFilterRuleElementTagName"))) {
                    element = new FilterAtomImpl();
                    element.prepareFilter(child);
                    this.childFilters.add(element);
                }
            }
            ++i;
        }
    }

    public List getFilterElements() {
        return this.childFilters;
    }

    public void addFilterElement(IFilterElement element) {
        this.childFilters.add(element);
    }

    public boolean evaluateFilter() {
        return this.processFilterElement(this);
    }

    private boolean processFilterElement(IFilterElement element) {
        try {
            IFilterBlock current = (IFilterBlock)element;
            String operator = current.getOperator();
            if (operator.equals(AND)) {
                return this.and(current);
            }
            if (operator.equals(OR)) {
                return this.or(current);
            }
        }
        catch (ClassCastException classCastException) {
            return ((IFilterAtom)element).evaluateFilter();
        }
        return false;
    }

    private boolean and(IFilterBlock block) {
        Iterator rules = block.getFilterElements().iterator();
        while (rules.hasNext()) {
            IFilterElement element = (IFilterElement)rules.next();
            if (this.processFilterElement(element)) continue;
            return block.isNegated();
        }
        return !block.isNegated();
    }

    private boolean or(IFilterBlock block) {
        Iterator rules = block.getFilterElements().iterator();
        while (rules.hasNext()) {
            IFilterElement element = (IFilterElement)rules.next();
            if (!this.processFilterElement(element)) continue;
            return !block.isNegated();
        }
        return block.isNegated();
    }

    public int requiresCache() {
        Iterator rules = this.getFilterElements().iterator();
        while (rules.hasNext()) {
            FilterElementImpl element = (FilterElementImpl)rules.next();
            if (element.requiresCache() <= 0) continue;
            return element.requiresCache();
        }
        return 0;
    }
}

