/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;


/**
 * The persistent class for the ebam_event_contents database table.
 * 
 */
@Entity
@Table(name="ebam_event_contents")
public class EventContent implements Serializable {
	private static final long serialVersionUID = 1L;

	 @TableGenerator(name="ECId", table="ID_GEN",
	            pkColumnName="ID_NAME", valueColumnName="ID_VAL",
	            pkColumnValue="EVENT_CONTENT_ID", allocationSize=1)
		
	  
	@Id
	@GeneratedValue(generator="ECId", strategy=GenerationType.TABLE)   
	@Column(name="EVENT_CONTENT_ID")
	private int eventContantId;

	@Column(name="NAME")
	private String name;

	@Column(name="VALUE")
	private String value;

	//bi-directional many-to-one association to EbamEventAttribute
    @ManyToOne
	@JoinColumn(name="EVENT_ATTR_ID")
	private EventAttribute ebamEventAttribute;

	//bi-directional many-to-one association to EbamEventJournal
    @ManyToOne
	@JoinColumn(name="EVENT_JOURNAL_ID")
	private EventJournal ebamEventJournal;

    public EventContent() {
    }

	public int getEventContantId() {
		return this.eventContantId;
	}

	public void setEventContantId(int eventContantId) {
		this.eventContantId = eventContantId;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return this.value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public EventAttribute getEbamEventAttribute() {
		return this.ebamEventAttribute;
	}

	public void setEbamEventAttribute(EventAttribute ebamEventAttribute) {
		this.ebamEventAttribute = ebamEventAttribute;
	}
	
	public EventJournal getEbamEventJournal() {
		return this.ebamEventJournal;
	}

	public void setEbamEventJournal(EventJournal ebamEventJournal) {
		this.ebamEventJournal = ebamEventJournal;
	}
	
}