/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.customengine;

import org.eclipse.ebam.customengine.IEbamBaseRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleFactory {
    private static Logger logger = LoggerFactory.getLogger(RuleFactory.class);

    IEbamBaseRule createRule(String ruleClass) {
        logger.debug("IN");
        IEbamBaseRule toReturn = null;
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(ruleClass);
            Object obj = clazz.newInstance();
            toReturn = (IEbamBaseRule)obj;
        }
        catch (ClassCastException e) {
            logger.error("Class does not implement IEbamBaseRule as should be ", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error("Class not found ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("error in loading the rule ", (Throwable)e);
        }
        logger.debug("OUT");
        return toReturn;
    }
}

