/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.emf;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.Query;

import org.eclipse.ebam.model.entities.SbiThreshold;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;



public class SbiThresholdTransactions extends EMF {

	/**
	 * Logger.
	 */
	private static Logger logger = 
		LoggerFactory.getLogger(SbiThresholdTransactions.class);


	/** Get all thresholds .
	 * 
	 * @return list of alarms
	 * @throws Exception
	 */

	public final List getSbiThresholdList() throws Exception {
		List thres = null;
		EntityManager em = getEMF().createEntityManager();
		try {
			// remove from cache because could have been changed outside of program
			getEMF().getCache().evict(SbiThreshold.class);	

			Query query = em.createQuery("select s from "
					+ "SbiThreshold s");
			thres = query.getResultList();
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {			
			em.close();
		}
		return thres;
	}
	
	
	public final SbiThreshold getSbiThresholdById(Integer thresId) throws Exception {
		SbiThreshold thres = null;
		EntityManager em = getEMF().createEntityManager();
		try {
			// remove from cache because could have been changed outside of program
			getEMF().getCache().evict(SbiThreshold.class);	
			Query query = em.createQuery("select s from "
					+ "SbiThreshold s where s.thresholdId = :id");
			query.setParameter("id", thresId);
			thres =(SbiThreshold) query.getSingleResult();
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {			
			em.close();
		}
		return thres;
	}


//	/** get AlarmContact by id
//	 * 
//	 * @param id
//	 * @return one AlarmContact
//	 * @throws Exception
//	 */
//
//	public final SbiAlarmContact getSbiAlarmContactById(Integer id) 
//	throws Exception {
//		SbiAlarmContact alarmContact = null;
//		EntityManager em = getEMF().createEntityManager();
//		try {
//			Query query = em.createQuery("select s from "
//					+ "SbiAlarmContact s where s.alarmContactId = :id");
//			query.setParameter("id", id);
//			alarmContact = (SbiAlarmContact) query.getSingleResult();        
//
//		} catch (Exception e) {
//			logger.error(e.getMessage(), e);
//		} finally {			
//			em.close();
//		}
//		return alarmContact;
//	}	
//
//
	
	public final boolean mergeSbiThreshold(final SbiThreshold sbiThreshold) throws Exception {
		boolean isSaved = false;
		EntityManager em = getEMF().createEntityManager();
		try {
			em.getTransaction().begin();

			// Set the flush-mode so the manager query does not force a 
			// write before the read.
			em.setFlushMode(FlushModeType.COMMIT);

			//take all contacts

			em.merge(sbiThreshold);

			em.getTransaction().commit();

			isSaved = true;

		} catch (Exception e) {
			if (em.getTransaction() != null && em.getTransaction().isActive()) {
				em.getTransaction().rollback();
			}			
			logger.error(e.getMessage(), e);
			throw e;
		} finally {			
			em.close();			
		}
		return isSaved;
	}

	/**
	 *  delte sbi Threshold.
	 * @param sbiThreshold
	 * @return
	 * @throws Exception
	 */
	public final boolean deleteSbiThreshold(final SbiThreshold sbiThreshold) throws Exception {
		boolean isSaved = false;
		EntityManager em = getEMF().createEntityManager();
		try {
			em.getTransaction().begin();

			em.setFlushMode(FlushModeType.COMMIT);

			SbiThreshold toRemove = 
				em.find(SbiThreshold.class, sbiThreshold.getThresholdId());
			toRemove.setSbiThresholdValues(null);
			em.remove(toRemove);

			em.getTransaction().commit();

			isSaved = true;

		} catch (Exception e) {
			if (em.getTransaction() != null && em.getTransaction().isActive()) {
				em.getTransaction().rollback();
			}			
			logger.error(e.getMessage(), e);
			throw e;
		} finally {			
			em.close();			
		}
		return isSaved;
	}

	
	
	/**Method that persists <code>SbiThreshold</code> on database.
	 * @param j <code>SbiThresholdValue</code> to save
	 * @return operation result
	 * @throws Exception error on saving 
	 */
	public final boolean createNewSbiThreshold(final SbiThreshold sbiThreshold) throws Exception {
		boolean isSaved = false;
		EntityManager em = getEMF().createEntityManager();
		try {
			em.getTransaction().begin();

			// Set the flush-mode so the manager query does not force a 
			// write before the read.
			em.setFlushMode(FlushModeType.COMMIT);

			em.persist(sbiThreshold);

			em.getTransaction().commit();

			isSaved = true;

		} catch (Exception e) {
			if (em.getTransaction() != null && em.getTransaction().isActive()) {
				em.getTransaction().rollback();
			}			
			logger.error(e.getMessage(), e);
			throw e;
		} finally {			
			em.close();			
		}
		return isSaved;
	}
	

	
}



