/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateChangeRecord;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.TransformationMappingChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.tools.profiler.QueryMonitor;

public abstract class DatabaseQueryMechanism
implements Cloneable,
Serializable {
    protected DatabaseQuery query;

    public DatabaseQueryMechanism() {
    }

    public DatabaseQueryMechanism(DatabaseQuery query) {
        this.query = query;
    }

    protected void addWriteLockFieldForInsert() {
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getDescriptor().getOptimisticLockingPolicy().setupWriteFieldsForInsert(this.getWriteObjectQuery());
        }
    }

    public void buildSelectionCriteria(AbstractSession session) {
    }

    public Object checkCacheForObject(AbstractRecord translationRow, AbstractSession session) {
        if (translationRow == null || translationRow.isEmpty()) {
            return null;
        }
        Vector queryFields = this.query.getCall() == null ? this.query.getArguments() : this.query.getCall().getParameters();
        ClassDescriptor descriptor = this.getDescriptor();
        List<DatabaseField> primaryKeyFields = descriptor.getPrimaryKeyFields();
        Vector<Object> primaryKeyValues = new Vector<Object>(primaryKeyFields.size());
        for (DatabaseField primaryKeyField : primaryKeyFields) {
            if (queryFields.contains(primaryKeyField)) {
                Object value = translationRow.get(primaryKeyField);
                if (value == null) {
                    return null;
                }
                primaryKeyValues.add(value);
                continue;
            }
            return null;
        }
        if (descriptor.shouldAcquireCascadedLocks()) {
            return session.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(primaryKeyValues, this.getReadObjectQuery().getReferenceClass(), false, descriptor);
        }
        return session.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKeyValues, this.getReadObjectQuery().getReferenceClass(), false, descriptor);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public DatabaseQueryMechanism clone(DatabaseQuery queryClone) {
        DatabaseQueryMechanism clone = (DatabaseQueryMechanism)this.clone();
        clone.setQuery(queryClone);
        return clone;
    }

    public abstract DatabaseCall cursorSelectAllRows() throws DatabaseException;

    public boolean isJPQLCallQueryMechanism() {
        return false;
    }

    public abstract Integer deleteAll() throws DatabaseException;

    public abstract Integer deleteObject() throws DatabaseException;

    public abstract Integer executeNoSelect() throws DatabaseException;

    public abstract Vector executeSelect() throws DatabaseException;

    public Object executeWrite() throws DatabaseException, OptimisticLockException {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        Object object = writeQuery.getObject();
        CommitManager commitManager = this.getSession().getCommitManager();
        if (commitManager.isCommitCompletedOrInPost(object)) {
            return object;
        }
        if (commitManager.isCommitInPreModify(object)) {
            this.shallowInsertObjectForWrite(object, writeQuery, commitManager);
            return object;
        }
        try {
            this.getSession().beginTransaction();
            if (writeQuery.getObjectChangeSet() == null && this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(0, writeQuery));
            }
            writeQuery.executeCommit();
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(1, writeQuery));
            }
            this.getSession().commitTransaction();
            commitManager.markCommitCompleted(object);
            return object;
        }
        catch (RuntimeException exception) {
            this.getSession().rollbackTransaction();
            commitManager.markCommitCompleted(object);
            throw exception;
        }
    }

    public Object executeWriteWithChangeSet() throws DatabaseException, OptimisticLockException {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        ObjectChangeSet objectChangeSet = writeQuery.getObjectChangeSet();
        ClassDescriptor descriptor = this.getDescriptor();
        AbstractSession session = this.getSession();
        CommitManager commitManager = session.getCommitManager();
        Object object = writeQuery.getObject();
        if (!objectChangeSet.hasChanges() && !objectChangeSet.hasForcedChanges()) {
            commitManager.markCommitCompleted(object);
            return object;
        }
        if (commitManager.isCommitCompletedOrInPost(object)) {
            return object;
        }
        try {
            writeQuery.executeCommitWithChangeSet();
            if (descriptor.getEventManager().hasAnyEventListeners()) {
                descriptor.getEventManager().executeEvent(new DescriptorEvent(1, writeQuery));
            }
            commitManager.markCommitCompleted(object);
            return object;
        }
        catch (RuntimeException exception) {
            commitManager.markCommitCompleted(object);
            throw exception;
        }
    }

    protected ClassDescriptor getDescriptor() {
        return this.query.getDescriptor();
    }

    public AbstractRecord getModifyRow() {
        if (this.query.isModifyQuery()) {
            return ((ModifyQuery)this.query).getModifyRow();
        }
        return null;
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    protected ReadObjectQuery getReadObjectQuery() {
        return (ReadObjectQuery)this.query;
    }

    public Expression getSelectionCriteria() {
        return null;
    }

    protected AbstractSession getSession() {
        return this.query.getSession();
    }

    protected AbstractRecord getTranslationRow() {
        return this.query.getTranslationRow();
    }

    protected WriteObjectQuery getWriteObjectQuery() {
        return (WriteObjectQuery)this.query;
    }

    public abstract void insertObject() throws DatabaseException;

    public void insertObject(boolean reprepare) {
        this.insertObject();
    }

    public void insertObjectForWrite() {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        ClassDescriptor descriptor = this.getDescriptor();
        DescriptorQueryManager queryManager = descriptor.getQueryManager();
        if (!writeQuery.isUserDefined() && queryManager.hasInsertQuery() && this.isExpressionQueryMechanism()) {
            this.performUserDefinedInsert();
            return;
        }
        Object object = writeQuery.getObject();
        AbstractSession session = writeQuery.getSession();
        ObjectChangeSet changeSet = writeQuery.getObjectChangeSet();
        CommitManager commitManager = session.getCommitManager();
        DescriptorEventManager eventManager = descriptor.getEventManager();
        commitManager.markPreModifyCommitInProgress(object);
        if (changeSet == null && eventManager.hasAnyEventListeners()) {
            eventManager.executeEvent(new DescriptorEvent(4, writeQuery));
        }
        if (writeQuery.shouldCascadeParts()) {
            queryManager.preInsert(writeQuery);
        }
        if (commitManager.isShallowCommitted(object)) {
            this.updateForeignKeyFieldAfterInsert();
        } else {
            AbstractRecord modifyRow = writeQuery.getModifyRow();
            if (modifyRow == null) {
                if (writeQuery.shouldCascadeParts()) {
                    writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRow(object, session));
                } else {
                    writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRowForShallowInsert(object, session));
                }
            } else if (writeQuery.shouldCascadeParts()) {
                writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRow(modifyRow, object, session));
            } else {
                writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRowForShallowInsert(modifyRow, object, session));
            }
            modifyRow = this.getModifyRow();
            writeQuery.setTranslationRow(modifyRow);
            if (!descriptor.isAggregateCollectionDescriptor()) {
                writeQuery.setPrimaryKey(descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, session));
            }
            this.addWriteLockFieldForInsert();
            int modifyRowSize = modifyRow.size();
            if (eventManager.hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(12, writeQuery);
                event.setRecord(modifyRow);
                eventManager.executeEvent(event);
            }
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementInsert(writeQuery);
            }
            this.insertObject(modifyRowSize != modifyRow.size());
            this.registerObjectInIdentityMap(object, descriptor, session);
        }
        commitManager.markPostModifyCommitInProgress(object);
        if (writeQuery.shouldCascadeParts()) {
            queryManager.postInsert(writeQuery);
        }
        if (descriptor.getHistoryPolicy() != null && descriptor.getHistoryPolicy().shouldHandleWrites()) {
            descriptor.getHistoryPolicy().postInsert(writeQuery);
        }
        if (eventManager.hasAnyEventListeners()) {
            eventManager.executeEvent(new DescriptorEvent(5, writeQuery));
        }
    }

    public boolean isCallQueryMechanism() {
        return false;
    }

    public boolean isExpressionQueryMechanism() {
        return false;
    }

    public boolean isQueryByExampleMechanism() {
        return false;
    }

    public boolean isStatementQueryMechanism() {
        return false;
    }

    protected void performUserDefinedInsert() {
        this.performUserDefinedWrite(this.getDescriptor().getQueryManager().getInsertQuery());
    }

    protected void performUserDefinedUpdate() {
        this.performUserDefinedWrite(this.getDescriptor().getQueryManager().getUpdateQuery());
    }

    protected void performUserDefinedWrite(WriteObjectQuery userDefinedWriteQuery) {
        WriteObjectQuery query = this.getWriteObjectQuery();
        userDefinedWriteQuery.checkPrepare(query.getSession(), query.getTranslationRow());
        WriteObjectQuery writeQuery = (WriteObjectQuery)userDefinedWriteQuery.clone();
        writeQuery.setIsExecutionClone(true);
        writeQuery.setObject(query.getObject());
        writeQuery.setObjectChangeSet(query.getObjectChangeSet());
        writeQuery.setCascadePolicy(query.getCascadePolicy());
        writeQuery.setShouldMaintainCache(query.shouldMaintainCache());
        writeQuery.setTranslationRow(query.getTranslationRow());
        writeQuery.setModifyRow(query.getModifyRow());
        writeQuery.setPrimaryKey(query.getPrimaryKey());
        writeQuery.setSession(query.getSession());
        if (writeQuery.getObjectChangeSet() != null) {
            writeQuery.executeCommitWithChangeSet();
        } else {
            writeQuery.executeCommit();
        }
    }

    public void prepare() throws QueryException {
    }

    public abstract void prepareCursorSelectAllRows() throws QueryException;

    public abstract void prepareDeleteAll() throws QueryException;

    public abstract void prepareDeleteObject() throws QueryException;

    public abstract void prepareDoesExist(DatabaseField var1) throws QueryException;

    public abstract void prepareExecuteNoSelect() throws QueryException;

    public abstract void prepareExecuteSelect() throws QueryException;

    public abstract void prepareInsertObject() throws QueryException;

    public abstract void prepareReportQuerySelectAllRows() throws QueryException;

    public abstract void prepareReportQuerySubSelect() throws QueryException;

    public abstract void prepareSelectAllRows() throws QueryException;

    public abstract void prepareSelectOneRow() throws QueryException;

    public abstract void prepareUpdateObject() throws QueryException;

    public abstract void prepareUpdateAll() throws QueryException;

    protected void registerObjectInIdentityMap(Object object, ClassDescriptor descriptor, AbstractSession session) {
        WriteObjectQuery query = this.getWriteObjectQuery();
        if (query.shouldMaintainCache()) {
            if (descriptor.usesOptimisticLocking()) {
                Object optimisticLockValue = descriptor.getOptimisticLockingPolicy().getValueToPutInCache(query.getModifyRow(), session);
                session.getIdentityMapAccessorInstance().putInIdentityMap(object, query.getPrimaryKey(), optimisticLockValue, System.currentTimeMillis(), descriptor);
            } else {
                session.getIdentityMapAccessorInstance().putInIdentityMap(object, query.getPrimaryKey(), null, System.currentTimeMillis(), descriptor);
            }
        }
    }

    public abstract Vector selectAllReportQueryRows() throws DatabaseException;

    public abstract Vector selectAllRows() throws DatabaseException;

    public abstract AbstractRecord selectOneRow() throws DatabaseException;

    public abstract AbstractRecord selectRowForDoesExist(DatabaseField var1) throws DatabaseException;

    public void setQuery(DatabaseQuery query) {
        this.query = query;
    }

    protected void shallowInsertObjectForWrite(Object object, WriteObjectQuery writeQuery, CommitManager commitManager) throws DatabaseException, OptimisticLockException {
        boolean doesExist;
        if (this.getSession().isUnitOfWork()) {
            UnitOfWorkImpl uow = (UnitOfWorkImpl)this.getSession();
            boolean bl = doesExist = !uow.isCloneNewObject(object);
            if (doesExist) {
                doesExist = uow.isObjectRegistered(object);
            }
        } else {
            DoesExistQuery existQuery = (DoesExistQuery)this.getDescriptor().getQueryManager().getDoesExistQuery().clone();
            existQuery.setObject(object);
            existQuery.setPrimaryKey(writeQuery.getPrimaryKey());
            existQuery.setDescriptor(this.getDescriptor());
            existQuery.setTranslationRow(this.getTranslationRow());
            doesExist = (Boolean)this.getSession().executeQuery(existQuery);
        }
        if (!doesExist) {
            writeQuery.dontCascadeParts();
            this.insertObjectForWrite();
            commitManager.markShallowCommit(object);
        }
    }

    protected void updateForeignKeyFieldAfterInsert() {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        Object object = writeQuery.getObject();
        writeQuery.setPrimaryKey(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession()));
        writeQuery.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, this.getSession()));
        this.updateForeignKeyFieldAfterInsert(writeQuery);
    }

    public abstract Integer updateAll() throws DatabaseException;

    public abstract Integer updateObject() throws DatabaseException;

    protected abstract void updateForeignKeyFieldAfterInsert(WriteObjectQuery var1);

    protected void updateObjectAndRowWithReturnRow(Collection returnFields, boolean isFirstCallForInsert) {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        AbstractRecord outputRow = (AbstractRecord)writeQuery.getProperties().get("output");
        if (outputRow == null || outputRow.isEmpty()) {
            return;
        }
        DatabaseRecord row = new DatabaseRecord();
        for (DatabaseField field : returnFields) {
            if (!outputRow.containsKey(field)) continue;
            row.put(field, outputRow.get(field));
        }
        if (((AbstractRecord)row).isEmpty()) {
            return;
        }
        Object object = writeQuery.getObject();
        this.getDescriptor().getObjectBuilder().assignReturnRow(object, this.getSession(), row);
        Vector primaryKeys = null;
        if (isFirstCallForInsert) {
            DatabaseRecord pkToModify = new DatabaseRecord();
            List<DatabaseField> primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
            for (int i = 0; i < primaryKeyFields.size(); ++i) {
                DatabaseField field = primaryKeyFields.get(i);
                if (!row.containsKey(field)) continue;
                pkToModify.put(field, row.get(field));
            }
            if (!((AbstractRecord)pkToModify).isEmpty()) {
                primaryKeys = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
                writeQuery.setPrimaryKey(primaryKeys);
                this.getModifyRow().putAll((Map)pkToModify);
                this.getDescriptor().getObjectBuilder().addPrimaryKeyForNonDefaultTable(this.getModifyRow(), object, this.getSession());
            }
        }
        if (this.getSession().isUnitOfWork()) {
            ObjectChangeSet objectChangeSet = writeQuery.getObjectChangeSet();
            if (objectChangeSet == null && ((UnitOfWorkImpl)this.getSession()).getUnitOfWorkChangeSet() != null) {
                objectChangeSet = (ObjectChangeSet)((UnitOfWorkImpl)this.getSession()).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object);
            }
            if (objectChangeSet != null) {
                this.updateChangeSet(this.getDescriptor(), objectChangeSet, row, object);
                if (primaryKeys != null) {
                    objectChangeSet.setCacheKey(new CacheKey(primaryKeys));
                }
            }
        }
    }

    public void updateChangeSet(ClassDescriptor desc, ObjectChangeSet objectChangeSet, AbstractRecord row, Object object) {
        int size = row.size();
        HashSet handledMappings = null;
        if (size > 1) {
            handledMappings = new HashSet(size);
        }
        for (int i = 0; i < size; ++i) {
            DatabaseField field = (DatabaseField)row.getFields().get(i);
            this.updateChangeSet(desc, objectChangeSet, field, object, handledMappings);
        }
    }

    protected void updateChangeSet(ClassDescriptor desc, ObjectChangeSet objectChangeSet, DatabaseField field, Object object) {
        this.updateChangeSet(desc, objectChangeSet, field, object, null);
    }

    protected void updateChangeSet(ClassDescriptor desc, ObjectChangeSet objectChangeSet, DatabaseField field, Object object, Collection handledMappings) {
        DatabaseMapping mapping;
        List<DatabaseMapping> readOnlyMappings = desc.getObjectBuilder().getReadOnlyMappingsForField(field);
        if (readOnlyMappings != null) {
            int size = readOnlyMappings.size();
            for (int index = 0; index < size; ++index) {
                mapping = readOnlyMappings.get(index);
                this.updateChangeSet(mapping, objectChangeSet, field, object, handledMappings);
            }
        }
        if ((mapping = desc.getObjectBuilder().getMappingForField(field)) != null) {
            this.updateChangeSet(mapping, objectChangeSet, field, object, handledMappings);
        }
    }

    protected void updateChangeSet(DatabaseMapping mapping, ObjectChangeSet objectChangeSet, DatabaseField field, Object object, Collection handledMappings) {
        if (handledMappings != null && handledMappings.contains(mapping)) {
            return;
        }
        if (mapping.isDirectToFieldMapping()) {
            Object attributeValue = mapping.getAttributeValueFromObject(object);
            objectChangeSet.updateChangeRecordForAttribute(mapping, attributeValue, this.getSession());
        } else if (mapping.isAggregateObjectMapping()) {
            Object aggregate = mapping.getAttributeValueFromObject(object);
            AggregateChangeRecord record = (AggregateChangeRecord)objectChangeSet.getChangesForAttributeNamed(mapping.getAttributeName());
            if (aggregate != null) {
                if (record == null) {
                    record = new AggregateChangeRecord(objectChangeSet);
                    record.setAttribute(mapping.getAttributeName());
                    record.setMapping(mapping);
                    objectChangeSet.addChange(record);
                }
                ObjectChangeSet aggregateChangeSet = (ObjectChangeSet)record.getChangedObject();
                ClassDescriptor aggregateDescriptor = ((AggregateObjectMapping)mapping).getReferenceDescriptor();
                if (aggregateChangeSet == null) {
                    aggregateChangeSet = aggregateDescriptor.getObjectBuilder().createObjectChangeSet(aggregate, (UnitOfWorkChangeSet)((UnitOfWorkImpl)this.getSession()).getUnitOfWorkChangeSet(), this.getSession());
                    record.setChangedObject(aggregateChangeSet);
                }
                this.updateChangeSet(aggregateDescriptor, aggregateChangeSet, field, aggregate, handledMappings);
            } else if (record != null) {
                record.setChangedObject(null);
            }
        } else if (mapping.isTransformationMapping()) {
            TransformationMappingChangeRecord record = (TransformationMappingChangeRecord)objectChangeSet.getChangesForAttributeNamed(mapping.getAttributeName());
            if (record == null) {
                record = new TransformationMappingChangeRecord(objectChangeSet);
                record.setAttribute(mapping.getAttributeName());
                record.setMapping(mapping);
                objectChangeSet.addChange(record);
            }
            DatabaseRecord transformationRow = new DatabaseRecord(mapping.getFields().size());
            int size = mapping.getFields().size();
            for (int i = 0; i < size; ++i) {
                DatabaseField fieldToAdd = mapping.getFields().get(i);
                Object value = ((AbstractTransformationMapping)mapping).valueFromObject(object, fieldToAdd, this.getSession());
                transformationRow.add(fieldToAdd, value);
            }
            record.setRow(transformationRow);
            if (handledMappings != null) {
                handledMappings.add(mapping);
            }
        } else {
            this.getSession().log(1, "query", "field_for_unsupported_mapping_returned", field, this.getDescriptor());
        }
    }

    protected void updateObjectAndRowWithSequenceNumber() throws DatabaseException {
        AbstractSession session;
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        Object object = writeQuery.getObject();
        ClassDescriptor descriptor = writeQuery.getDescriptor();
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object sequenceValue = objectBuilder.assignSequenceNumber(object, session = writeQuery.getSession());
        if (sequenceValue == null) {
            return;
        }
        Vector primaryKey = objectBuilder.extractPrimaryKeyFromObject(object, this.getSession());
        writeQuery.setPrimaryKey(primaryKey);
        DatabaseField sequenceNumberField = descriptor.getSequenceNumberField();
        AbstractRecord modifyRow = this.getModifyRow();
        modifyRow.put(sequenceNumberField, sequenceValue);
        if (descriptor.hasMultipleTables()) {
            objectBuilder.addPrimaryKeyForNonDefaultTable(modifyRow, object, session);
        }
        if (session.isUnitOfWork()) {
            ObjectChangeSet objectChangeSet = writeQuery.getObjectChangeSet();
            if (objectChangeSet == null && ((UnitOfWorkImpl)session).getUnitOfWorkChangeSet() != null) {
                objectChangeSet = (ObjectChangeSet)((UnitOfWorkImpl)session).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object);
            }
            if (objectChangeSet != null) {
                this.updateChangeSet(descriptor, objectChangeSet, sequenceNumberField, object);
                objectChangeSet.setCacheKey(new CacheKey(primaryKey));
            }
        }
    }

    public void updateObjectForWrite() {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        ClassDescriptor descriptor = this.getDescriptor();
        DescriptorQueryManager queryManager = descriptor.getQueryManager();
        if (!writeQuery.isUserDefined() && queryManager.hasUpdateQuery() && this.isExpressionQueryMechanism()) {
            this.performUserDefinedUpdate();
            return;
        }
        Object object = writeQuery.getObject();
        AbstractSession session = this.getSession();
        CommitManager commitManager = session.getCommitManager();
        commitManager.markPreModifyCommitInProgress(object);
        DescriptorEventManager eventManager = descriptor.getEventManager();
        if (writeQuery.getObjectChangeSet() == null && eventManager.hasAnyEventListeners()) {
            eventManager.executeEvent(new DescriptorEvent(6, writeQuery));
        }
        if (writeQuery.shouldCascadeParts()) {
            queryManager.preUpdate(writeQuery);
        }
        if ((writeQuery.isUserDefined() || writeQuery.isCallQuery()) && !this.getSession().isUnitOfWork()) {
            writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRow(object, this.getSession()));
        } else {
            writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRowForUpdate(writeQuery));
        }
        Boolean shouldModifyVersionField = null;
        if (session.isUnitOfWork() && ((UnitOfWorkImpl)session).hasOptimisticReadLockObjects()) {
            shouldModifyVersionField = (Boolean)((UnitOfWorkImpl)session).getOptimisticReadLockObjects().get(writeQuery.getObject());
        }
        if (!this.getModifyRow().isEmpty() || shouldModifyVersionField != null || descriptor.getCMPPolicy() != null && descriptor.getCMPPolicy().getForceUpdate()) {
            int rowCount;
            if ((writeQuery.isUserDefined() || writeQuery.isCallQuery()) && this.getSession().isUnitOfWork()) {
                writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRow(object, this.getSession()));
            }
            if (descriptor.usesOptimisticLocking()) {
                OptimisticLockingPolicy policy = descriptor.getOptimisticLockingPolicy();
                policy.addLockValuesToTranslationRow(writeQuery);
                if (!this.getModifyRow().isEmpty() || shouldModifyVersionField.booleanValue()) {
                    policy.updateRowAndObjectForUpdate(writeQuery, object);
                } else if (!shouldModifyVersionField.booleanValue() && policy instanceof VersionLockingPolicy) {
                    ((VersionLockingPolicy)policy).writeLockValueIntoRow(writeQuery, object);
                }
            }
            if (eventManager.hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(13, writeQuery);
                event.setRecord(this.getModifyRow());
                eventManager.executeEvent(event);
            }
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementUpdate(this.getWriteObjectQuery());
            }
            if ((rowCount = this.updateObject().intValue()) < 1 && session.hasEventManager()) {
                session.getEventManager().noRowsModified(writeQuery, object);
            }
            if (descriptor.usesOptimisticLocking()) {
                descriptor.getOptimisticLockingPolicy().validateUpdate(rowCount, object, writeQuery);
            }
        }
        commitManager.markPostModifyCommitInProgress(object);
        if (writeQuery.shouldCascadeParts()) {
            queryManager.postUpdate(writeQuery);
        }
        if (descriptor.getHistoryPolicy() != null && descriptor.getHistoryPolicy().shouldHandleWrites()) {
            descriptor.getHistoryPolicy().postUpdate(writeQuery);
        }
        if (eventManager.hasAnyEventListeners()) {
            eventManager.executeEvent(new DescriptorEvent(7, writeQuery));
        }
    }

    public void updateObjectForWriteWithChangeSet() {
        WriteObjectQuery writeQuery = this.getWriteObjectQuery();
        ObjectChangeSet changeSet = writeQuery.getObjectChangeSet();
        Object object = writeQuery.getObject();
        ClassDescriptor descriptor = this.getDescriptor();
        DescriptorQueryManager queryManager = descriptor.getQueryManager();
        AbstractSession session = this.getSession();
        CommitManager commitManager = session.getCommitManager();
        if (!writeQuery.isUserDefined() && queryManager.hasUpdateQuery() && this.isExpressionQueryMechanism()) {
            commitManager.markPreModifyCommitInProgress(object);
            this.performUserDefinedUpdate();
            return;
        }
        commitManager.markPreModifyCommitInProgress(object);
        DescriptorEventManager eventManager = descriptor.getEventManager();
        if (changeSet.hasChanges() && eventManager.hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(17, writeQuery);
            eventManager.executeEvent(event);
            UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)session).getUnitOfWorkChangeSet();
            if (!uowChangeSet.isChangeSetFromOutsideUOW() && writeQuery.getObjectChangeSet().shouldRecalculateAfterUpdateEvent()) {
                if (!descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                    writeQuery.getObjectChangeSet().clear(false);
                }
                if (descriptor.getObjectChangePolicy().calculateChangesForExistingObject(object, uowChangeSet, (UnitOfWorkImpl)session, descriptor, false) == null) {
                    uowChangeSet.getAllChangeSets().remove(writeQuery.getObjectChangeSet());
                }
            }
        }
        if (writeQuery.shouldCascadeParts()) {
            queryManager.preUpdate(writeQuery);
        }
        writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRowForUpdateWithChangeSet(writeQuery));
        Boolean shouldModifyVersionField = changeSet.shouldModifyVersionField();
        if (!this.getModifyRow().isEmpty() || shouldModifyVersionField != null || changeSet.hasCmpPolicyForcedUpdate()) {
            int rowCount;
            OptimisticLockingPolicy lockingPolicy;
            if (writeQuery.isUserDefined() || writeQuery.isCallQuery()) {
                writeQuery.setModifyRow(descriptor.getObjectBuilder().buildRow(object, session));
            }
            if ((lockingPolicy = descriptor.getOptimisticLockingPolicy()) != null) {
                lockingPolicy.addLockValuesToTranslationRow(writeQuery);
                if (!this.getModifyRow().isEmpty() || shouldModifyVersionField.booleanValue()) {
                    lockingPolicy.updateRowAndObjectForUpdate(writeQuery, object);
                } else if (!shouldModifyVersionField.booleanValue() && lockingPolicy instanceof VersionLockingPolicy) {
                    ((VersionLockingPolicy)lockingPolicy).writeLockValueIntoRow(writeQuery, object);
                }
            }
            if (eventManager.hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(13, writeQuery);
                event.setRecord(this.getModifyRow());
                eventManager.executeEvent(event);
            }
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementUpdate(this.getWriteObjectQuery());
            }
            if ((rowCount = this.updateObject().intValue()) < 1 && session.hasEventManager()) {
                session.getEventManager().noRowsModified(writeQuery, object);
            }
            if (lockingPolicy != null) {
                lockingPolicy.validateUpdate(rowCount, object, writeQuery);
            }
        }
        commitManager.markPostModifyCommitInProgress(object);
        if (writeQuery.shouldCascadeParts()) {
            queryManager.postUpdate(writeQuery);
        }
        if (descriptor.getHistoryPolicy() != null && descriptor.getHistoryPolicy().shouldHandleWrites()) {
            descriptor.getHistoryPolicy().postUpdate(writeQuery);
        }
        if (eventManager.hasAnyEventListeners()) {
            eventManager.executeEvent(new DescriptorEvent(7, writeQuery));
        }
    }
}

