/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.activemq.container;

import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.jms.activemq.container.ActiveMQServerChannel;
import org.eclipse.ecf.provider.jms.container.AbstractJMSServer;
import org.eclipse.ecf.provider.jms.container.JMSContainerConfig;

public class ActiveMQJMSServerContainer
extends AbstractJMSServer {
    public static final String PASSWORD_PROPERTY = "password";
    public static final String USERNAME_PROPERTY = "username";
    public static final String DEFAULT_PASSWORD = "defaultPassword";
    public static final String DEFAULT_USERNAME = "defaultUsername";

    public ActiveMQJMSServerContainer(JMSContainerConfig config) {
        super(config);
    }

    public void start() throws ECFException {
        JMSContainerConfig config = (JMSContainerConfig)this.getConfig();
        String username = (String)config.getProperties().get(USERNAME_PROPERTY);
        String password = (String)config.getProperties().get(PASSWORD_PROPERTY);
        ActiveMQServerChannel connection = new ActiveMQServerChannel(this.getReceiver(), config.getKeepAlive(), username, password);
        this.setConnection((ISynchAsynchConnection)connection);
        connection.start();
    }

    public void dispose() {
        super.dispose();
        this.getConnection().disconnect();
        this.setConnection(null);
    }
}

