/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.bindings.soap.interceptors;

import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.XMLWriter;
import org.eclipse.ebpm.messaging.core.util.StringSource;
import org.eclipse.ebpm.soap.api.Fault;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.bindings.soap.SoapConstants;
import org.eclipse.ebpm.soap.bindings.soap.SoapFault;
import org.eclipse.ebpm.soap.bindings.soap.SoapVersion;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;
import org.eclipse.ebpm.xmlutil.DOM4JUtils;
import org.w3c.dom.DocumentFragment;

public class SoapFaultOutInterceptor
extends AbstractInterceptor {
    @Override
    public void handleMessage(Message message) {
        try {
            Exception exception = message.getContent(Exception.class);
            OutputStream os = message.getContent(OutputStream.class);
            SoapVersion soapVersion = message.get(SoapVersion.class);
            if (os == null) {
                throw new NullPointerException("XMLStreamWriter content not found");
            }
            XMLWriter writer = new XMLWriter(os);
            Document doc = DocumentHelper.createDocument();
            Namespace soapNameSpace = new Namespace(soapVersion.getPrefix(), soapVersion.getNamespace());
            org.dom4j.QName soapEnvelope = new org.dom4j.QName(soapVersion.getEnvelope().getLocalPart(), soapNameSpace);
            Element soapEnvelopeNode = doc.addElement(soapEnvelope);
            if (message.getSoapHeaders().size() > 0) {
                Iterator<DocumentFragment> it = message.getSoapHeaders().values().iterator();
                while (it.hasNext()) {
                }
            }
            org.dom4j.QName soapBody = new org.dom4j.QName(soapVersion.getBody().getLocalPart(), soapNameSpace);
            Element soapBodyNode = soapEnvelopeNode.addElement(soapBody);
            if (exception instanceof SoapFault) {
                SoapFault fault = (SoapFault)exception;
                if (soapVersion == null) {
                    // empty if block
                }
                if (soapVersion.getVersion() == 1.1) {
                    this.writeSoap11FaultDOM4J(os, fault, soapVersion, soapBodyNode);
                } else if (soapVersion.getVersion() == 1.2) {
                    this.writeSoap12FaultDOM4J(os, fault, soapVersion, soapBodyNode);
                } else {
                    throw new IllegalStateException("Unrecognized soap version: " + soapVersion.getVersion());
                }
            }
            System.out.println(doc.asXML());
            writer.write(doc);
            writer.flush();
        }
        catch (Exception e) {
            throw new Fault(e);
        }
    }

    private Element writeSoap12FaultDOM4J(OutputStream os, SoapFault fault, SoapVersion soapVersion, Element bodyElement) throws Exception {
        Source details;
        URI role;
        URI node;
        String reason;
        fault.translateCodeTo12();
        Element faultElement = bodyElement.addElement(DOM4JUtils.toDOM4JQName((QName)soapVersion.getFault()));
        QName code = fault.getCode();
        if (code != null) {
            Element codeElement = faultElement.addElement(DOM4JUtils.toDOM4JQName((QName)SoapConstants.SOAP_12_FAULTCODE));
            Element codeValueElement = codeElement.addElement(DOM4JUtils.toDOM4JQName((QName)SoapConstants.SOAP_12_FAULTVALUE));
            codeValueElement.setText(String.valueOf(soapVersion.getEnvelope().getLocalPart()) + ":" + code.getLocalPart());
            QName subcode = fault.getSubcode();
            if (subcode != null) {
                Element subcodeElement = codeElement.addElement(DOM4JUtils.toDOM4JQName((QName)SoapConstants.SOAP_12_FAULTSUBCODE));
                Element subcodeValueElement = subcodeElement.addElement(DOM4JUtils.toDOM4JQName((QName)SoapConstants.SOAP_12_FAULTVALUE));
                subcodeValueElement.setText(String.valueOf(soapVersion.getEnvelope().getLocalPart()) + ":" + subcode.getLocalPart());
            }
        }
        if ((reason = fault.getReason()) == null && fault.getCause() != null) {
            reason = fault.getCause().toString();
        }
        Element reasonElement = faultElement.addElement(DOM4JUtils.toDOM4JQName((QName)SoapConstants.SOAP_12_FAULTREASON));
        Element reasonFaultTextElement = reasonElement.addElement(DOM4JUtils.toDOM4JQName((QName)SoapConstants.SOAP_12_FAULTTEXT));
        reasonFaultTextElement.addAttribute("lang", "en");
        if (reason != null) {
            reasonFaultTextElement.setText(reason);
        }
        if ((node = fault.getNode()) != null) {
            Element faultActorElement = faultElement.addElement(DOM4JUtils.toDOM4JQName((QName)SoapConstants.SOAP_12_FAULTNODE));
            faultActorElement.setText(node.toString());
        }
        if ((role = fault.getRole()) != null) {
            Element faultRoleElement = faultElement.addElement(DOM4JUtils.toDOM4JQName((QName)SoapConstants.SOAP_12_FAULTROLE));
            faultRoleElement.setText(node.toString());
        }
        if ((details = fault.getDetails()) != null) {
            Element faultDetailElement = faultElement.addElement(DOM4JUtils.toDOM4JQName((QName)SoapConstants.SOAP_12_FAULTDETAIL));
            if (details instanceof DocumentSource) {
                DocumentSource ds = (DocumentSource)details;
                Element detElem = ds.getDocument().getRootElement();
                detElem.detach();
                faultDetailElement.setText(detElem.asXML());
            }
        }
        return faultElement;
    }

    private Element writeSoap11FaultDOM4J(OutputStream os, SoapFault fault, SoapVersion soapVersion, Element bodyElement) throws Exception {
        Source details;
        URI node;
        String reason;
        fault.translateCodeTo11();
        Element faultElement = bodyElement.addElement(DOM4JUtils.toDOM4JQName((QName)soapVersion.getFault()));
        QName code = fault.getCode();
        if (code != null) {
            Element codeElement = faultElement.addElement(DOM4JUtils.toDOM4JQName((QName)SoapConstants.SOAP_11_FAULTCODE));
            codeElement.setText(String.valueOf(soapVersion.getEnvelope().getLocalPart()) + ":" + code.getLocalPart());
        }
        if ((reason = fault.getReason()) == null && fault.getCause() != null) {
            reason = fault.getCause().toString();
        }
        Element faultStringElement = faultElement.addElement(DOM4JUtils.toDOM4JQName((QName)SoapConstants.SOAP_11_FAULTSTRING));
        if (reason != null) {
            faultStringElement.setText(reason);
        }
        if ((node = fault.getNode()) != null) {
            Element faultActorElement = faultElement.addElement(DOM4JUtils.toDOM4JQName((QName)SoapConstants.SOAP_11_FAULTACTOR));
            faultActorElement.setText(node.toString());
        }
        if ((details = fault.getDetails()) != null) {
            Element faultDetailElement = faultElement.addElement(DOM4JUtils.toDOM4JQName((QName)SoapConstants.SOAP_11_FAULTDETAIL));
            if (details instanceof DocumentSource) {
                DocumentSource ds = (DocumentSource)details;
                Element detElem = ds.getDocument().getRootElement();
                detElem.detach();
                faultDetailElement.setText(detElem.asXML());
            }
            if (details instanceof StringSource) {
                faultDetailElement.setText(((StringSource)details).getText());
            }
        }
        return faultElement;
    }
}

