/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.mail;

import java.util.Properties;
import java.util.TimerTask;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.eclipse.ebpm.connectors.mail.MailParameters;
import org.eclipse.ebpm.connectors.mail.MailPollerComponent;
import org.eclipse.ebpm.connectors.mail.utils.MailUtils;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingTask
extends TimerTask {
    protected Logger log = LoggerFactory.getLogger(MailPollerComponent.class);
    private MailParameters mailParams;
    private MailPollerComponent poller;

    @Override
    public void run() {
        this.log.debug("Polling mailfolder " + this.mailParams.config.getFolderName() + " at host " + this.mailParams.config.getHost() + "...");
        if (this.poller.getMaxFetchSize() == 0) {
            this.log.debug("The configuration is set to poll no new messages at all...skipping.");
            return;
        }
        Store store = null;
        Folder folder = null;
        Session session = null;
        try {
            this.mailParams.config.setStartTLS(this.poller.isStartTLS());
            Properties props = MailUtils.getPropertiesForProtocol(this.mailParams.config, this.poller.getCustomTrustManagers());
            props.put("mail.debug", this.poller.isDebugMode() ? "true" : "false");
            session = Session.getInstance((Properties)props, (Authenticator)this.mailParams.config.getAuthenticator());
            session.setDebug(this.poller.isDebugMode());
            Message[] messages = null;
            try {
                store = session.getStore(this.mailParams.config.getProtocol());
                store.connect(this.mailParams.config.getHost(), this.mailParams.config.getUsername(), this.mailParams.config.getPassword().toString());
                folder = store.getFolder(this.mailParams.config.getFolderName());
                if (folder == null || !folder.exists()) {
                    throw new Exception("Folder not found or invalid: " + this.mailParams.config.getFolderName());
                }
                folder.open(2);
                messages = this.poller.isProcessOnlyUnseenMessages() ? folder.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false)) : folder.getMessages();
            }
            catch (Exception e) {
                this.log.error("Error retrieving Mail messages ", (Throwable)e);
            }
            int fetchSize = this.poller.getMaxFetchSize() == -1 ? messages.length : Math.min(this.poller.getMaxFetchSize(), messages.length);
            int cnt = 0;
            while (cnt < fetchSize) {
                MimeMessage mailMsg = (MimeMessage)messages[cnt];
                Exchange exchange = this.poller.getExchange();
                org.eclipse.ebpm.messaging.api.Message inMessage = exchange.getIn(true);
                try {
                    this.poller.getMarshaler().convertMailToNormalizedMessage(exchange, inMessage, mailMsg);
                }
                catch (MessagingException me) {
                    this.log.error("Error converting Mail message ", (Throwable)me);
                }
                if (exchange.getIn(false).getBody() != null) {
                    this.poller.sendMessage(exchange);
                }
                try {
                    if (this.poller.isDeleteProcessedMessages()) {
                        mailMsg.setFlag(Flags.Flag.DELETED, true);
                    } else {
                        mailMsg.setFlag(Flags.Flag.SEEN, true);
                    }
                }
                catch (MessagingException me) {
                    this.log.error("Error handling processed mail ", (Throwable)me);
                }
                ++cnt;
            }
        }
        finally {
            try {
                if (folder != null) {
                    folder.close(true);
                }
                if (store != null) {
                    store.close();
                }
            }
            catch (Exception ignored) {
                this.log.error("Error during polling ", (Throwable)ignored);
            }
        }
    }

    public PollingTask(MailParameters mailParams, MailPollerComponent poller) throws Exception {
        this.mailParams = mailParams;
        this.poller = poller;
    }
}

