/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.mail.marshaler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;

public abstract class AbstractMailMarshaler {
    public static final String MAIL_TAG_TO = "To";
    public static final String MAIL_TAG_CC = "Cc";
    public static final String MAIL_TAG_BCC = "Bcc";
    public static final String MAIL_TAG_FROM = "From";
    public static final String MAIL_TAG_SUBJECT = "Subject";
    public static final String MAIL_TAG_REPLYTO = "Reply-To";
    public static final String MAIL_TAG_SENTDATE = "Date";
    public static final String MSG_TAG_TO = "org.spagic3.mail.to";
    public static final String MSG_TAG_CC = "org.spagic3.mail.cc";
    public static final String MSG_TAG_BCC = "org.spagic3.mail.bcc";
    public static final String MSG_TAG_FROM = "org.spagic3.mail.from";
    public static final String MSG_TAG_TEXT = "org.spagic3.mail.text";
    public static final String MSG_TAG_HTML = "org.spagic3.mail.html";
    public static final String MSG_TAG_SUBJECT = "org.spagic3.mail.subject";
    public static final String MSG_TAG_REPLYTO = "org.spagic3.mail.replyto";
    public static final String MSG_TAG_SENTDATE = "org.spagic3.mail.sentdate";
    public static final String MSG_TAG_ALTERNATIVE_CONTENT = "org.spagic3.mail.alternativecontent";
    public static final String DEFAULT_SENDER = "no-reply@localhost";
    public static final String DUMMY_SUBJECT = "no subject";
    public static final String DUMMY_CONTENT = "no content";
    private Map<String, List<File>> temporaryFilesMap = Collections.synchronizedMap(new HashMap());

    public abstract void convertMailToNormalizedMessage(Exchange var1, Message var2, MimeMessage var3) throws MessagingException;

    public abstract void convertNormalizedMessageToMail(MimeMessage var1, Exchange var2, Message var3, String var4, String var5) throws MessagingException;

    public String getDefaultSenderForOutgoingMails() {
        return DEFAULT_SENDER;
    }

    protected final Map<String, DataSource> getAttachmentsMapFromNormalizedMessage(Message message) {
        HashMap<String, DataSource> attachments = new HashMap<String, DataSource>();
        String oneAttachmentName2 = "";
        Map att = message.getAttachments();
        Set attNames = att.keySet();
        for (String oneAttachmentName2 : attNames) {
            DataSource oneAttchmentInputString = ((DataHandler)message.getAttachment(oneAttachmentName2)).getDataSource();
            attachments.put(oneAttachmentName2, oneAttchmentInputString);
        }
        return attachments;
    }

    protected final void addTemporaryResource(String id, File tmpFile) {
        if (!this.temporaryFilesMap.containsKey(id)) {
            this.temporaryFilesMap.put(id, new ArrayList());
        }
        this.temporaryFilesMap.get(id).add(tmpFile);
    }

    public final void cleanUpResources(String id) {
        List<File> list = this.temporaryFilesMap.get(id);
        if (list != null) {
            for (File f : list) {
                f.delete();
            }
            list.clear();
            this.temporaryFilesMap.remove(id);
        }
    }
}

