/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.Namespaces;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Quota;
import javax.mail.QuotaAwareStore;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.StoreClosedException;
import javax.mail.URLName;

public class IMAPStore
extends Store
implements QuotaAwareStore,
ResponseHandler {
    public static final int RESPONSE = 1000;
    private String name = "imap";
    private int defaultPort = 143;
    private boolean isSSL = false;
    private int port = -1;
    private int blksize = 16384;
    private int statusCacheTimeout = 1000;
    private int appendBufferSize = -1;
    private int minIdleTime = 10;
    private String host;
    private String user;
    private String password;
    private String proxyAuthUser;
    private String authorizationID;
    private String saslRealm;
    private Namespaces namespaces;
    private boolean disableAuthLogin = false;
    private boolean disableAuthPlain = false;
    private boolean enableStartTLS = false;
    private boolean enableSASL = false;
    private String[] saslMechanisms;
    private boolean forcePasswordRefresh = false;
    private boolean enableImapEvents = false;
    private volatile boolean connected = false;
    private PrintStream out;
    private ConnectionPool pool = new ConnectionPool();

    public IMAPStore(Session session, URLName url) {
        this(session, url, "imap", 143, false);
    }

    protected IMAPStore(Session session, URLName url, String name, int defaultPort, boolean isSSL) {
        super(session, url);
        String s;
        if (url != null) {
            name = url.getProtocol();
        }
        this.name = name;
        this.defaultPort = defaultPort;
        this.isSSL = isSSL;
        this.pool.lastTimePruned = System.currentTimeMillis();
        this.debug = session.getDebug();
        this.out = session.getDebugOut();
        if (this.out == null) {
            this.out = System.out;
        }
        if ((s = session.getProperty("mail." + name + ".connectionpool.debug")) != null && s.equalsIgnoreCase("true")) {
            this.pool.debug = true;
        }
        if ((s = session.getProperty("mail." + name + ".partialfetch")) != null && s.equalsIgnoreCase("false")) {
            this.blksize = -1;
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.partialfetch: false");
            }
        } else {
            s = session.getProperty("mail." + name + ".fetchsize");
            if (s != null) {
                this.blksize = Integer.parseInt(s);
            }
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.fetchsize: " + this.blksize);
            }
        }
        if ((s = session.getProperty("mail." + name + ".statuscachetimeout")) != null) {
            this.statusCacheTimeout = Integer.parseInt(s);
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.statuscachetimeout: " + this.statusCacheTimeout);
            }
        }
        if ((s = session.getProperty("mail." + name + ".appendbuffersize")) != null) {
            this.appendBufferSize = Integer.parseInt(s);
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.appendbuffersize: " + this.appendBufferSize);
            }
        }
        if ((s = session.getProperty("mail." + name + ".minidletime")) != null) {
            this.minIdleTime = Integer.parseInt(s);
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.minidletime: " + this.minIdleTime);
            }
        }
        if ((s = session.getProperty("mail." + name + ".connectionpoolsize")) != null) {
            try {
                int size = Integer.parseInt(s);
                if (size > 0) {
                    this.pool.poolSize = size;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.pool.debug) {
                this.out.println("DEBUG: mail.imap.connectionpoolsize: " + this.pool.poolSize);
            }
        }
        if ((s = session.getProperty("mail." + name + ".connectionpooltimeout")) != null) {
            try {
                int connectionPoolTimeout = Integer.parseInt(s);
                if (connectionPoolTimeout > 0) {
                    this.pool.clientTimeoutInterval = connectionPoolTimeout;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.pool.debug) {
                this.out.println("DEBUG: mail.imap.connectionpooltimeout: " + this.pool.clientTimeoutInterval);
            }
        }
        if ((s = session.getProperty("mail." + name + ".servertimeout")) != null) {
            try {
                int serverTimeout = Integer.parseInt(s);
                if (serverTimeout > 0) {
                    this.pool.serverTimeoutInterval = serverTimeout;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.pool.debug) {
                this.out.println("DEBUG: mail.imap.servertimeout: " + this.pool.serverTimeoutInterval);
            }
        }
        if ((s = session.getProperty("mail." + name + ".separatestoreconnection")) != null && s.equalsIgnoreCase("true")) {
            if (this.pool.debug) {
                this.out.println("DEBUG: dedicate a store connection");
            }
            this.pool.separateStoreConnection = true;
        }
        if ((s = session.getProperty("mail." + name + ".proxyauth.user")) != null) {
            this.proxyAuthUser = s;
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.proxyauth.user: " + this.proxyAuthUser);
            }
        }
        if ((s = session.getProperty("mail." + name + ".auth.login.disable")) != null && s.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: disable AUTH=LOGIN");
            }
            this.disableAuthLogin = true;
        }
        if ((s = session.getProperty("mail." + name + ".auth.plain.disable")) != null && s.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: disable AUTH=PLAIN");
            }
            this.disableAuthPlain = true;
        }
        if ((s = session.getProperty("mail." + name + ".starttls.enable")) != null && s.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: enable STARTTLS");
            }
            this.enableStartTLS = true;
        }
        if ((s = session.getProperty("mail." + name + ".sasl.enable")) != null && s.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: enable SASL");
            }
            this.enableSASL = true;
        }
        if (this.enableSASL && (s = session.getProperty("mail." + name + ".sasl.mechanisms")) != null && s.length() > 0) {
            if (this.debug) {
                this.out.println("DEBUG: SASL mechanisms allowed: " + s);
            }
            Vector<String> v = new Vector<String>(5);
            StringTokenizer st = new StringTokenizer(s, " ,");
            while (st.hasMoreTokens()) {
                String m = st.nextToken();
                if (m.length() <= 0) continue;
                v.addElement(m);
            }
            this.saslMechanisms = new String[v.size()];
            v.copyInto(this.saslMechanisms);
        }
        if ((s = session.getProperty("mail." + name + ".sasl.authorizationid")) != null) {
            this.authorizationID = s;
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.sasl.authorizationid: " + this.authorizationID);
            }
        }
        if ((s = session.getProperty("mail." + name + ".sasl.realm")) != null) {
            this.saslRealm = s;
            if (this.debug) {
                this.out.println("DEBUG: mail.imap.sasl.realm: " + this.saslRealm);
            }
        }
        if ((s = session.getProperty("mail." + name + ".forcepasswordrefresh")) != null && s.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: enable forcePasswordRefresh");
            }
            this.forcePasswordRefresh = true;
        }
        if ((s = session.getProperty("mail." + name + ".enableimapevents")) != null && s.equalsIgnoreCase("true")) {
            if (this.debug) {
                this.out.println("DEBUG: enable IMAP events");
            }
            this.enableImapEvents = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean protocolConnect(String host, int pport, String user, String password) throws MessagingException {
        block18: {
            IMAPProtocol protocol = null;
            if (host == null || password == null || user == null) {
                if (this.debug) {
                    this.out.println("DEBUG: protocolConnect returning false, host=" + host + ", user=" + user + ", password=" + (password != null ? "<non-null>" : "<null>"));
                }
                return false;
            }
            if (pport != -1) {
                this.port = pport;
            } else {
                String portstring = this.session.getProperty("mail." + this.name + ".port");
                if (portstring != null) {
                    this.port = Integer.parseInt(portstring);
                }
            }
            if (this.port == -1) {
                this.port = this.defaultPort;
            }
            try {
                boolean poolEmpty;
                ConnectionPool connectionPool = this.pool;
                synchronized (connectionPool) {
                    poolEmpty = this.pool.authenticatedConnections.isEmpty();
                }
                if (!poolEmpty) break block18;
                protocol = new IMAPProtocol(this.name, host, this.port, this.session.getDebug(), this.session.getDebugOut(), this.session.getProperties(), this.isSSL);
                if (this.debug) {
                    this.out.println("DEBUG: protocolConnect login, host=" + host + ", user=" + user + ", password=<non-null>");
                }
                this.login(protocol, user, password);
                protocol.addResponseHandler(this);
                this.host = host;
                this.user = user;
                this.password = password;
                connectionPool = this.pool;
                synchronized (connectionPool) {
                    this.pool.authenticatedConnections.addElement(protocol);
                }
            }
            catch (CommandFailedException cex) {
                if (protocol != null) {
                    protocol.disconnect();
                }
                protocol = null;
                throw new AuthenticationFailedException(cex.getResponse().getRest());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
            catch (IOException ioex) {
                throw new MessagingException(ioex.getMessage(), ioex);
            }
        }
        this.connected = true;
        return true;
    }

    private void login(IMAPProtocol p, String u, String pw) throws ProtocolException {
        if (this.enableStartTLS && p.hasCapability("STARTTLS")) {
            p.startTLS();
            p.capability();
        }
        if (p.isAuthenticated()) {
            return;
        }
        p.getCapabilities().put("__PRELOGIN__", "");
        String authzid = this.authorizationID != null ? this.authorizationID : (this.proxyAuthUser != null ? this.proxyAuthUser : u);
        if (this.enableSASL) {
            p.sasllogin(this.saslMechanisms, this.saslRealm, authzid, u, pw);
        }
        if (!p.isAuthenticated()) {
            if (p.hasCapability("AUTH=PLAIN") && !this.disableAuthPlain) {
                p.authplain(authzid, u, pw);
            } else if ((p.hasCapability("AUTH-LOGIN") || p.hasCapability("AUTH=LOGIN")) && !this.disableAuthLogin) {
                p.authlogin(u, pw);
            } else if (!p.hasCapability("LOGINDISABLED")) {
                p.login(u, pw);
            } else {
                throw new ProtocolException("No login methods supported!");
            }
        }
        if (this.proxyAuthUser != null) {
            p.proxyauth(this.proxyAuthUser);
        }
        if (p.hasCapability("__PRELOGIN__")) {
            try {
                p.capability();
            }
            catch (ConnectionException cex) {
                throw cex;
            }
            catch (ProtocolException protocolException) {}
        }
    }

    public synchronized void setUsername(String user) {
        this.user = user;
    }

    public synchronized void setPassword(String password) {
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IMAPProtocol getProtocol(IMAPFolder folder) throws MessagingException {
        IMAPProtocol p = null;
        while (p == null) {
            ConnectionPool connectionPool = this.pool;
            synchronized (connectionPool) {
                if (this.pool.authenticatedConnections.isEmpty() || this.pool.authenticatedConnections.size() == 1 && (this.pool.separateStoreConnection || this.pool.storeConnectionInUse)) {
                    if (this.debug) {
                        this.out.println("DEBUG: no connections in the pool, creating a new one");
                    }
                    try {
                        if (this.forcePasswordRefresh) {
                            InetAddress addr;
                            try {
                                addr = InetAddress.getByName(this.host);
                            }
                            catch (UnknownHostException unknownHostException) {
                                addr = null;
                            }
                            PasswordAuthentication pa = this.session.requestPasswordAuthentication(addr, this.port, this.name, null, this.user);
                            if (pa != null) {
                                this.user = pa.getUserName();
                                this.password = pa.getPassword();
                            }
                        }
                        p = new IMAPProtocol(this.name, this.host, this.port, this.session.getDebug(), this.session.getDebugOut(), this.session.getProperties(), this.isSSL);
                        this.login(p, this.user, this.password);
                    }
                    catch (Exception exception) {
                        if (p != null) {
                            try {
                                p.disconnect();
                            }
                            catch (Exception exception2) {}
                        }
                        p = null;
                    }
                    if (p == null) {
                        throw new MessagingException("connection failure");
                    }
                } else {
                    if (this.debug) {
                        this.out.println("DEBUG: connection available -- size: " + this.pool.authenticatedConnections.size());
                    }
                    p = (IMAPProtocol)this.pool.authenticatedConnections.lastElement();
                    this.pool.authenticatedConnections.removeElement(p);
                    long lastUsed = System.currentTimeMillis() - p.getTimestamp();
                    if (lastUsed > this.pool.serverTimeoutInterval) {
                        try {
                            p.noop();
                        }
                        catch (ProtocolException protocolException) {
                            try {
                                p.removeResponseHandler(this);
                                p.disconnect();
                            }
                            catch (Throwable throwable) {}
                            p = null;
                            continue;
                        }
                    }
                    p.removeResponseHandler(this);
                }
                this.timeoutConnections();
                if (folder != null) {
                    if (this.pool.folders == null) {
                        this.pool.folders = new Vector();
                    }
                    this.pool.folders.addElement(folder);
                }
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IMAPProtocol getStoreProtocol() throws ProtocolException {
        IMAPProtocol p = null;
        while (p == null) {
            ConnectionPool connectionPool = this.pool;
            synchronized (connectionPool) {
                this.waitIfIdle();
                if (this.pool.authenticatedConnections.isEmpty()) {
                    if (this.pool.debug) {
                        this.out.println("DEBUG: getStoreProtocol() - no connections in the pool, creating a new one");
                    }
                    try {
                        p = new IMAPProtocol(this.name, this.host, this.port, this.session.getDebug(), this.session.getDebugOut(), this.session.getProperties(), this.isSSL);
                        this.login(p, this.user, this.password);
                    }
                    catch (Exception exception) {
                        if (p != null) {
                            try {
                                p.logout();
                            }
                            catch (Exception exception2) {}
                        }
                        p = null;
                    }
                    if (p == null) {
                        throw new ConnectionException("failed to create new store connection");
                    }
                    p.addResponseHandler(this);
                    this.pool.authenticatedConnections.addElement(p);
                } else {
                    if (this.pool.debug) {
                        this.out.println("DEBUG: getStoreProtocol() - connection available -- size: " + this.pool.authenticatedConnections.size());
                    }
                    p = (IMAPProtocol)this.pool.authenticatedConnections.firstElement();
                }
                if (this.pool.storeConnectionInUse) {
                    try {
                        p = null;
                        this.pool.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.pool.storeConnectionInUse = true;
                    if (this.pool.debug) {
                        this.out.println("DEBUG: getStoreProtocol() -- storeConnectionInUse");
                    }
                }
                this.timeoutConnections();
            }
        }
        return p;
    }

    boolean allowReadOnlySelect() {
        String s = this.session.getProperty("mail." + this.name + ".allowreadonlyselect");
        return s != null && s.equalsIgnoreCase("true");
    }

    boolean hasSeparateStoreConnection() {
        return this.pool.separateStoreConnection;
    }

    boolean getConnectionPoolDebug() {
        return this.pool.debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isConnectionPoolFull() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.pool.debug) {
                this.out.println("DEBUG: current size: " + this.pool.authenticatedConnections.size() + "   pool size: " + this.pool.poolSize);
            }
            return this.pool.authenticatedConnections.size() >= this.pool.poolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseProtocol(IMAPFolder folder, IMAPProtocol protocol) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (protocol != null) {
                if (!this.isConnectionPoolFull()) {
                    protocol.addResponseHandler(this);
                    this.pool.authenticatedConnections.addElement(protocol);
                    if (this.debug) {
                        this.out.println("DEBUG: added an Authenticated connection -- size: " + this.pool.authenticatedConnections.size());
                    }
                } else {
                    if (this.debug) {
                        this.out.println("DEBUG: pool is full, not adding an Authenticated connection");
                    }
                    try {
                        protocol.logout();
                    }
                    catch (ProtocolException protocolException) {}
                }
            }
            if (this.pool.folders != null) {
                this.pool.folders.removeElement(folder);
            }
            this.timeoutConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseStoreProtocol(IMAPProtocol protocol) {
        if (protocol == null) {
            return;
        }
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            this.pool.storeConnectionInUse = false;
            this.pool.notifyAll();
            if (this.pool.debug) {
                this.out.println("DEBUG: releaseStoreProtocol()");
            }
            this.timeoutConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emptyConnectionPool(boolean force) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            int index = this.pool.authenticatedConnections.size() - 1;
            while (index >= 0) {
                try {
                    IMAPProtocol p = (IMAPProtocol)this.pool.authenticatedConnections.elementAt(index);
                    p.removeResponseHandler(this);
                    if (force) {
                        p.disconnect();
                    } else {
                        p.logout();
                    }
                }
                catch (ProtocolException protocolException) {}
                --index;
            }
            this.pool.authenticatedConnections.removeAllElements();
        }
        if (this.pool.debug) {
            this.out.println("DEBUG: removed all authenticated connections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutConnections() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (System.currentTimeMillis() - this.pool.lastTimePruned > this.pool.pruningInterval && this.pool.authenticatedConnections.size() > 1) {
                if (this.pool.debug) {
                    this.out.println("DEBUG: checking for connections to prune: " + (System.currentTimeMillis() - this.pool.lastTimePruned));
                    this.out.println("DEBUG: clientTimeoutInterval: " + this.pool.clientTimeoutInterval);
                }
                int index = this.pool.authenticatedConnections.size() - 1;
                while (index > 0) {
                    IMAPProtocol p = (IMAPProtocol)this.pool.authenticatedConnections.elementAt(index);
                    if (this.pool.debug) {
                        this.out.println("DEBUG: protocol last used: " + (System.currentTimeMillis() - p.getTimestamp()));
                    }
                    if (System.currentTimeMillis() - p.getTimestamp() > this.pool.clientTimeoutInterval) {
                        if (this.pool.debug) {
                            this.out.println("DEBUG: authenticated connection timed out");
                            this.out.println("DEBUG: logging out the connection");
                        }
                        p.removeResponseHandler(this);
                        this.pool.authenticatedConnections.removeElementAt(index);
                        try {
                            p.logout();
                        }
                        catch (ProtocolException protocolException) {}
                    }
                    --index;
                }
                this.pool.lastTimePruned = System.currentTimeMillis();
            }
        }
    }

    int getFetchBlockSize() {
        return this.blksize;
    }

    Session getSession() {
        return this.session;
    }

    int getStatusCacheTimeout() {
        return this.statusCacheTimeout;
    }

    int getAppendBufferSize() {
        return this.appendBufferSize;
    }

    int getMinIdleTime() {
        return this.minIdleTime;
    }

    public synchronized boolean hasCapability(String capability) throws MessagingException {
        IMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            boolean bl = p.hasCapability(capability);
            return bl;
        }
        catch (ProtocolException pex) {
            this.cleanup();
            throw new MessagingException(pex.getMessage(), pex);
        }
        finally {
            this.releaseStoreProtocol(p);
        }
    }

    @Override
    public synchronized boolean isConnected() {
        block7: {
            if (!this.connected) {
                super.setConnected(false);
                return false;
            }
            IMAPProtocol p = null;
            try {
                try {
                    p = this.getStoreProtocol();
                    p.noop();
                }
                catch (ProtocolException protocolException) {
                    if (p == null) {
                        this.cleanup();
                    }
                    this.releaseStoreProtocol(p);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.releaseStoreProtocol(p);
                throw throwable;
            }
            this.releaseStoreProtocol(p);
        }
        return super.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws MessagingException {
        ConnectionPool connectionPool;
        IMAPProtocol protocol;
        block13: {
            boolean isEmpty;
            if (!super.isConnected()) {
                return;
            }
            protocol = null;
            connectionPool = this.pool;
            synchronized (connectionPool) {
                isEmpty = this.pool.authenticatedConnections.isEmpty();
            }
            if (!isEmpty) break block13;
            if (this.pool.debug) {
                this.out.println("DEBUG: close() - no connections ");
            }
            this.cleanup();
            this.releaseStoreProtocol(protocol);
            return;
        }
        try {
            try {
                protocol = this.getStoreProtocol();
                connectionPool = this.pool;
                synchronized (connectionPool) {
                    this.pool.authenticatedConnections.removeElement(protocol);
                }
                protocol.logout();
            }
            catch (ProtocolException pex) {
                this.cleanup();
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        catch (Throwable throwable) {
            this.releaseStoreProtocol(protocol);
            throw throwable;
        }
        this.releaseStoreProtocol(protocol);
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private void cleanup() {
        this.cleanup(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(boolean force) {
        ConnectionPool connectionPool;
        if (this.debug) {
            this.out.println("DEBUG: IMAPStore cleanup, force " + force);
        }
        Vector foldersCopy = null;
        boolean done = true;
        block9: while (true) {
            connectionPool = this.pool;
            synchronized (connectionPool) {
                if (this.pool.folders != null) {
                    done = false;
                    foldersCopy = this.pool.folders;
                    this.pool.folders = null;
                } else {
                    done = true;
                }
            }
            if (done) break;
            int i = 0;
            int fsize = foldersCopy.size();
            while (true) {
                if (i >= fsize) continue block9;
                IMAPFolder f = (IMAPFolder)foldersCopy.elementAt(i);
                try {
                    if (force) {
                        if (this.debug) {
                            this.out.println("DEBUG: force folder to close");
                        }
                        f.forceClose();
                    } else {
                        if (this.debug) {
                            this.out.println("DEBUG: close folder");
                        }
                        f.close(false);
                    }
                }
                catch (MessagingException messagingException) {
                }
                catch (IllegalStateException illegalStateException) {}
                ++i;
            }
            break;
        }
        connectionPool = this.pool;
        synchronized (connectionPool) {
            this.emptyConnectionPool(force);
        }
        this.connected = false;
        this.notifyConnectionListeners(3);
        if (this.debug) {
            this.out.println("DEBUG: IMAPStore cleanup done");
        }
    }

    @Override
    public synchronized Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new DefaultFolder(this);
    }

    @Override
    public synchronized Folder getFolder(String name) throws MessagingException {
        this.checkConnected();
        return new IMAPFolder(name, '\uffff', this);
    }

    @Override
    public synchronized Folder getFolder(URLName url) throws MessagingException {
        this.checkConnected();
        return new IMAPFolder(url.getFile(), '\uffff', this);
    }

    @Override
    public Folder[] getPersonalNamespaces() throws MessagingException {
        Namespaces ns = this.getNamespaces();
        if (ns == null || ns.personal == null) {
            return super.getPersonalNamespaces();
        }
        return this.namespaceToFolders(ns.personal, null);
    }

    @Override
    public Folder[] getUserNamespaces(String user) throws MessagingException {
        Namespaces ns = this.getNamespaces();
        if (ns == null || ns.otherUsers == null) {
            return super.getUserNamespaces(user);
        }
        return this.namespaceToFolders(ns.otherUsers, user);
    }

    @Override
    public Folder[] getSharedNamespaces() throws MessagingException {
        Namespaces ns = this.getNamespaces();
        if (ns == null || ns.shared == null) {
            return super.getSharedNamespaces();
        }
        return this.namespaceToFolders(ns.shared, null);
    }

    /*
     * Exception decompiling
     */
    private synchronized Namespaces getNamespaces() throws MessagingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Folder[] namespaceToFolders(Namespaces.Namespace[] ns, String user) {
        Folder[] fa = new Folder[ns.length];
        int i = 0;
        while (i < fa.length) {
            String name = ns[i].prefix;
            if (user == null) {
                int len = name.length();
                if (len > 0 && name.charAt(len - 1) == ns[i].delimiter) {
                    name = name.substring(0, len - 1);
                }
            } else {
                name = String.valueOf(name) + user;
            }
            fa[i] = new IMAPFolder(name, ns[i].delimiter, this, user == null);
            ++i;
        }
        return fa;
    }

    @Override
    public synchronized Quota[] getQuota(String root) throws MessagingException {
        this.checkConnected();
        Quota[] qa = null;
        IMAPProtocol p = null;
        try {
            try {
                p = this.getStoreProtocol();
                qa = p.getQuotaRoot(root);
            }
            catch (BadCommandException bex) {
                throw new MessagingException("QUOTA not supported", bex);
            }
            catch (ConnectionException cex) {
                throw new StoreClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        finally {
            this.releaseStoreProtocol(p);
            if (p == null) {
                this.cleanup();
            }
        }
        return qa;
    }

    @Override
    public synchronized void setQuota(Quota quota) throws MessagingException {
        this.checkConnected();
        IMAPProtocol p = null;
        try {
            try {
                p = this.getStoreProtocol();
                p.setQuota(quota);
            }
            catch (BadCommandException bex) {
                throw new MessagingException("QUOTA not supported", bex);
            }
            catch (ConnectionException cex) {
                throw new StoreClosedException(this, cex.getMessage());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), pex);
            }
        }
        finally {
            this.releaseStoreProtocol(p);
            if (p == null) {
                this.cleanup();
            }
        }
    }

    private void checkConnected() {
        assert (Thread.holdsLock(this));
        if (!this.connected) {
            super.setConnected(false);
            throw new IllegalStateException("Not connected");
        }
    }

    @Override
    public void handleResponse(Response r) {
        if (r.isOK() || r.isNO() || r.isBAD() || r.isBYE()) {
            this.handleResponseCode(r);
        }
        if (r.isBYE()) {
            if (this.debug) {
                this.out.println("DEBUG: IMAPStore connection dead");
            }
            if (this.connected) {
                this.cleanup(r.isSynthetic());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void idle() throws MessagingException {
        p = null;
        if (!IMAPStore.$assertionsDisabled && Thread.holdsLock(this.pool)) {
            throw new AssertionError();
        }
        var2_2 = this;
        synchronized (var2_2) {
            this.checkConnected();
        }
        var2_2 = this.pool;
        synchronized (var2_2) {
            p = this.getStoreProtocol();
            if (ConnectionPool.access$19(this.pool) == 0) {
                p.idleStart();
                ConnectionPool.access$20(this.pool, 1);
                ** break block38
            }
            try {
                this.pool.wait();
            }
            catch (InterruptedException v1) {}
            var5_7 = this.pool;
        }
        synchronized (var5_7) {
            ConnectionPool.access$18(this.pool, null);
        }
        this.releaseStoreProtocol(p);
        if (p == null) {
            this.cleanup();
        }
        return;
lbl-1000:
        // 1 sources

        {
            try {
                try {
                    ConnectionPool.access$18(this.pool, p);
                    // MONITOREXIT @DISABLED, blocks:[5, 6, 7, 13] lbl44 : MonitorExitStatement: MONITOREXIT : var2_2
                    {
                        catch (Throwable v3) {
                            throw v3;
                        }
                    }
                    while (true) {
                        r = p.readIdleResponse();
                        var3_10 = this.pool;
                        synchronized (var3_10) {
                            if (r == null || !p.processIdleResponse(r)) {
                                ConnectionPool.access$20(this.pool, 0);
                                this.pool.notifyAll();
                                break;
                            }
                        }
                        if (!this.enableImapEvents || !r.isUnTagged()) continue;
                        this.notifyStoreListeners(1000, r.toString());
                    }
                    minidle = this.getMinIdleTime();
                    if (minidle > 0) {
                        try {
                            Thread.sleep(minidle);
                        }
                        catch (InterruptedException v5) {}
                    }
                }
                catch (BadCommandException bex) {
                    throw new MessagingException("IDLE not supported", bex);
                }
                catch (ConnectionException cex) {
                    throw new StoreClosedException(this, cex.getMessage());
                }
                catch (ProtocolException pex) {
                    throw new MessagingException(pex.getMessage(), pex);
                }
            }
            catch (Throwable var4_11) {
                var5_8 = this.pool;
                synchronized (var5_8) {
                    ConnectionPool.access$18(this.pool, null);
                }
                this.releaseStoreProtocol(p);
                if (p == null) {
                    this.cleanup();
                }
                throw var4_11;
            }
        }
        var5_9 = this.pool;
        synchronized (var5_9) {
            ConnectionPool.access$18(this.pool, null);
        }
        this.releaseStoreProtocol(p);
        if (p == null) {
            this.cleanup();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void waitIfIdle() throws ProtocolException {
        if (IMAPStore.$assertionsDisabled || Thread.holdsLock(this.pool)) ** GOTO lbl10
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            if (ConnectionPool.access$19(this.pool) == 1) {
                ConnectionPool.access$21(this.pool).idleAbort();
                ConnectionPool.access$20(this.pool, 2);
            }
            try {
                this.pool.wait();
                continue;
            }
            catch (InterruptedException v0) {}
lbl10:
            // 3 sources

            ** while (ConnectionPool.access$19((ConnectionPool)this.pool) != 0)
        }
lbl11:
        // 1 sources

    }

    void handleResponseCode(Response r) {
        String s = r.getRest();
        boolean isAlert = false;
        if (s.startsWith("[")) {
            int i = s.indexOf(93);
            if (i > 0 && s.substring(0, i + 1).equalsIgnoreCase("[ALERT]")) {
                isAlert = true;
            }
            s = s.substring(i + 1).trim();
        }
        if (isAlert) {
            this.notifyStoreListeners(1, s);
        } else if (r.isUnTagged() && s.length() > 0) {
            this.notifyStoreListeners(2, s);
        }
    }

    static class ConnectionPool {
        private Vector authenticatedConnections = new Vector();
        private Vector folders;
        private boolean separateStoreConnection = false;
        private boolean storeConnectionInUse = false;
        private long clientTimeoutInterval = 45000L;
        private long serverTimeoutInterval = 1800000L;
        private long lastTimePruned;
        private int poolSize = 1;
        private long pruningInterval = 60000L;
        private boolean debug = false;
        private static final int RUNNING = 0;
        private static final int IDLE = 1;
        private static final int ABORTING = 2;
        private int idleState = 0;
        private IMAPProtocol idleProtocol;

        ConnectionPool() {
        }

        static /* synthetic */ void access$18(ConnectionPool connectionPool, IMAPProtocol iMAPProtocol) {
            connectionPool.idleProtocol = iMAPProtocol;
        }

        static /* synthetic */ int access$19(ConnectionPool connectionPool) {
            return connectionPool.idleState;
        }

        static /* synthetic */ void access$20(ConnectionPool connectionPool, int n) {
            connectionPool.idleState = n;
        }

        static /* synthetic */ IMAPProtocol access$21(ConnectionPool connectionPool) {
            return connectionPool.idleProtocol;
        }
    }
}

