/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.service.model;

import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ebpm.core.servicedefinitions.extensionprovider.IServiceDefinition;
import org.eclipse.ebpm.service.model.Activator;
import org.eclipse.ebpm.service.model.ComboProviderFactory;
import org.eclipse.ebpm.service.model.IServiceModelHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ServiceModelHelper
implements IServiceModelHelper {
    private static final String ISERVICEDEFINITION_ID = "org.spagic3.extensionpoint.servicedescriptor";
    private static final String CONNECTORS = "/scrappy/connectors";
    private static final String SERVICES = "/scrappy/services";
    private static final String DEFINITIONS = "/scrappy/definitions";
    private static final String COMBOPROVIDERS = "/scrappy/combo-providers";
    private static final String DEPLOYSCHEMAS = "/scrappy/deploy-schemas";
    private ComboProviderFactory comboProviderFactory;
    private static SpagicNamespaceContext nsContext = new SpagicNamespaceContext();
    private Document scappyDefDocument;
    private boolean deploySchemasMapsInitialized = false;
    private Map<String, DeploySchemaHelper> deploySchemasMapByName = null;
    private Map<String, DeploySchemaHelper> deploySchemasMapByExtension = null;

    public ServiceModelHelper() throws Exception {
        IConfigurationElement[] config;
        URL scrappyDefFile = Activator.getFileURL("/conf/scrappy-def.xml");
        DocumentBuilderFactory xmlFact = DocumentBuilderFactory.newInstance();
        xmlFact.setNamespaceAware(true);
        DocumentBuilder builder = xmlFact.newDocumentBuilder();
        this.scappyDefDocument = builder.parse(scrappyDefFile.openStream());
        this.comboProviderFactory = new ComboProviderFactory();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(ISERVICEDEFINITION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            final Object o = e.createExecutableExtension("class");
            if (o instanceof IServiceDefinition) {
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        exception.printStackTrace();
                    }

                    public void run() throws Exception {
                        IServiceDefinition sd = (IServiceDefinition)o;
                        ServiceModelHelper.this.addNodes(ServiceModelHelper.this.getElement(ServiceModelHelper.this.scappyDefDocument, ServiceModelHelper.CONNECTORS), sd.getConnectors());
                        ServiceModelHelper.this.addNodes(ServiceModelHelper.this.getElement(ServiceModelHelper.this.scappyDefDocument, ServiceModelHelper.SERVICES), sd.getServices());
                        ServiceModelHelper.this.addNodes(ServiceModelHelper.this.getElement(ServiceModelHelper.this.scappyDefDocument, ServiceModelHelper.DEFINITIONS), sd.getDefinitions());
                        ServiceModelHelper.this.addNodes(ServiceModelHelper.this.getElement(ServiceModelHelper.this.scappyDefDocument, ServiceModelHelper.COMBOPROVIDERS), sd.getComboProviders());
                        ServiceModelHelper.this.addNodes(ServiceModelHelper.this.getElement(ServiceModelHelper.this.scappyDefDocument, ServiceModelHelper.DEPLOYSCHEMAS), sd.getDeploySchemas());
                        if (sd.getComboProviderFactoryContribution() != null) {
                            ServiceModelHelper.this.comboProviderFactory.addComboProviders(sd.getComboProviderFactoryContribution());
                        }
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
            }
            ++n2;
        }
    }

    public void addNodes(Element el, List<Node> nodes) {
        if (nodes != null) {
            for (Node currentNode : nodes) {
                Node dup = el.getOwnerDocument().importNode(currentNode, true);
                el.appendChild(dup);
            }
        }
    }

    public ComboProviderFactory getComboProviderFactory() {
        return this.comboProviderFactory;
    }

    public Element getElement(Document document, String xpath) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setNamespaceContext(nsContext);
            Node node = (Node)xPath.evaluate(xpath, document, XPathConstants.NODE);
            return (Element)node;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Document getScappyDefDocument() {
        return this.scappyDefDocument;
    }

    @Override
    public String getComponentName(String factoryName) {
        return ServiceModelHelper.evalXPathAsString(this.scappyDefDocument, "(/scrappy/definitions/def[@factory=\"" + factoryName + "\"]/@name)");
    }

    public static String evalXPathAsString(String xml, String xpath) {
        try {
            DocumentBuilderFactory xmlFact = DocumentBuilderFactory.newInstance();
            xmlFact.setNamespaceAware(true);
            DocumentBuilder builder = xmlFact.newDocumentBuilder();
            InputSource source = new InputSource(new StringReader(xml));
            Document document = builder.parse(source);
            return ServiceModelHelper.evalXPathAsString(document, xpath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String evalXPathAsString(Node node, String xpath) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            xPath.setNamespaceContext(nsContext);
            String value = (String)xPath.evaluate(xpath, node, XPathConstants.STRING);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Node> evalXPathAsNodes(String xml, String xpath) {
        try {
            DocumentBuilderFactory xmlFact = DocumentBuilderFactory.newInstance();
            xmlFact.setNamespaceAware(true);
            DocumentBuilder builder = xmlFact.newDocumentBuilder();
            InputSource source = new InputSource(new StringReader(xml));
            Document document = builder.parse(source);
            return ServiceModelHelper.evalXPathAsNodes(document, xpath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Node> evalXPathAsNodes(Node node, String xpath) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(ServiceModelHelper.getNsContext());
        NodeList nodes = null;
        try {
            nodes = (NodeList)xPath.evaluate(xpath, node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<Node> result = new ArrayList<Node>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            result.add(nodes.item(i));
            ++i;
        }
        return result;
    }

    @Override
    public String getComponentType(String factoryName) {
        String componentName = ServiceModelHelper.evalXPathAsString(this.scappyDefDocument, "(/scrappy/connectors/connector[@factory=\"" + factoryName + "\"]/@name)");
        if (componentName != null && componentName.length() > 0) {
            return "CONNECTOR";
        }
        componentName = ServiceModelHelper.evalXPathAsString(this.scappyDefDocument, "(/scrappy/services/service[@factory=\"" + factoryName + "\"]/@name)");
        if (componentName != null && componentName.length() > 0) {
            return "SERVICE";
        }
        return "UNDEFINED";
    }

    public static SpagicNamespaceContext getNsContext() {
        return nsContext;
    }

    public List<String> getResoursePropertyNames(String factory) {
        List<Node> valueNodes = ServiceModelHelper.evalXPathAsNodes(this.getScappyDefDocument(), "(/scrappy/definitions/def[@factory=\"" + factory + "\"]/property[@resource=\"true\"]/@name)" + " | (/scrappy/definitions/def[@factory=\"" + factory + "\"]/when/property[@resource=\"true\"]/@name)");
        ArrayList<String> resourcePropertieNames = new ArrayList<String>();
        for (Node valueNode : valueNodes) {
            String value = ((Attr)valueNode).getValue();
            resourcePropertieNames.add(value);
        }
        return resourcePropertieNames;
    }

    private void initDeploySchemasMaps() {
        List<Node> deploySchemaNodes = ServiceModelHelper.evalXPathAsNodes(this.getScappyDefDocument(), "/scrappy/deploy-schemas/deploy-schema");
        this.deploySchemasMapByName = new HashMap<String, DeploySchemaHelper>();
        this.deploySchemasMapByExtension = new HashMap<String, DeploySchemaHelper>();
        for (Node deploySchemaNode : deploySchemaNodes) {
            DeploySchemaHelper helper = new DeploySchemaHelper(deploySchemaNode);
            this.deploySchemasMapByName.put(helper.getName(), helper);
            for (String extension : helper.getEstensions()) {
                this.deploySchemasMapByExtension.put(extension, helper);
            }
        }
    }

    public DeploySchemaHelper getDeploySchemaByName(String name) {
        if (!this.deploySchemasMapsInitialized) {
            this.initDeploySchemasMaps();
        }
        return this.deploySchemasMapByName.get(name);
    }

    public DeploySchemaHelper getDeploySchemaByExtension(String extension) {
        if (!this.deploySchemasMapsInitialized) {
            this.initDeploySchemasMaps();
        }
        return this.deploySchemasMapByExtension.get(extension);
    }

    public class DeploySchemaHelper {
        private Node deploySchemaDoc;

        public DeploySchemaHelper(Node schema) {
            this.deploySchemaDoc = schema;
        }

        public String getName() {
            return ServiceModelHelper.evalXPathAsString(this.deploySchemaDoc, "@name");
        }

        public String getPath() {
            return ServiceModelHelper.evalXPathAsString(this.deploySchemaDoc, "@path");
        }

        public Set<String> getEstensions() {
            List<Node> valueNodes = ServiceModelHelper.evalXPathAsNodes(this.deploySchemaDoc, "extension/@value");
            HashSet<String> rs = new HashSet<String>();
            for (Node valueNode : valueNodes) {
                rs.add(valueNode.getNodeValue());
            }
            return rs;
        }
    }

    public static class SpagicNamespaceContext
    implements NamespaceContext {
        private Map<String, String> namespaceMap = new HashMap<String, String>();

        public SpagicNamespaceContext() {
            this.namespaceMap.put("spagic", "urn:org:spagic3");
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (this.namespaceMap.containsKey(prefix)) {
                return this.namespaceMap.get(prefix);
            }
            return "";
        }

        @Override
        public String getPrefix(String namespace) {
            if (this.namespaceMap.containsValue(namespace)) {
                for (Map.Entry<String, String> e : this.namespaceMap.entrySet()) {
                    if (!e.getValue().equals(namespace)) continue;
                    return e.getKey();
                }
                return null;
            }
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String namespace) {
            return this.namespaceMap.keySet().iterator();
        }
    }
}

