/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.attachments.fs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.util.ByteArrayDataSource;
import org.eclipse.ebpm.attachments.IAttachmentStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemAttachmentStore
implements IAttachmentStore {
    private static final int BUFFER_SIZE = 4096;
    private String attachmentStoreId = null;
    private static String nodeId = System.getProperty("SPAGIC_NODE_IDENTIFIER");
    private Logger log = LoggerFactory.getLogger(FileSystemAttachmentStore.class);
    public String rootFolder = System.getProperty("fs.root");

    @Override
    public String getAttachmentStoreId() {
        return this.attachmentStoreId;
    }

    public void setAttachmentStoreId(String attachmentStoreId) {
        this.attachmentStoreId = attachmentStoreId;
    }

    public FileSystemAttachmentStore() {
        boolean ok;
        File f;
        if (this.rootFolder == null) {
            this.rootFolder = String.valueOf(System.getProperty("spagic.home")) + "/store/attachments/";
        }
        if (!(f = new File(this.rootFolder)).exists() && !(ok = f.mkdirs())) {
            this.log.error("Unable to create rootFolder[" + this.rootFolder + "]");
        }
        if (!f.canWrite()) {
            this.log.error("Unable to write into rootFolder[" + this.rootFolder + "]");
        }
        this.rootFolder = this.rootFolder.replace('\\', '/');
        if (!this.rootFolder.endsWith("/")) {
            this.rootFolder = String.valueOf(this.rootFolder) + "/";
        }
    }

    @Override
    public void delete(String id) {
        File aFile = this.getAttachmentFile(id);
        if (aFile == null) {
            return;
        }
        boolean ok = aFile.delete();
        if (!ok) {
            this.log.error("Cannot delete ID [" + id + ": file must be deletable -->" + aFile.getAbsolutePath());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataHandler load(String id) {
        DataHandler dataHandler;
        ByteArrayOutputStream baos;
        block14: {
            File aFile = this.getAttachmentFile(id);
            if (aFile == null) {
                return null;
            }
            baos = null;
            FileInputStream fis = null;
            try {
                DataHandler dha;
                baos = new ByteArrayOutputStream();
                fis = new FileInputStream(aFile);
                this.copyStream(fis, baos);
                baos.flush();
                ByteArrayDataSource bads = new ByteArrayDataSource(baos.toByteArray(), "application/octet-stream");
                dataHandler = dha = new DataHandler((DataSource)bads);
                if (fis == null) break block14;
            }
            catch (Exception e) {
                try {
                    this.log.error("Exception e");
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (baos == null) throw throwable;
                    try {
                        baos.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
            }
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        if (baos == null) return dataHandler;
        try {
            baos.close();
            return dataHandler;
        }
        catch (Exception exception) {}
        return dataHandler;
    }

    public void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    @Override
    public String store(String name, String correlationID, DataHandler value) {
        boolean ok;
        File aFile;
        File aDir;
        if (name == null || "".equals(name.trim())) {
            this.log.error("Attachment name is null or empty");
            return null;
        }
        try {
            if (value == null || value.getDataSource() == null || value.getDataSource().getInputStream() == null) {
                this.log.error("Attachment data Handler is null or invalid");
                return null;
            }
        }
        catch (Exception e) {
            this.log.error("Attachment data Handler is null or invalid", (Throwable)e);
            return null;
        }
        String relativeFileName = this.getUniqueFileName(name, correlationID);
        String absoluteFilename = this.rootFolder;
        if (!this.rootFolder.endsWith("/")) {
            absoluteFilename = String.valueOf(absoluteFilename) + "/";
        }
        if (!(aDir = (aFile = new File(absoluteFilename = String.valueOf(absoluteFilename) + relativeFileName)).getParentFile()).exists() && !(ok = aDir.mkdirs())) {
            this.log.error("Unable to create rootFolder[" + this.rootFolder + "]");
            return null;
        }
        String smartPointer = "[FS]/" + relativeFileName;
        try {
            if (this.copyFile(value.getDataSource().getInputStream(), aFile)) {
                return smartPointer;
            }
        }
        catch (IOException e) {
            this.log.error("Failed to create file[" + absoluteFilename + "]", (Throwable)e);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private boolean copyFile(InputStream from, File to) {
        FileOutputStream fos = null;
        fos = new FileOutputStream(to);
        byte[] buffer = new byte[4096];
        int byte_count = 0;
        while ((byte_count = from.read(buffer)) > 0) {
            fos.write(buffer, 0, byte_count);
        }
        try {
            fos.close();
        }
        catch (Exception exception) {}
        try {
            from.close();
        }
        catch (Exception exception) {}
        return true;
        catch (IOException iOException) {
            try {
                try {
                    if (fos != null) {
                        // empty if block
                    }
                }
                catch (Exception exception) {}
                try {
                    if (to.exists()) {
                        to.delete();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                try {
                    from.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                fos.close();
            }
            catch (Exception exception) {}
            try {
                from.close();
            }
            catch (Exception exception) {}
            return false;
        }
    }

    private String getUniqueFileName(String name, String correlationID) {
        StringBuffer sb = new StringBuffer();
        sb.append(nodeId).append("/");
        if (correlationID != null && !"".equals(correlationID.trim())) {
            sb.append(correlationID).append("_");
        }
        sb.append("" + (int)(Math.random() * 2.147483647E9)).append("_");
        sb.append(name);
        return sb.toString();
    }

    private File getAttachmentFile(String id) {
        if (id == null || "".equals(id.trim())) {
            this.log.error("Attachment ID is null or empty");
            return null;
        }
        if (!id.startsWith("[FS]")) {
            this.log.error("Attachment ID invalid: must start with [FS] --> " + id);
            return null;
        }
        String relativeFilename = id.substring("[FS]/".length());
        String absololuteFilename = String.valueOf(this.rootFolder) + relativeFilename;
        File aFile = new File(absololuteFilename);
        if (!aFile.exists()) {
            this.log.error("Attachment ID invalid [" + id + ": file must exists -->" + absololuteFilename);
            return null;
        }
        return aFile;
    }

    public static void main(String[] args) {
        try {
            FileSystemAttachmentStore fsas = new FileSystemAttachmentStore();
            FileDataSource fds = new FileDataSource("c:\\post.html");
            DataHandler dh = new DataHandler((DataSource)fds);
            String id = fsas.store("post.html", null, dh);
            DataHandler dh2 = fsas.load(id);
            InputStream is = dh2.getDataSource().getInputStream();
            fsas.copyFile(is, new File("c:\\temp\\post.html"));
            fsas.delete(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

