/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.ParameterizedTypeImpl;
import com.sun.tools.javadoc.PrimitiveType;
import com.sun.tools.javadoc.TypeVariableImpl;
import com.sun.tools.javadoc.WildcardTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMaker {
    public static com.sun.javadoc.Type getType(DocEnv docEnv, Type type) {
        return TypeMaker.getType(docEnv, type, true);
    }

    public static com.sun.javadoc.Type getType(DocEnv docEnv, Type type, boolean bl) {
        if (docEnv.legacyDoclet) {
            type = docEnv.types.erasure(type);
        }
        switch (type.tag) {
            case 10: {
                if (ClassDocImpl.isGeneric((Symbol.ClassSymbol)type.tsym)) {
                    return docEnv.getParameterizedType((Type.ClassType)type);
                }
                return docEnv.getClassDoc((Symbol.ClassSymbol)type.tsym);
            }
            case 15: {
                Type.WildcardType wildcardType = (Type.WildcardType)type;
                return new WildcardTypeImpl(docEnv, wildcardType);
            }
            case 14: {
                return new TypeVariableImpl(docEnv, (Type.TypeVar)type);
            }
            case 11: {
                return new ArrayTypeImpl(docEnv, type);
            }
            case 1: {
                return PrimitiveType.byteType;
            }
            case 2: {
                return PrimitiveType.charType;
            }
            case 3: {
                return PrimitiveType.shortType;
            }
            case 4: {
                return PrimitiveType.intType;
            }
            case 5: {
                return PrimitiveType.longType;
            }
            case 6: {
                return PrimitiveType.floatType;
            }
            case 7: {
                return PrimitiveType.doubleType;
            }
            case 8: {
                return PrimitiveType.booleanType;
            }
            case 9: {
                return PrimitiveType.voidType;
            }
            case 19: {
                if (!bl) break;
                return docEnv.getClassDoc((Symbol.ClassSymbol)type.tsym);
            }
        }
        return new PrimitiveType(type.tsym.getQualifiedName().toString());
    }

    public static com.sun.javadoc.Type[] getTypes(DocEnv docEnv, List<Type> list) {
        return TypeMaker.getTypes(docEnv, list, new com.sun.javadoc.Type[list.length()]);
    }

    public static com.sun.javadoc.Type[] getTypes(DocEnv docEnv, List<Type> list, com.sun.javadoc.Type[] typeArray) {
        int n = 0;
        for (Type type : list) {
            typeArray[n++] = TypeMaker.getType(docEnv, type);
        }
        return typeArray;
    }

    public static String getTypeName(Type type, boolean bl) {
        switch (type.tag) {
            case 11: {
                StringBuffer stringBuffer = new StringBuffer();
                while (type.tag == 11) {
                    stringBuffer = stringBuffer.append("[]");
                    type = ((Type.ArrayType)type).elemtype;
                }
                return TypeMaker.getTypeName(type, bl) + stringBuffer;
            }
            case 10: {
                return ClassDocImpl.getClassName((Symbol.ClassSymbol)type.tsym, bl);
            }
        }
        return type.tsym.getQualifiedName().toString();
    }

    static String getTypeString(DocEnv docEnv, Type type, boolean bl) {
        switch (type.tag) {
            case 11: {
                StringBuffer stringBuffer = new StringBuffer();
                while (type.tag == 11) {
                    stringBuffer = stringBuffer.append("[]");
                    type = docEnv.types.elemtype(type);
                }
                return TypeMaker.getTypeString(docEnv, type, bl) + stringBuffer;
            }
            case 10: {
                return ParameterizedTypeImpl.parameterizedTypeToString(docEnv, (Type.ClassType)type, bl);
            }
            case 15: {
                Type.WildcardType wildcardType = (Type.WildcardType)type;
                return WildcardTypeImpl.wildcardTypeToString(docEnv, wildcardType, bl);
            }
        }
        return type.tsym.getQualifiedName().toString();
    }

    static String typeParametersString(DocEnv docEnv, Symbol symbol, boolean bl) {
        if (docEnv.legacyDoclet || symbol.type.getTypeArguments().isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Type type : symbol.type.getTypeArguments()) {
            stringBuffer.append(stringBuffer.length() == 0 ? "<" : ", ");
            stringBuffer.append(TypeVariableImpl.typeVarToString(docEnv, (Type.TypeVar)type, bl));
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    static String typeArgumentsString(DocEnv docEnv, Type.ClassType classType, boolean bl) {
        if (docEnv.legacyDoclet || ((List)classType.getTypeArguments()).isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Type type : classType.getTypeArguments()) {
            stringBuffer.append(stringBuffer.length() == 0 ? "<" : ", ");
            stringBuffer.append(TypeMaker.getTypeString(docEnv, type, bl));
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    private static class ArrayTypeImpl
    implements com.sun.javadoc.Type {
        Type arrayType;
        DocEnv env;
        private com.sun.javadoc.Type skipArraysCache = null;

        ArrayTypeImpl(DocEnv docEnv, Type type) {
            this.env = docEnv;
            this.arrayType = type;
        }

        private com.sun.javadoc.Type skipArrays() {
            if (this.skipArraysCache == null) {
                Type type = this.arrayType;
                while (type.tag == 11) {
                    type = this.env.types.elemtype(type);
                }
                this.skipArraysCache = TypeMaker.getType(this.env, type);
            }
            return this.skipArraysCache;
        }

        public String dimension() {
            StringBuffer stringBuffer = new StringBuffer();
            Type type = this.arrayType;
            while (type.tag == 11) {
                stringBuffer = stringBuffer.append("[]");
                type = this.env.types.elemtype(type);
            }
            return stringBuffer.toString();
        }

        public String typeName() {
            return this.skipArrays().typeName();
        }

        public String qualifiedTypeName() {
            return this.skipArrays().qualifiedTypeName();
        }

        public String simpleTypeName() {
            return this.skipArrays().simpleTypeName();
        }

        public ClassDoc asClassDoc() {
            return this.skipArrays().asClassDoc();
        }

        public ParameterizedType asParameterizedType() {
            return this.skipArrays().asParameterizedType();
        }

        public TypeVariable asTypeVariable() {
            return this.skipArrays().asTypeVariable();
        }

        public WildcardType asWildcardType() {
            return null;
        }

        public AnnotationTypeDoc asAnnotationTypeDoc() {
            return this.skipArrays().asAnnotationTypeDoc();
        }

        public boolean isPrimitive() {
            return this.skipArrays().isPrimitive();
        }

        public String toString() {
            return this.qualifiedTypeName() + this.dimension();
        }
    }
}

