/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.ENumber;
import eglx.lang.InvalidArgumentException;
import eglx.lang.InvalidIndexException;
import eglx.lang.InvalidPatternException;
import eglx.lang.NullValueException;
import eglx.lang.TypeCastException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.util.DateTimeUtil;
import org.eclipse.edt.javart.util.JavartDateFormat;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EBigint;
import org.eclipse.edt.runtime.java.eglx.lang.EBoolean;
import org.eclipse.edt.runtime.java.eglx.lang.EBytes;
import org.eclipse.edt.runtime.java.eglx.lang.EDate;
import org.eclipse.edt.runtime.java.eglx.lang.EDecimal;
import org.eclipse.edt.runtime.java.eglx.lang.EFloat;
import org.eclipse.edt.runtime.java.eglx.lang.EInt;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallfloat;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallint;
import org.eclipse.edt.runtime.java.eglx.lang.ETime;
import org.eclipse.edt.runtime.java.eglx.lang.ETimestamp;

public class EString
extends AnyBoxedObject<String> {
    private static final long serialVersionUID = 10L;
    protected static final String DefaultValue = "";
    private int maxLength;

    public int getLength() {
        return this.maxLength;
    }

    private EString(String value) {
        super(value);
        this.maxLength = -1;
    }

    private EString(String value, int length) {
        super(value);
        this.maxLength = length;
    }

    public static EString ezeBox(String value) {
        return new EString(value);
    }

    public static EString ezeBox(String value, int length) {
        return new EString(value, length);
    }

    public static String ezeCast(Object value, Integer ... args) throws AnyException {
        return (String)EAny.ezeCast(value, "asString", EString.class, new Class[]{Integer[].class}, args);
    }

    public static boolean ezeIsa(Object value, Integer ... length) {
        boolean isa;
        boolean bl = isa = value instanceof EString && ((EString)value).ezeUnbox() != null;
        if (isa) {
            if (length.length != 0) {
                isa = ((EString)value).getLength() == length[0].intValue();
            }
        } else {
            isa = value instanceof String;
        }
        return isa;
    }

    public static String asString(Boolean value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(EBoolean value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value.ezeUnbox()), length);
    }

    public static String asString(EBytes value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString((byte[])value.ezeUnbox(), length);
    }

    public static String asString(byte[] value, Integer ... length) {
        if (value == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        str.append("0x");
        int i = 0;
        while (i < value.length) {
            int bits = value[i] & 0xFF;
            if (bits < 16) {
                str.append('0');
                str.append(Integer.toHexString(bits));
            } else {
                str.append(Integer.toHexString(bits));
            }
            ++i;
        }
        return str.toString();
    }

    public static String asString(Short value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(ESmallint value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value.ezeUnbox()), length);
    }

    public static String asString(Integer value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(EInt value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value.ezeUnbox()), length);
    }

    public static String asString(Long value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(EBigint value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value.ezeUnbox()), length);
    }

    public static String asString(Float value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(ESmallfloat value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value.ezeUnbox()), length);
    }

    public static String asString(Double value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(EFloat value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value.ezeUnbox()), length);
    }

    public static String asString(BigDecimal value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(EDecimal value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value.ezeUnbox()), length);
    }

    public static String asString(BigInteger value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(Number value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value), length);
    }

    public static String asString(ENumber value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(String.valueOf(value.ezeUnbox()), length);
    }

    public static String asString(String value, Integer ... length) {
        if (value == null) {
            return null;
        }
        if (length.length != 0 && value.length() > length[0]) {
            value = value.substring(0, length[0]);
        }
        return value;
    }

    public static String asString(EString value, Integer ... length) {
        if (value == null) {
            return null;
        }
        if (length.length != 0 && ((String)value.ezeUnbox()).length() > length[0]) {
            return ((String)value.ezeUnbox()).substring(0, length[0]);
        }
        return (String)value.ezeUnbox();
    }

    public static String asString(EDate value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(EString.asStringDate((Calendar)value.ezeUnbox()), length);
    }

    protected static String asStringDate(Calendar original) {
        if (original == null) {
            return null;
        }
        Calendar cal = (Calendar)original.clone();
        String format = "MM/dd/yyyy";
        byte[] byArray = DateTimeUtil.LOCK;
        synchronized (DateTimeUtil.LOCK) {
            JavartDateFormat formatter = DateTimeUtil.getDateFormat(format);
            try {
                cal.setLenient(true);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return formatter.format(cal.getTime());
            }
            catch (IllegalArgumentException iax) {
                TypeCastException tcx = new TypeCastException();
                tcx.castToName = "string";
                tcx.actualTypeName = "date";
                tcx.initCause(iax);
                throw tcx.fillInMessage("EGL0007E", cal.getTime(), tcx.actualTypeName, tcx.castToName);
            }
        }
    }

    public static String asString(ETime value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(EString.asStringTime((Calendar)value.ezeUnbox()), length);
    }

    protected static String asStringTime(Calendar original) {
        if (original == null) {
            return null;
        }
        Calendar cal = (Calendar)original.clone();
        String format = "HH:mm:ss";
        byte[] byArray = DateTimeUtil.LOCK;
        synchronized (DateTimeUtil.LOCK) {
            JavartDateFormat formatter = DateTimeUtil.getDateFormat(format);
            try {
                cal.setLenient(true);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return formatter.format(cal.getTime());
            }
            catch (IllegalArgumentException iax) {
                TypeCastException tcx = new TypeCastException();
                tcx.castToName = "string";
                tcx.actualTypeName = "time";
                tcx.initCause(iax);
                throw tcx.fillInMessage("EGL0007E", cal.getTime(), tcx.actualTypeName, tcx.castToName);
            }
        }
    }

    public static String asString(ETimestamp value, Integer ... length) {
        if (value == null) {
            return null;
        }
        return EString.asString(EString.asStringTimestamp((Calendar)value.ezeUnbox(), value.getStartCode(), value.getEndCode()), length);
    }

    protected static String asStringTimestamp(Calendar original, int startCode, int endCode) {
        if (original == null) {
            return null;
        }
        Calendar cal = (Calendar)original.clone();
        StringBuilder format = new StringBuilder(26);
        String separator = null;
        if (startCode <= 0 && endCode >= 0) {
            format.append("yyyy");
            separator = "-";
        }
        if (startCode <= 1 && endCode >= 1) {
            if (separator != null) {
                format.append(separator);
            }
            format.append("MM");
            separator = "-";
        }
        if (startCode <= 2 && endCode >= 2) {
            if (separator != null) {
                format.append(separator);
            }
            format.append("dd");
            separator = " ";
        }
        if (startCode <= 3 && endCode >= 3) {
            if (separator != null) {
                format.append(separator);
            }
            format.append("HH");
            separator = ":";
        }
        if (startCode <= 4 && endCode >= 4) {
            if (separator != null) {
                format.append(separator);
            }
            format.append("mm");
            separator = ":";
        }
        if (startCode <= 5 && endCode >= 5) {
            if (separator != null) {
                format.append(separator);
            }
            format.append("ss");
            separator = ".";
        }
        if (startCode <= 11 && endCode >= 6) {
            if (separator != null) {
                format.append(separator);
            }
            format.append("SSSSSS".substring(0, endCode - 6 + 1));
        }
        byte[] byArray = DateTimeUtil.LOCK;
        synchronized (DateTimeUtil.LOCK) {
            JavartDateFormat formatter = DateTimeUtil.getDateFormat(format.toString());
            if (startCode <= 5 && endCode >= 6) {
                int micros = cal.get(14) * 1000;
                if (micros < 0) {
                    cal.add(13, -1);
                    micros += 1000000;
                }
                formatter.setMicrosecond(micros);
            }
            try {
                cal.setLenient(true);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return formatter.format(cal.getTime());
            }
            catch (IllegalArgumentException iax) {
                TypeCastException tcx = new TypeCastException();
                tcx.castToName = "string";
                tcx.actualTypeName = "timestamp(\"" + ETimestamp.createMask(startCode, endCode) + "\")";
                tcx.initCause(iax);
                throw tcx.fillInMessage("EGL0007E", cal.getTime(), tcx.actualTypeName, tcx.castToName);
            }
        }
    }

    public static String getDefaultEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String fromBytes(EBytes value) {
        return EString.fromBytes((byte[])value.ezeUnbox());
    }

    public static String fromBytes(byte[] value) {
        return new String(value);
    }

    public static String fromBytes(EBytes value, String encoding) {
        return EString.fromBytes((byte[])value.ezeUnbox(), encoding);
    }

    public static String fromBytes(byte[] value, String encoding) {
        try {
            return new String(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            InvalidArgumentException ex = new InvalidArgumentException();
            ex.initCause(e);
            throw ex.fillInMessage("EGL0007E", encoding);
        }
    }

    public static byte[] toBytes(String value) {
        if (value == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        return value.getBytes();
    }

    public static byte[] toBytes(String value, String encoding) {
        if (value == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        try {
            return value.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            InvalidArgumentException ex = new InvalidArgumentException();
            ex.initCause(e);
            throw ex.fillInMessage("EGL0007E", encoding);
        }
    }

    public static EString asNumber(String value, Integer ... length) throws AnyException {
        if (value == null) {
            return null;
        }
        return EString.ezeBox(EString.asString(value, length));
    }

    public static EString asNumber(EString value, Integer ... length) throws AnyException {
        if (value == null) {
            return null;
        }
        return value;
    }

    public static String plus(String op1, String op2) throws AnyException {
        return EString.concat(op1, op2);
    }

    public static String concat(String op1, String op2) throws AnyException {
        if (op1 == null) {
            op1 = DefaultValue;
        }
        if (op2 == null) {
            op2 = DefaultValue;
        }
        return String.valueOf(op1) + op2;
    }

    public static String concatNull(String op1, String op2) {
        if (op1 == null || op2 == null) {
            return null;
        }
        return String.valueOf(op1) + op2;
    }

    public static int compareTo(String op1, String op2) throws AnyException {
        return op1.compareTo(op2);
    }

    public static boolean equals(String op1, String op2) throws AnyException {
        if (op1 == op2) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.equals(op2);
    }

    public static boolean notEquals(String op1, String op2) throws AnyException {
        return !EString.equals(op1, op2);
    }

    public static String substring(String str, int start, int end) throws AnyException {
        if (str == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        int max = str.length();
        if (start < 1 || start > max) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = start;
            throw ex.fillInMessage("EGL0012E", start, end);
        }
        if (end < start || end < 1 || end > max) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = end;
            throw ex.fillInMessage("EGL0012E", start, end);
        }
        return str.substring(start - 1, end);
    }

    public static int length(String source) {
        if (source == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        return source.length();
    }

    public static String trim(String source) {
        return EString.clip(EString.clipLeading(source));
    }

    public static String clipLeading(String value) {
        if (value == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        int lth = value.length();
        if (lth > 0) {
            int startingIdx = 0;
            boolean charsDeleted = false;
            while (startingIdx < lth) {
                char c = value.charAt(startingIdx);
                if (c > ' ' && c != '\u3000') break;
                charsDeleted = true;
                ++startingIdx;
            }
            if (charsDeleted) {
                return value.substring(startingIdx, lth);
            }
        }
        return value;
    }

    public static String clip(String source) {
        if (source == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        int lth = source.length();
        if (lth > 0) {
            int startingIdx = lth - 1;
            boolean charsDeleted = false;
            while (startingIdx >= 0) {
                char c = source.charAt(startingIdx);
                if (c > ' ' && c != '\u3000') break;
                charsDeleted = true;
                --startingIdx;
            }
            if (charsDeleted) {
                return source.substring(0, startingIdx + 1);
            }
        }
        return source;
    }

    public static String toLowerCase(String source) {
        if (source == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        return source.toLowerCase();
    }

    public static String toUpperCase(String source) {
        if (source == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        return source.toUpperCase();
    }

    public static boolean startsWith(String source, String value) {
        if (source == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        return source.startsWith(value);
    }

    public static boolean endsWith(String source, String value) {
        if (source == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        return source.endsWith(value);
    }

    public static int indexOf(String source, String value) {
        if (source == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        return source.indexOf(value) + 1;
    }

    public static int indexOf(String source, String value, int start) {
        if (source == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        if (start < 1 || start > source.length()) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = start;
            throw ex.fillInMessage("EGL0011E", start);
        }
        return source.indexOf(value, start - 1) + 1;
    }

    public static int lastIndexOf(String source, String value) {
        if (source == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        return source.lastIndexOf(value) + 1;
    }

    public static String replaceStr(String source, String search, String replacement) {
        if (source == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        return source.replace(search, replacement);
    }

    public static int charCodeAt(String source, int index) {
        if (source == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        if (index < 1 || index > source.length()) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = index;
            throw ex.fillInMessage("EGL0011E", index);
        }
        return source.charAt(index - 1);
    }

    public static boolean isLike(String source, String pattern) {
        return EString.isLike(source, pattern, "\\");
    }

    public static boolean isLike(String source, String pattern, String escape) {
        if (source == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        char escapeChar = escape.length() > 0 ? (char)escape.charAt(0) : (char)'\\';
        String escapeThese = "$[]^{}+|?().*";
        StringBuilder regex = new StringBuilder();
        source = EString.clip(source);
        pattern = EString.clip(pattern);
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (ch == '\\' && escapeChar != '\\') {
                regex.append("\\\\");
            } else if (ch == escapeChar) {
                if (i + 1 >= pattern.length()) {
                    InvalidPatternException ex = new InvalidPatternException();
                    ex.pattern = pattern;
                    throw ex.fillInMessage("EGL0018E", pattern);
                }
                char nch = pattern.charAt(i + 1);
                if (nch == '_' || nch == '%') {
                    regex.append(nch);
                } else if (nch == escapeChar) {
                    if (escapeChar == '\\' || escapeThese.indexOf(escapeChar) != -1) {
                        regex.append('\\');
                    }
                    regex.append(escapeChar);
                } else if (escapeChar == '\\') {
                    regex.append("\\" + nch);
                } else {
                    regex.append(nch);
                }
                ++i;
            } else if (ch == '%') {
                regex.append(".*");
            } else if (ch == '_') {
                regex.append('.');
            } else if (escapeThese.indexOf(ch) != -1) {
                regex.append("\\" + ch);
            } else {
                regex.append(ch);
            }
            ++i;
        }
        try {
            return source.matches(regex.toString());
        }
        catch (PatternSyntaxException e) {
            InvalidPatternException ex = new InvalidPatternException();
            ex.pattern = pattern;
            ex.initCause(e);
            throw ex.fillInMessage("EGL0018E", pattern);
        }
    }

    public static boolean matchesPattern(String source, String pattern) {
        return EString.matchesPattern(source, pattern, "\\");
    }

    public static boolean matchesPattern(String source, String pattern, String escape) {
        if (source == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        String regex = EString.patternToRegex(pattern, escape);
        try {
            return source.matches(regex);
        }
        catch (PatternSyntaxException e) {
            InvalidPatternException ex = new InvalidPatternException();
            ex.pattern = pattern;
            ex.initCause(e);
            throw ex.fillInMessage("EGL0018E", pattern);
        }
    }

    private static String patternToRegex(String pattern, String escape) {
        char escapeChar = escape.length() > 0 ? (char)escape.charAt(0) : (char)'\\';
        String escapeThese = "${}+|&().";
        StringBuilder regex = new StringBuilder();
        boolean withinBrackets = false;
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (ch == '\\' && escapeChar != '\\') {
                regex.append("\\\\");
            } else if (ch == escapeChar) {
                if (i + 1 >= pattern.length()) {
                    InvalidPatternException ex = new InvalidPatternException();
                    ex.pattern = pattern;
                    throw ex.fillInMessage("EGL0018E", pattern);
                }
                char nch = pattern.charAt(i + 1);
                switch (nch) {
                    case '*': 
                    case '?': 
                    case '[': 
                    case ']': 
                    case '^': {
                        regex.append("\\" + nch);
                        break;
                    }
                    default: {
                        if (nch == escapeChar) {
                            if (escapeChar == '\\' || escapeThese.indexOf(escapeChar) != -1) {
                                regex.append('\\');
                            }
                            regex.append(escapeChar);
                            break;
                        }
                        if (escapeChar == '\\') {
                            regex.append("\\" + nch);
                            break;
                        }
                        regex.append(nch);
                    }
                }
                ++i;
            } else if (ch == '[') {
                withinBrackets = true;
                regex.append(ch);
            } else if (ch == ']') {
                withinBrackets = false;
                regex.append(ch);
            } else if (ch == '*' && !withinBrackets) {
                regex.append(".*");
            } else if (ch == '?' && !withinBrackets) {
                regex.append('.');
            } else if (ch == '^' && !withinBrackets) {
                regex.append("\\^");
            } else if (escapeThese.indexOf(ch) != -1) {
                regex.append("\\" + ch);
            } else {
                regex.append(ch);
            }
            ++i;
        }
        if (withinBrackets) {
            int pos = regex.lastIndexOf("[");
            regex.insert(pos, '\\');
            if (pos + 2 < regex.length() && regex.charAt(pos + 2) == '^') {
                regex.insert(pos + 2, '\\');
            }
        }
        return regex.toString();
    }

    public String toString() {
        if (this.maxLength > 0) {
            return EString.asString((String)this.object, this.maxLength);
        }
        return (String)this.object;
    }

    public static String join(String separator, List<String> strings) {
        int size = strings.size();
        if (size == 0) {
            return DefaultValue;
        }
        if (size == 1) {
            return strings.get(0);
        }
        StringBuilder joined = new StringBuilder(strings.get(0));
        int i = 1;
        while (i < size) {
            joined.append(separator);
            joined.append(strings.get(i));
            ++i;
        }
        return joined.toString();
    }

    public static List<String> split(String str, String separator) {
        if (str == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = str.indexOf(separator);
        if (i == -1) {
            result.add(str);
        } else {
            int start = 0;
            do {
                result.add(str.substring(start, i));
            } while ((i = str.indexOf(separator, start = i + separator.length())) != -1);
            if (start <= str.length()) {
                result.add(str.substring(start, str.length()));
            }
        }
        return result;
    }

    public static List<String> split(String str, String separator, int limit) {
        if (str == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (limit >= 1) {
            int i = str.indexOf(separator);
            if (i == -1) {
                result.add(str);
            } else {
                int count = 0;
                int start = 0;
                do {
                    result.add(str.substring(start, i));
                } while ((i = str.indexOf(separator, start = i + separator.length())) != -1 && ++count < limit);
                if (count < limit) {
                    result.add(str.substring(start, str.length()));
                }
            }
        }
        return result;
    }

    public static List<String> splitOnPattern(String str, String pattern) {
        return EString.splitOnPattern(str, pattern, "\\");
    }

    public static List<String> splitOnPattern(String str, String pattern, String escape) {
        if (str == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        String regex = EString.patternToRegex(pattern, escape);
        try {
            return Arrays.asList(str.split(regex, -1));
        }
        catch (PatternSyntaxException psx) {
            InvalidPatternException ex = new InvalidPatternException();
            ex.pattern = pattern;
            ex.initCause(psx);
            throw ex.fillInMessage("EGL0018E", pattern);
        }
    }

    public static List<String> splitOnPattern(String str, String pattern, int limit) {
        return EString.splitOnPattern(str, pattern, "\\", limit);
    }

    public static List<String> splitOnPattern(String str, String pattern, String escape, int limit) {
        if (str == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        if (limit < 1) {
            return new ArrayList<String>();
        }
        String regex = EString.patternToRegex(pattern, escape);
        String[] parts = null;
        try {
            parts = str.split(regex, limit + 1);
        }
        catch (PatternSyntaxException psx) {
            InvalidPatternException ex = new InvalidPatternException();
            ex.pattern = pattern;
            ex.initCause(psx);
            throw ex.fillInMessage("EGL0018E", pattern);
        }
        ArrayList<String> result = new ArrayList<String>(limit);
        int i = 0;
        while (i < parts.length && i < limit) {
            result.add(parts[i]);
            ++i;
        }
        return result;
    }

    public static String reverse(String str) {
        if (str == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        return new StringBuilder(str).reverse().toString();
    }

    public static int compareIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        return str1.compareToIgnoreCase(str2);
    }

    public static String insertStr(String str1, int offset, String str2) {
        if (str1 == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        if (offset < 1 || offset > str1.length()) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = offset;
            throw ex.fillInMessage("EGL0011E", offset);
        }
        return String.valueOf(str1.substring(0, offset - 1)) + str2 + str1.substring(offset - 1, str1.length());
    }

    public static String replaceStrAt(String str1, int startIndex, int endIndex, String str2) {
        if (str1 == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        if (startIndex < 1 || startIndex > str1.length() || startIndex > endIndex) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = startIndex;
            throw ex.fillInMessage("EGL0011E", startIndex);
        }
        if (endIndex > str1.length()) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = endIndex;
            throw ex.fillInMessage("EGL0011E", endIndex);
        }
        return String.valueOf(str1.substring(0, startIndex - 1)) + str2 + str1.substring(endIndex - 1, str1.length());
    }

    public static int indexOfPattern(String str, String pattern) {
        return EString.indexOfPattern(str, pattern, "\\", 1);
    }

    public static int indexOfPattern(String str, String pattern, String escape) {
        return EString.indexOfPattern(str, pattern, escape, 1);
    }

    public static int indexOfPattern(String str, String pattern, int startIndex) {
        return EString.indexOfPattern(str, pattern, "\\", startIndex);
    }

    public static int indexOfPattern(String str, String pattern, String escape, int startIndex) {
        if (str == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        if (startIndex < 1 || startIndex > str.length()) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = startIndex;
            throw ex.fillInMessage("EGL0011E", startIndex);
        }
        String regex = EString.patternToRegex(pattern, escape);
        try {
            Matcher matcher = Pattern.compile(regex).matcher(str);
            if (matcher.find(startIndex - 1)) {
                return matcher.start() + 1;
            }
            return 0;
        }
        catch (PatternSyntaxException e) {
            InvalidPatternException ex = new InvalidPatternException();
            ex.pattern = pattern;
            ex.initCause(e);
            throw ex.fillInMessage("EGL0018E", pattern);
        }
    }

    public static String replacePattern(String str, String pattern, String replacement, boolean global) {
        return EString.replacePattern(str, pattern, "\\", replacement, global);
    }

    public static String replacePattern(String str, String pattern, String escape, String replacement, boolean global) {
        if (str == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        String regex = EString.patternToRegex(pattern, escape);
        try {
            Matcher matcher = Pattern.compile(regex).matcher(str);
            if (global) {
                return matcher.replaceAll(Matcher.quoteReplacement(replacement));
            }
            return matcher.replaceFirst(Matcher.quoteReplacement(replacement));
        }
        catch (PatternSyntaxException e) {
            InvalidPatternException ex = new InvalidPatternException();
            ex.pattern = pattern;
            ex.initCause(e);
            throw ex.fillInMessage("EGL0018E", pattern);
        }
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            throw new NullValueException().fillInMessage("EGL0016E", new Object[0]);
        }
        return str.isEmpty();
    }
}

