/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.clustering;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.titanium.graph.clustering.BaseCluster;
import org.eclipse.titanium.graph.clustering.ClusteringTools;
import org.eclipse.titanium.graph.clustering.ModuleLocationCluster;
import org.eclipse.titanium.graph.clustering.ModuleNameCluster;
import org.eclipse.titanium.graph.clustering.RegexpCluster;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;

public class AutomaticCluster
extends BaseCluster {
    private int maxclusters;
    private int maxiterations;
    private boolean checkFolder;
    private boolean checkModulename;
    private boolean checkRegexp;
    private IProject project;
    private Set<Set<NodeDescriptor>> clustersToCheck;
    private Map<NodeDescriptor, Integer> mapClusterIndex;
    private Map<Integer, Set<NodeDescriptor>> mapIndexCluster;
    private Map<Integer, Integer> size;
    private Set<Integer> indices;
    private Map<Integer, Map<Integer, Integer>> mapBetweenArcs;
    private int index;
    private int nodenum;
    private int clusternum;
    private double mq;
    private double maxmq;

    public AutomaticCluster(DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> graph, IProject project) {
        this.project = project;
        this.successful = true;
        this.moduleGraph = graph;
        this.nodenum = graph.getVertexCount();
        this.loadSettings();
    }

    private void loadSettings() {
        this.maxiterations = Platform.getPreferencesService().getInt("org.eclipse.titanium", "Max_Auto_Iterations", 20, null);
        this.maxclusters = Platform.getPreferencesService().getInt("org.eclipse.titanium", "Max_Auto_Cluster_Number", 7, null);
        this.checkFolder = Platform.getPreferencesService().getBoolean("org.eclipse.titanium", "Auto_folder", true, null);
        this.checkModulename = Platform.getPreferencesService().getBoolean("org.eclipse.titanium", "Auto_name", true, null);
        this.checkRegexp = Platform.getPreferencesService().getBoolean("org.eclipse.titanium", "Auto_regexp", true, null);
    }

    private void init() {
        this.mapBetweenArcs = new HashMap<Integer, Map<Integer, Integer>>();
        this.indices = new HashSet<Integer>();
        this.mapIndexCluster = new HashMap<Integer, Set<NodeDescriptor>>();
        this.mapClusterIndex = new HashMap<NodeDescriptor, Integer>();
        this.size = new HashMap<Integer, Integer>();
        this.index = 0;
        this.clusternum = 0;
        HashSet<Set<NodeDescriptor>> clustersToRemove = new HashSet<Set<NodeDescriptor>>();
        for (Set<NodeDescriptor> cluster : this.clustersToCheck) {
            if (cluster == null || cluster.isEmpty()) {
                clustersToRemove.add(cluster);
                continue;
            }
            this.indices.add(this.index);
            this.mapIndexCluster.put(this.index, cluster);
            this.size.put(this.index, cluster.size());
            for (NodeDescriptor nodeDescriptor : cluster) {
                this.mapClusterIndex.put(nodeDescriptor, this.index);
            }
            ++this.index;
            ++this.clusternum;
        }
        for (Set<NodeDescriptor> cluster : clustersToRemove) {
            this.clustersToCheck.remove(cluster);
        }
        Iterator<Object> iterator = this.indices.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            for (int j : this.indices) {
                map.put(j, 0);
            }
            this.mapBetweenArcs.put(i, map);
        }
        for (EdgeDescriptor e : this.moduleGraph.getEdges()) {
            NodeDescriptor v = (NodeDescriptor)this.moduleGraph.getSource((Object)e);
            NodeDescriptor nodeDescriptor = (NodeDescriptor)this.moduleGraph.getDest((Object)e);
            int i = this.mapClusterIndex.get(v);
            int j = this.mapClusterIndex.get(nodeDescriptor);
            this.changeCell(i, j, 1);
        }
        this.mq = this.MQ();
    }

    private void changeCell(int i, int j, int k) {
        int row = i <= j ? i : j;
        int column = i <= j ? j : i;
        int a = this.mapBetweenArcs.get(row).get(column);
        this.mapBetweenArcs.get(row).put(column, a += k);
    }

    private void changeSize(int i, int k) {
        int a = this.size.get(i);
        this.size.put(i, a += k);
    }

    private Queue<NodeDescriptor> calculatePriorities() {
        final HashMap<NodeDescriptor, Integer> priority = new HashMap<NodeDescriptor, Integer>();
        PriorityQueue<NodeDescriptor> queue = new PriorityQueue<NodeDescriptor>(this.nodenum, new Comparator<NodeDescriptor>(){

            @Override
            public int compare(NodeDescriptor v, NodeDescriptor w) {
                int priorw;
                int priorv = (Integer)priority.get(v);
                if (priorv < (priorw = ((Integer)priority.get(w)).intValue())) {
                    return -1;
                }
                if (priorv == priorw) {
                    return 0;
                }
                return 1;
            }
        });
        for (NodeDescriptor v : this.moduleGraph.getVertices()) {
            int prio = this.calculatePriority(v);
            priority.put(v, prio);
            queue.offer(v);
        }
        return queue;
    }

    private int calculatePriority(NodeDescriptor v) {
        int indexv = this.mapClusterIndex.get(v);
        int prior = 0;
        for (NodeDescriptor w : this.moduleGraph.getNeighbors((Object)v)) {
            int indexw = this.mapClusterIndex.get(w);
            if (indexv == indexw) {
                ++prior;
                continue;
            }
            --prior;
        }
        return prior *= this.size.get(indexv).intValue();
    }

    private double A(int i) {
        double a = this.mapBetweenArcs.get(i).get(i).intValue();
        int nodes = this.size.get(i);
        if (nodes > 1) {
            return a / (double)(nodes * nodes);
        }
        return 0.0;
    }

    private double E(int i, int j) {
        double a = this.mapBetweenArcs.get(i).get(j).intValue();
        return a / (double)(2 * this.size.get(i) * this.size.get(j));
    }

    private double MQ() {
        int k = 0;
        int e = 0;
        if (this.clusternum == 1) {
            double edgenum = this.moduleGraph.getEdgeCount();
            return edgenum / (double)(this.nodenum * this.nodenum);
        }
        double sumA = 0.0;
        double sumE = 0.0;
        for (int i : this.indices) {
            if (this.size.get(i) == 0) continue;
            for (int j : this.indices) {
                if (this.size.get(j) == 0) continue;
                if (i == j) {
                    sumA += this.A(i) * (double)this.size.get(i).intValue();
                    k += this.size.get(i).intValue();
                    continue;
                }
                sumE += this.E(i, j) * (double)(this.nodenum - this.size.get(i)) * (double)(this.nodenum - this.size.get(j));
                e += (this.nodenum - this.size.get(i)) * (this.nodenum - this.size.get(j));
            }
        }
        return sumA / (double)k - sumE / (double)e;
    }

    private void moveNode(NodeDescriptor v, int to) {
        int from = this.mapClusterIndex.get(v);
        if (from == to) {
            return;
        }
        if (this.size.get(to) == 0) {
            ++this.clusternum;
        }
        if (this.size.get(from) == 1) {
            --this.clusternum;
        }
        for (EdgeDescriptor e : this.moduleGraph.getInEdges((Object)v)) {
            NodeDescriptor u = (NodeDescriptor)this.moduleGraph.getSource((Object)e);
            int indexu = this.mapClusterIndex.get(u);
            this.changeCell(from, indexu, -1);
            this.changeCell(to, indexu, 1);
        }
        for (EdgeDescriptor e : this.moduleGraph.getOutEdges((Object)v)) {
            NodeDescriptor w = (NodeDescriptor)this.moduleGraph.getDest((Object)e);
            int indexw = this.mapClusterIndex.get(w);
            this.changeCell(indexw, from, -1);
            this.changeCell(indexw, to, 1);
        }
        this.changeSize(from, -1);
        this.changeSize(to, 1);
        this.mapClusterIndex.put(v, to);
    }

    private boolean checkNode(NodeDescriptor v) {
        double currentmq;
        int originalIndex = this.mapClusterIndex.get(v);
        int bestIndex = this.mapClusterIndex.get(v);
        double bestmq = this.MQ();
        if (this.size.get(originalIndex) == 1) {
            bestmq = -1.0;
        }
        for (NodeDescriptor w : this.moduleGraph.getNeighbors((Object)v)) {
            int newIndex = this.mapClusterIndex.get(w);
            this.moveNode(v, newIndex);
            currentmq = this.MQ();
            if (currentmq > bestmq) {
                bestmq = currentmq;
                bestIndex = newIndex;
            }
            this.moveNode(v, originalIndex);
        }
        if (this.clusternum < this.maxclusters) {
            this.mapIndexCluster.put(this.index, new HashSet());
            this.indices.add(this.index);
            this.size.put(this.index, 0);
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            for (int j : this.indices) {
                map.put(j, 0);
            }
            this.mapBetweenArcs.put(this.index, map);
            for (int j : this.indices) {
                this.mapBetweenArcs.get(j).put(this.index, 0);
            }
            this.moveNode(v, this.index);
            currentmq = this.MQ();
            if (currentmq > bestmq) {
                bestmq = currentmq;
                bestIndex = this.index;
            }
            this.moveNode(v, originalIndex);
            if (bestIndex != this.index) {
                this.indices.remove(this.index);
            } else {
                ++this.index;
            }
        }
        this.moveNode(v, bestIndex);
        this.mq = this.MQ();
        return originalIndex == bestIndex;
    }

    private boolean improve() {
        Queue<NodeDescriptor> queue = this.calculatePriorities();
        boolean optimal = true;
        while (!queue.isEmpty()) {
            NodeDescriptor v = queue.poll();
            boolean check = this.checkNode(v);
            optimal = optimal && check;
        }
        return optimal;
    }

    private void run() {
        boolean optimal = false;
        for (int i = 0; !optimal && i < this.maxiterations; ++i) {
            optimal = this.improve();
        }
    }

    private boolean checkCulesteringTool(BaseCluster ct, IProgressMonitor progress) {
        if (ct.createClusters((IProgressMonitor)new SubProgressMonitor(progress, 1))) {
            progress.worked(1);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.check(ct.getClusters(), (IProgressMonitor)new SubProgressMonitor(progress, 3));
            progress.worked(3);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean createClusters(IProgressMonitor monitor) {
        IProgressMonitor progress = monitor == null ? new NullProgressMonitor() : monitor;
        progress.beginTask("Creating clusters", 13);
        if (!(this.checkFolder || this.checkRegexp || this.checkModulename)) {
            this.setErronous("No clustering tool is given in the settings.\nPlease enable at least one.");
            return false;
        }
        boolean ok = false;
        this.maxmq = -2.0;
        if (this.checkFolder) {
            ok = ok || this.checkCulesteringTool(new ModuleLocationCluster((DirectedSparseGraph<NodeDescriptor, EdgeDescriptor>)this.moduleGraph, this.project), progress);
        } else {
            progress.worked(4);
        }
        if (this.checkRegexp) {
            ok = ok || this.checkCulesteringTool(new RegexpCluster((DirectedSparseGraph<NodeDescriptor, EdgeDescriptor>)this.moduleGraph), progress);
        } else {
            progress.worked(4);
        }
        if (this.checkModulename) {
            ok = ok || this.checkCulesteringTool(new ModuleNameCluster((DirectedSparseGraph<NodeDescriptor, EdgeDescriptor>)this.moduleGraph), progress);
        } else {
            progress.worked(4);
        }
        progress.done();
        if (!ok) {
            this.setErronous("All checked clustering tools failed.\nPlease enable more, or check the other clustering tools for errors.");
            return false;
        }
        return true;
    }

    private void check(Set<Set<NodeDescriptor>> clustering, IProgressMonitor monitor) {
        this.clustersToCheck = clustering;
        this.init();
        monitor.beginTask("Improving clustering", this.maxclusters - this.clusternum);
        monitor.subTask("First improvement");
        this.run();
        monitor.worked(1);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        while (this.clusternum > this.maxclusters) {
            monitor.subTask("Reducing number of clusters: " + (this.clusternum - this.maxclusters));
            if (!this.mergeBest()) break;
            this.createCurrentClusters();
            this.init();
            this.run();
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        this.end();
        monitor.done();
    }

    private void end() {
        this.mq = this.MQ();
        if (this.mq > this.maxmq) {
            this.createCurrentClusters();
            this.maxmq = this.mq;
            this.clusters = this.clustersToCheck;
        }
    }

    private void createCurrentClusters() {
        Set<NodeDescriptor> cluster;
        this.clustersToCheck = new HashSet<Set<NodeDescriptor>>();
        for (int i : this.indices) {
            cluster = this.mapIndexCluster.get(i);
            cluster.clear();
        }
        for (NodeDescriptor v : this.moduleGraph.getVertices()) {
            cluster = this.mapIndexCluster.get(this.mapClusterIndex.get(v));
            cluster.add(v);
            v.setCluster(cluster);
        }
        for (int i : this.indices) {
            cluster = this.mapIndexCluster.get(i);
            if (cluster.isEmpty()) continue;
            this.clustersToCheck.add(cluster);
        }
    }

    private void mergeClusters(int from, int to) {
        for (NodeDescriptor v : this.moduleGraph.getVertices()) {
            if (this.mapClusterIndex.get(v) != from) continue;
            this.mapClusterIndex.put(v, to);
        }
    }

    private boolean mergeBest() {
        int max = 0;
        int besti = -1;
        int bestj = -1;
        for (int i : this.indices) {
            for (int j : this.indices) {
                int a = this.mapBetweenArcs.get(i).get(j);
                if (i == j || a <= max) continue;
                max = a;
                besti = i;
                bestj = j;
            }
        }
        if (besti != -1) {
            this.mergeClusters(besti, bestj);
            return true;
        }
        return false;
    }

    @Override
    public void createGraph() {
        this.clusterGraph = ClusteringTools.generateClusterGraph((DirectedSparseGraph<NodeDescriptor, EdgeDescriptor>)this.moduleGraph, this.clusters);
    }

    @Override
    protected void reportError() {
        this.errorHandler.reportBadSetting("Clustering failure", this.msg, "Open Clustering Preferences", "org.eclipse.titanium.preferences.pages.GraphClusterAutoPage");
    }

    @Override
    protected String getType() {
        return "Clustering automatically";
    }

    @Override
    protected int getTotalWork() {
        return 9;
    }

    @Override
    protected int getClusteringWork() {
        return 7;
    }
}

