/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.clustering;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titanium.Activator;
import org.eclipse.titanium.graph.clustering.visualization.ClusterEdge;
import org.eclipse.titanium.graph.clustering.visualization.ClusterNode;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;

public final class ClusteringTools {
    private static List<String> prefixes = ClusteringTools.createPrefix();

    private ClusteringTools() {
    }

    private static List<String> createPrefix() {
        ArrayList<String> list = new ArrayList<String>();
        String stringList = Platform.getPreferencesService().getString("org.eclipse.titanium", "Graph_Folder_Truncate", "", null);
        List splittedList = ResourceExclusionHelper.intelligentSplit((String)stringList, (char)'#', (char)'\\');
        for (String item : splittedList) {
            list.add(item);
        }
        return list;
    }

    public static String truncate(String name) {
        String best = null;
        int size = 0;
        for (String s : prefixes) {
            if (!name.startsWith(s) || s.length() <= size) continue;
            size = s.length();
            best = s;
        }
        if (best == null) {
            return name;
        }
        return name.replace(best, "...");
    }

    public static DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> generateClusterGraph(DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> moduleGraph, Map<String, Set<NodeDescriptor>> mapNameCluster) {
        HashMap<Set<NodeDescriptor>, ClusterNode> mapClusterNode = new HashMap<Set<NodeDescriptor>, ClusterNode>();
        DirectedSparseGraph clusterGraph = new DirectedSparseGraph();
        for (Map.Entry<String, Set<NodeDescriptor>> entry : mapNameCluster.entrySet()) {
            String name = entry.getKey();
            Set<NodeDescriptor> cluster = entry.getValue();
            for (NodeDescriptor v : cluster) {
                v.setCluster(cluster);
            }
            ClusterNode clusternode = new ClusterNode(name, cluster);
            clusterGraph.addVertex((Object)clusternode);
            mapClusterNode.put(cluster, clusternode);
        }
        for (EdgeDescriptor e : moduleGraph.getEdges()) {
            NodeDescriptor v = (NodeDescriptor)moduleGraph.getSource((Object)e);
            NodeDescriptor w = (NodeDescriptor)moduleGraph.getDest((Object)e);
            Set<NodeDescriptor> clusterv = v.getCluster();
            Set<NodeDescriptor> clusterw = w.getCluster();
            if (clusterv == null || clusterw == null || clusterv == clusterw) continue;
            ClusterNode clusterNodev = (ClusterNode)mapClusterNode.get(clusterv);
            ClusterNode clusterNodew = (ClusterNode)mapClusterNode.get(clusterw);
            if (clusterNodev == null || clusterNodew == null) continue;
            EdgeDescriptor ce = (EdgeDescriptor)clusterGraph.findEdge((Object)clusterNodev, (Object)clusterNodew);
            if (ce != null) {
                ce.setWeight((Integer)ce.getWeight() + 1);
                continue;
            }
            ce = new ClusterEdge(clusterNodev.getName() + "-" + clusterNodew.getName(), 1);
            clusterGraph.addEdge((Object)ce, (Object)clusterNodev, (Object)clusterNodew);
        }
        return clusterGraph;
    }

    public static DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> generateClusterGraph(DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> moduleGraph, Set<Set<NodeDescriptor>> clusters) {
        HashMap<String, Set<NodeDescriptor>> mapNameCluster = new HashMap<String, Set<NodeDescriptor>>();
        Integer i = 0;
        for (Set<NodeDescriptor> cluster : clusters) {
            i = i + 1;
            mapNameCluster.put(i.toString(), cluster);
        }
        return ClusteringTools.generateClusterGraph(moduleGraph, mapNameCluster);
    }

    static {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if ("Graph_Folder_Truncate".equals(property)) {
                        prefixes = ClusteringTools.createPrefix();
                        return;
                    }
                }
            });
        }
    }
}

