/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.clustering;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.graph.clustering.BaseCluster;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;

public abstract class PathCluster
extends BaseCluster {
    protected IProject project;
    protected ProjectSourceParser parser;
    protected Map<String, NodeDescriptor> mapNameNode;

    public PathCluster(DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> graph, IProject project) {
        this.moduleGraph = graph;
        this.project = project;
        this.successful = true;
        this.mapNameNode = new HashMap<String, NodeDescriptor>();
        this.clusters = new HashSet();
        this.mapNameCluster = new HashMap();
        this.parser = GlobalParser.getProjectSourceParser((IProject)project);
    }

    @Override
    public boolean createClusters(IProgressMonitor monitor) {
        IProgressMonitor progress = monitor == null ? new NullProgressMonitor() : monitor;
        progress.beginTask("Creating clusters", -1);
        this.init();
        try {
            this.checkProject(progress);
            this.addMissing();
            progress.worked(1);
            progress.done();
            return this.checkClustering();
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while creating clusters", (Throwable)e);
            this.setErronous("Couldn't process every resource");
            return false;
        }
    }

    protected void addMissing() {
        HashSet<NodeDescriptor> missing = new HashSet<NodeDescriptor>();
        for (NodeDescriptor v : this.moduleGraph.getVertices()) {
            if (v.getCluster() != null) continue;
            missing.add(v);
            v.setCluster(missing);
        }
        if (!missing.isEmpty()) {
            this.clusters.add(missing);
            this.mapNameCluster.put("missing", missing);
        }
    }

    protected boolean checkClustering() {
        if (this.clusters.size() > 1) {
            return true;
        }
        this.setErronous("Less than two clusters were found.\nPerhaps there are no folders in the project.");
        return false;
    }

    protected void init() {
        for (NodeDescriptor v : this.moduleGraph.getVertices()) {
            v.setCluster(null);
            this.mapNameNode.put(v.getName(), v);
        }
    }

    protected void addNodeToCluster(String name, Set<NodeDescriptor> cluster) {
        NodeDescriptor v = this.mapNameNode.get(name);
        cluster.add(v);
        v.setCluster(cluster);
    }

    @Override
    protected void reportError() {
        this.errorHandler.reportErrorMessage(this.msg);
    }

    protected abstract void checkProject(IProgressMonitor var1) throws CoreException;
}

