/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.generators;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.Transformer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.titanium.error.ErrorHandler;
import org.eclipse.titanium.error.PrimitiveErrorHandler;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;

public abstract class GraphGenerator {
    protected DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> graph;
    protected Map<String, NodeDescriptor> labels;
    protected final Transformer<NodeDescriptor, String> labeler = new Transformer<NodeDescriptor, String>(){

        public String transform(NodeDescriptor v) {
            return v.getDisplayName();
        }
    };
    protected Job graphGenerator;
    protected IProject project;
    protected final ErrorHandler errorHandler;
    protected static final String LOG_ENTRY_NOTE = " (see error log for further information)";

    public GraphGenerator(IProject project, ErrorHandler eHandler) {
        this.project = project;
        this.errorHandler = eHandler == null ? new PrimitiveErrorHandler() : eHandler;
        this.graphGenerator = new Job("Graph generator"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    GraphGenerator.this.createGraph();
                }
                catch (Exception ex) {
                    GraphGenerator.this.errorHandler.reportException("Error while generating graph", ex);
                }
                return Status.OK_STATUS;
            }
        };
    }

    public void generateGraph() throws InterruptedException {
        this.graphGenerator.join();
        this.graph = new DirectedSparseGraph();
        this.labels = new HashMap<String, NodeDescriptor>();
        this.graphGenerator.schedule();
    }

    public DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> getGraph() throws InterruptedException {
        this.graphGenerator.join();
        return this.graph;
    }

    public Transformer<NodeDescriptor, String> getLabeler() throws InterruptedException {
        this.graphGenerator.join();
        return this.labeler;
    }

    protected abstract void createGraph() throws Exception;
}

