/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.utils;

import edu.uci.ics.jung.graph.Graph;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class CheckParallelPaths<V, E> {
    protected Graph<V, E> graph;
    protected Map<V, E> predArc;
    protected Set<Deque<E>> paths;
    protected V root;
    private boolean hasRoot;

    public CheckParallelPaths(Graph<V, E> graph) {
        this.graph = graph;
        this.paths = new HashSet<Deque<E>>();
        this.hasRoot = false;
    }

    public CheckParallelPaths(Graph<V, E> graph, V s) {
        this(graph);
        this.root = s;
        this.hasRoot = true;
    }

    public void init() {
        this.predArc = new HashMap<V, E>();
        for (Object v : this.graph.getVertices()) {
            this.predArc.put(v, null);
        }
    }

    public boolean hasParallelPaths() {
        if (this.hasRoot) {
            this.init();
            this.dfs(this.root);
        } else {
            for (Object s : this.graph.getVertices()) {
                this.init();
                this.dfs(s);
            }
        }
        return !this.paths.isEmpty();
    }

    protected void dfs(V source) {
        HashSet<Object> set = new HashSet<Object>();
        set.add(source);
        LinkedList<Object> current = new LinkedList<Object>();
        current.add(source);
        while (!current.isEmpty()) {
            Object v = current.removeLast();
            set.add(v);
            for (Object e : this.graph.getOutEdges(v)) {
                Object w = this.graph.getDest(e);
                if (set.contains(w)) {
                    this.addPaths(v, w, e);
                    continue;
                }
                this.predArc.put(w, e);
                current.add(w);
            }
        }
    }

    protected void addPaths(V v, V w, E e) {
        LinkedList path = new LinkedList();
        LinkedList<E> parallelpath = new LinkedList<E>();
        this.buildPath(w, path);
        this.buildPath(v, parallelpath);
        parallelpath.add(e);
        if (path.isEmpty() || parallelpath.isEmpty()) {
            return;
        }
        if (this.hasRoot) {
            if (parallelpath.contains(path.peekLast())) {
                return;
            }
        } else {
            while (path.peek() == parallelpath.peek()) {
                path.poll();
                parallelpath.poll();
            }
            if (path.isEmpty()) {
                return;
            }
        }
        this.paths.add(path);
        this.paths.add(parallelpath);
    }

    protected void buildPath(V s, Deque<E> path) {
        E e = this.predArc.get(s);
        while (e != null) {
            path.add(e);
            e = this.predArc.get(this.graph.getSource(e));
        }
    }

    public Set<Deque<E>> getPaths() {
        return this.paths;
    }
}

