/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.implementation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titanium.metrics.MetricData;
import org.eclipse.titanium.metrics.ModuleMetric;
import org.eclipse.titanium.metrics.implementation.BaseModuleMetric;
import org.eclipse.titanium.metrics.implementation.EffCouplingDetector;

public class MMEfferentCoupling
extends BaseModuleMetric {
    private final Map<Module, Set<Assignment>> efferentCoupling = new HashMap<Module, Set<Assignment>>();

    public MMEfferentCoupling() {
        super(ModuleMetric.EFFERENT_COUPLING);
    }

    @Override
    public void init(MetricData data) {
        this.efferentCoupling.clear();
        for (Module module : data.getModules()) {
            this.efferentCoupling.put(module, new HashSet());
        }
        for (Module module : data.getModules()) {
            module.accept(new ASTVisitor(){

                public int visit(IVisitableNode node) {
                    if (node instanceof Assignment) {
                        Assignment assignment = (Assignment)node;
                        Module myModule = assignment.getMyScope().getModuleScope();
                        node.accept((ASTVisitor)new EffCouplingDetector(myModule, MMEfferentCoupling.this.efferentCoupling));
                        return 1;
                    }
                    if (node instanceof Definition) {
                        return 1;
                    }
                    return 3;
                }
            });
        }
    }

    @Override
    public Number measure(MetricData data, Module module) {
        return this.efferentCoupling.get(module).size();
    }
}

