/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.ASN1.Undefined_Assignment;
import org.eclipse.titan.designer.AST.ASN1.definitions.SpecialASN1Module;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.core.LoadBalancingUtilities;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ASN1Assignments
extends Assignments
implements ILocateableNode {
    public static final String RESERVEDIDENTIFIER = "`{0}'' is a reserved identifier";
    private HashMap<String, ASN1Assignment> assignmentMap;
    private final List<ASN1Assignment> assignments;
    private final List<ASN1Assignment> dynamic_assignments;
    private CompilationTimeStamp lastCompilationTimeStamp;
    private CompilationTimeStamp lastUniqueNessCheckTimeStamp;
    private Location location = NULL_Location.INSTANCE;

    public ASN1Assignments() {
        this.assignments = new ArrayList<ASN1Assignment>();
        this.dynamic_assignments = new ArrayList<ASN1Assignment>();
    }

    public void setRightScope(Scope rightScope) {
        for (ASN1Assignment assignment : this.assignments) {
            assignment.setRightScope(rightScope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (Assignment assignment : this.assignments) {
            if (assignment != child) continue;
            return builder.append(".").append(assignment.getIdentifier().getDisplayName());
        }
        return builder;
    }

    @Override
    public Object[] getOutlineChildren() {
        return this.assignments.toArray();
    }

    @Override
    public String getOutlineIcon() {
        return "asn.gif";
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public boolean hasLocalAssignmentWithID(CompilationTimeStamp timestamp, Identifier identifier) {
        if (null == this.lastUniqueNessCheckTimeStamp) {
            this.checkUniqueness(timestamp);
        }
        if (this.assignmentMap.containsKey(identifier.getName())) {
            return true;
        }
        Assignments temp = SpecialASN1Module.getSpecialModule().getAssignments();
        if (!this.equals(temp)) {
            return temp.hasAssignmentWithId(timestamp, identifier);
        }
        return false;
    }

    @Override
    public Assignment getLocalAssignmentByID(CompilationTimeStamp timestamp, Identifier identifier) {
        String name;
        if (null == this.lastUniqueNessCheckTimeStamp) {
            this.checkUniqueness(timestamp);
        }
        if (this.assignmentMap.containsKey(name = identifier.getName())) {
            ASN1Assignment real;
            Assignment temp = this.assignmentMap.get(name);
            if (temp instanceof Undefined_Assignment && null != (real = ((Undefined_Assignment)temp).getRealAssignment(timestamp))) {
                return real;
            }
            return temp;
        }
        Assignments temp = SpecialASN1Module.getSpecialModule().getAssignments();
        if (!this.equals(temp)) {
            return temp.getLocalAssignmentByID(timestamp, identifier);
        }
        return null;
    }

    @Override
    public int getNofAssignments() {
        return this.assignments.size() + this.dynamic_assignments.size();
    }

    @Override
    public Assignment getAssignmentByIndex(int i) {
        if (i < this.assignments.size()) {
            return this.assignments.get(i);
        }
        return this.dynamic_assignments.get(i - this.assignments.size());
    }

    public void addAssignment(Assignment assignment) {
        if (null != assignment && null != assignment.getIdentifier() && null != assignment.getLocation() && assignment instanceof ASN1Assignment) {
            this.assignments.add((ASN1Assignment)assignment);
            assignment.setMyScope(this);
            assignment.setFullNameParent(this);
        }
    }

    public void addDynamicAssignment(CompilationTimeStamp timestamp, ASN1Assignment assignment) {
        if (null == assignment || null == assignment.getIdentifier()) {
            return;
        }
        if (null == this.lastUniqueNessCheckTimeStamp) {
            this.checkUniqueness(timestamp);
        }
        this.dynamic_assignments.add(assignment);
        assignment.setMyScope(this);
        Identifier identifier = assignment.getIdentifier();
        String assignmentName = identifier.getName();
        Assignments specialAssignments = SpecialASN1Module.getSpecialModule().getAssignments();
        if (specialAssignments.hasAssignmentWithId(timestamp, identifier)) {
            Location tempLocation = assignment.getIdentifier().getLocation();
            tempLocation.reportSemanticError(MessageFormat.format(RESERVEDIDENTIFIER, identifier.getDisplayName()));
        } else if (this.assignmentMap.containsKey(assignmentName)) {
            Location otherLocation = this.assignmentMap.get(assignmentName).getIdentifier().getLocation();
            otherLocation.reportSingularSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was first declared here", identifier.getDisplayName()));
            Location selfLocation = assignment.getIdentifier().getLocation();
            selfLocation.reportSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was declared here again", identifier.getDisplayName()));
        } else {
            this.assignmentMap.put(assignmentName, assignment);
        }
    }

    public void checkUniqueness(CompilationTimeStamp timestamp) {
        if (null != this.lastUniqueNessCheckTimeStamp && !this.lastUniqueNessCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        if (null == this.assignmentMap) {
            this.assignmentMap = new HashMap(this.assignments.size());
        }
        this.lastUniqueNessCheckTimeStamp = timestamp;
        this.dynamic_assignments.clear();
        this.assignmentMap.clear();
        Assignments specialAssignments = SpecialASN1Module.getSpecialModule().getAssignments();
        for (ASN1Assignment assignment : this.assignments) {
            Identifier identifier = assignment.getIdentifier();
            String assignmentName = identifier.getName();
            if (specialAssignments.hasAssignmentWithId(timestamp, identifier)) {
                Location selfLocation = assignment.getIdentifier().getLocation();
                selfLocation.reportSemanticError(MessageFormat.format(RESERVEDIDENTIFIER, identifier.getDisplayName()));
                continue;
            }
            if (this.assignmentMap.containsKey(assignmentName)) {
                Location otherLocation = this.assignmentMap.get(assignmentName).getIdentifier().getLocation();
                otherLocation.reportSingularSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was first declared here", identifier.getDisplayName()));
                Location selfLocation = assignment.getIdentifier().getLocation();
                selfLocation.reportSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was declared here again", identifier.getDisplayName()));
                continue;
            }
            this.assignmentMap.put(assignmentName, assignment);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (null != this.lastCompilationTimeStamp && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        this.checkUniqueness(timestamp);
        this.lastCompilationTimeStamp = timestamp;
        for (int i = 0; i < this.assignments.size(); ++i) {
            this.assignments.get(i).check(timestamp);
            LoadBalancingUtilities.astNodeChecked();
        }
    }

    @Override
    public void postCheck() {
        for (int i = 0; i < this.assignments.size(); ++i) {
            this.assignments.get(i).postCheck();
        }
    }

    @Override
    public void addProposal(ProposalCollector propCollector) {
        if (null == propCollector.getReference().getModuleIdentifier()) {
            for (ASN1Assignment assignment : this.assignments) {
                assignment.addProposal(propCollector, 0);
            }
        }
        super.addProposal(propCollector);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector) {
        Reference reference = declarationCollector.getReference();
        if (null == reference.getModuleIdentifier()) {
            Identifier id = reference.getId();
            String name = id.getName();
            for (ASN1Assignment assignment : this.assignments) {
                if (!assignment.getIdentifier().getName().equals(name)) continue;
                assignment.addDeclaration(declarationCollector, 0);
            }
        }
        super.addDeclaration(declarationCollector);
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        if (this.assignments != null) {
            for (ASN1Assignment assignment : this.assignments) {
                if (!assignment.getLikelyLocation().containsOffset(offset)) continue;
                return assignment;
            }
        }
        if (this.dynamic_assignments != null) {
            for (ASN1Assignment assignment : this.dynamic_assignments) {
                if (!assignment.getLikelyLocation().containsOffset(offset)) continue;
                return assignment;
            }
        }
        return null;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        for (ASN1Assignment ass : this.assignments) {
            ass.findReferences(referenceFinder, foundIdentifiers);
        }
        for (ASN1Assignment ass : this.dynamic_assignments) {
            ass.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        for (ASN1Assignment ass : this.assignments) {
            if (ass.accept(v)) continue;
            return false;
        }
        ArrayList<ASN1Assignment> tempAssignments = new ArrayList<ASN1Assignment>(this.dynamic_assignments);
        for (ASN1Assignment ass : tempAssignments) {
            if (ass.accept(v)) continue;
            return false;
        }
        return v.leave(this) != 2;
    }

    @Override
    public Iterator<Assignment> iterator() {
        return new Iterator<Assignment>(){
            Iterator<ASN1Assignment> it;
            {
                this.it = ASN1Assignments.this.assignments.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Assignment next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

