/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.Object;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASN1.ASN1Object;
import org.eclipse.titan.designer.AST.ASN1.Object.ASN1Objects;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClass_Definition;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectSet_definition;
import org.eclipse.titan.designer.AST.ASN1.Object.Object_Definition;
import org.eclipse.titan.designer.AST.ASN1.Object.Referenced_ObjectSet;
import org.eclipse.titan.designer.AST.ASN1.ObjectClass;
import org.eclipse.titan.designer.AST.ASN1.ObjectSet;
import org.eclipse.titan.designer.AST.ASN1.ObjectSetElement_Visitor;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ObjectSetElementVisitor_objectCollector
extends ObjectSetElement_Visitor {
    private static final String OBJECTOFCLASSEXPECTED = "Objects of objectclass `{0}'' are expected; `{1}'' is object of class `{2}''";
    private final ObjectClass_Definition governor;
    private final Set<Object> visitedElements = new HashSet<Object>();
    private ASN1Objects objects;
    private final CompilationTimeStamp timestamp;

    public ObjectSetElementVisitor_objectCollector(ObjectSet parent, CompilationTimeStamp timestamp) {
        super(parent.getLocation());
        this.governor = parent.getMyGovernor().getRefdLast(timestamp, null);
        this.objects = new ASN1Objects();
        this.timestamp = timestamp;
    }

    public ObjectSetElementVisitor_objectCollector(Location location, ObjectClass governor, CompilationTimeStamp timestamp) {
        super(location);
        this.governor = governor.getRefdLast(timestamp, null);
        this.objects = new ASN1Objects();
        this.timestamp = timestamp;
    }

    @Override
    public void visitObject(ASN1Object p) {
        Object_Definition object = p.getRefdLast(this.timestamp, null);
        if (object.getIsErroneous(this.timestamp)) {
            return;
        }
        if (this.visitedElements.contains(object)) {
            return;
        }
        if (!this.governor.equals(object.getMyGovernor().getRefdLast(this.timestamp, null))) {
            this.location.reportSemanticError(MessageFormat.format(OBJECTOFCLASSEXPECTED, this.governor.getFullName(), p.getFullName(), p.getMyGovernor().getRefdLast(this.timestamp, null).getFullName()));
            return;
        }
        this.visitedElements.add(object);
        this.objects.addObject(object);
    }

    @Override
    public void visitObjectSetReferenced(Referenced_ObjectSet p) {
        this.visitObjectSet(p, false);
    }

    public void visitObjectSet(ObjectSet p, boolean force) {
        ObjectSet_definition os = p.getRefdLast(this.timestamp, null);
        ObjectClass tempGovernor = os.getMyGovernor();
        if (null == tempGovernor) {
            return;
        }
        if (!this.governor.equals(tempGovernor.getRefdLast(this.timestamp, null))) {
            p.getLocation().reportSemanticError(MessageFormat.format(OBJECTOFCLASSEXPECTED, this.governor.getFullName(), p.getFullName(), tempGovernor.getRefdLast(this.timestamp, null).getFullName()));
            return;
        }
        if (this.visitedElements.contains(os)) {
            if (!force) {
                return;
            }
        } else {
            this.visitedElements.add(os);
        }
        ASN1Objects otherObjects = os.getObjs();
        otherObjects.trimToSize();
        for (int i = 0; i < otherObjects.getNofObjects(); ++i) {
            this.visitObject(otherObjects.getObjectByIndex(i));
        }
    }

    public ASN1Objects getObjects() {
        return this.objects;
    }

    public ASN1Objects giveObjects() {
        ASN1Objects temp = this.objects;
        this.objects = null;
        return temp;
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }
}

