/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.ASN1.ASN1Object;
import org.eclipse.titan.designer.AST.ASN1.Ass_pard;
import org.eclipse.titan.designer.AST.ASN1.ObjectClass;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Object_Assignment
extends ASN1Assignment {
    public static final String PARAMETERISEDOBJECT = "`{0}'' is a parameterized object assignment";
    private final ObjectClass objectClass;
    private final ASN1Object object;

    public Object_Assignment(Identifier id, Ass_pard assPard, ObjectClass objectClass, ASN1Object object) {
        super(id, assPard);
        this.objectClass = objectClass;
        this.object = object;
        if (null != objectClass) {
            objectClass.setFullNameParent(this);
        }
        if (null != object) {
            object.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_OC;
    }

    @Override
    protected ASN1Assignment internalNewInstance(Identifier identifier) {
        return new Object_Assignment(identifier, null, this.objectClass.newInstance(), this.object.newInstance());
    }

    @Override
    public void setRightScope(Scope rightScope) {
        if (null != this.object) {
            this.object.setMyScope(rightScope);
        }
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.objectClass) {
            this.objectClass.setMyScope(scope);
        }
        if (null != this.object) {
            this.object.setMyScope(scope);
        }
    }

    public ASN1Object getObject(CompilationTimeStamp timestamp) {
        if (null != this.assPard) {
            this.location.reportSemanticError(MessageFormat.format(PARAMETERISEDOBJECT, this.getFullName()));
            return null;
        }
        this.check(timestamp);
        return this.object;
    }

    @Override
    public ASN1Object getSetting(CompilationTimeStamp timestamp) {
        return this.getObject(timestamp);
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (null != this.assPard) {
            this.assPard.check(timestamp);
            return;
        }
        if (null != this.objectClass) {
            this.objectClass.check(timestamp);
        }
        if (null != this.object) {
            this.object.setMyGovernor(this.objectClass);
            this.object.check(timestamp);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > i && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            if (subrefs.size() > i + 1 && null != this.object) {
                this.object.addDeclaration(declarationCollector, i + 1);
            } else if (subrefs.size() == i + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(i).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= i) {
            return;
        }
        if (subrefs.size() == i + 1 && this.identifier.getName().toLowerCase().startsWith(subrefs.get(i).getId().getName().toLowerCase())) {
            propCollector.addProposal(this.identifier, " - Object assignment", ImageCache.getImage(this.getOutlineIcon()), "Object assignment");
        } else if (subrefs.size() > i + 1 && null != this.objectClass && this.identifier.getName().equals(subrefs.get(i).getId().getName())) {
            this.objectClass.addProposal(propCollector, i + 1);
        }
    }

    @Override
    public String getAssignmentName() {
        return "information object";
    }

    @Override
    public String getOutlineIcon() {
        return "titan.gif";
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.objectClass != null && !this.objectClass.accept(v)) {
            return false;
        }
        return this.object == null || this.object.accept(v);
    }
}

