/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ArraySubReference
extends ASTNode
implements ISubReference,
ILocateableNode {
    public static final String INVALIDSUBREFERENCE = "Type `{0}'' can not be indexed";
    public static final String INVALIDVALUESUBREFERENCE = "Invalid array element reference: type `{0}'' can not be indexed";
    public static final String INVALIDSTRINGELEMENTINDEX = "A string element cannot be indexed";
    public static final String INTEGERINDEXEXPECTED = "An integer value was expected as index";
    public static final String NATIVEINTEGEREXPECTED = "Using a large integer value ({0}) as index is not supported";
    private static final String ARRAYSUBFULLNAME = ".<array_index>";
    private static final Identifier ID = new Identifier(Identifier.Identifier_type.ID_NAME, "");
    private final Value value;
    private Location location;

    public ArraySubReference(Value value) {
        this.value = value;
        if (null != value) {
            value.setFullNameParent(this);
        }
    }

    public Value getValue() {
        return this.value;
    }

    @Override
    public ISubReference.Subreference_type getReferenceType() {
        return ISubReference.Subreference_type.arraySubReference;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (child == this.value) {
            return builder.append(ARRAYSUBFULLNAME);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.value) {
            this.value.setMyScope(scope);
        }
    }

    @Override
    public Identifier getId() {
        return ID;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return "arraySubReference";
    }

    @Override
    public void appendDisplayName(StringBuilder builder) {
        builder.append('[');
        if (null != this.value) {
            builder.append(this.value.createStringRepresentation());
        }
        builder.append(']');
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (null != this.value) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value == null) {
            return;
        }
        this.value.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.value == null || this.value.accept(v);
    }
}

