/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ControlPart;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FriendModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Group;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ImportModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.core.LoadBalancingUtilities;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.SkeletonTemplateProposal;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Keywords;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITTCN3ReparseBase;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;

public final class Definitions
extends Assignments
implements ILocateableNode {
    private final List<Definition> definitions = new CopyOnWriteArrayList<Definition>();
    private Location location;
    private HashMap<String, Definition> definitionMap;
    protected List<Definition> doubleDefinitions;
    private CompilationTimeStamp lastCompilationTimeStamp;
    protected CompilationTimeStamp lastUniquenessCheckTimeStamp;
    private final List<Group> groups;

    public Definitions() {
        this.groups = new ArrayList<Group>();
        this.scopeName = "definitions";
        this.location = NULL_Location.INSTANCE;
    }

    public Definitions(List<Definition> definitions, Location location) {
        this.addDefinitions(definitions);
        this.groups = new ArrayList<Group>();
        this.location = location;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (Definition definition : this.definitions) {
            if (definition != child) continue;
            Identifier identifier = definition.getIdentifier();
            return builder.append(".").append(identifier.getDisplayName());
        }
        int size = this.groups.size();
        for (int i = 0; i < size; ++i) {
            Group group = this.groups.get(i);
            if (group != child) continue;
            Identifier identifier = group.getIdentifier();
            return builder.append(".").append(identifier.getDisplayName());
        }
        return builder;
    }

    @Override
    public int getNofAssignments() {
        return this.definitions.size();
    }

    @Override
    public Definition getAssignmentByIndex(int i) {
        return this.definitions.get(i);
    }

    protected void removeGroups() {
    }

    @Override
    public Object[] getOutlineChildren() {
        ArrayList<ASTNode> outlineDefinitions = new ArrayList<ASTNode>();
        outlineDefinitions.addAll(this.definitions);
        outlineDefinitions.addAll(this.groups);
        Collections.sort(outlineDefinitions, new Comparator<IOutlineElement>(){

            @Override
            public int compare(IOutlineElement o1, IOutlineElement o2) {
                Location l1 = o1.getIdentifier().getLocation();
                Location l2 = o2.getIdentifier().getLocation();
                if (l1.getOffset() < l2.getOffset()) {
                    return -1;
                }
                if (l1.getOffset() > l2.getOffset()) {
                    return 1;
                }
                return 0;
            }
        });
        return outlineDefinitions.toArray();
    }

    @Override
    public String getOutlineIcon() {
        return "ttcn.gif";
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    public void addDefinition(Definition definition) {
        this.lastUniquenessCheckTimeStamp = null;
        if (definition != null && definition.getIdentifier() != null && definition.getIdentifier().getLocation() != null) {
            definition.setMyScope(this);
            this.definitions.add(definition);
            definition.setFullNameParent(this);
        }
    }

    public void addDefinitions(List<Definition> definitionList) {
        this.lastUniquenessCheckTimeStamp = null;
        if (definitionList != null) {
            for (Definition definition : definitionList) {
                this.addDefinition(definition);
            }
        }
    }

    public void addGroup(Group group) {
        if (group != null && group.getIdentifier() != null && group.getIdentifier().getLocation() != null) {
            group.setMyScope(this);
            this.groups.add(group);
            group.setFullNameParent(this);
        }
    }

    protected void checkUniqueness(CompilationTimeStamp timestamp) {
        String definitionName;
        if (this.lastUniquenessCheckTimeStamp != null && !this.lastUniquenessCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        if (this.lastUniquenessCheckTimeStamp == null) {
            this.definitionMap = new HashMap(this.definitions.size());
            for (Definition definition : this.definitions) {
                definitionName = definition.getIdentifier().getName();
                if (this.definitionMap.containsKey(definitionName)) {
                    if (this.doubleDefinitions == null) {
                        this.doubleDefinitions = new ArrayList<Definition>();
                    }
                    this.doubleDefinitions.add(definition);
                    continue;
                }
                this.definitionMap.put(definitionName, definition);
            }
            if (this.doubleDefinitions != null) {
                int size = this.doubleDefinitions.size();
                for (int i = 0; i < size; ++i) {
                    this.definitions.remove(this.doubleDefinitions.get(i));
                }
            }
        }
        if (this.doubleDefinitions != null) {
            int size = this.doubleDefinitions.size();
            for (int i = 0; i < size; ++i) {
                Definition definition = this.doubleDefinitions.get(i);
                Identifier identifier = definition.getIdentifier();
                definitionName = identifier.getName();
                try {
                    Location otherLocation = this.definitionMap.get(definitionName).getIdentifier().getLocation();
                    otherLocation.reportSingularSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was first declared here", identifier.getDisplayName()));
                    identifier.getLocation().reportSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was declared here again", identifier.getDisplayName()));
                    continue;
                }
                catch (NullPointerException e) {
                    ErrorReporter.logError((String)("Nullpointer was detected when reporting duplication error for definition: " + definitionName));
                    throw e;
                }
            }
        }
        this.lastUniquenessCheckTimeStamp = timestamp;
    }

    private void checkGroups(CompilationTimeStamp timestamp) {
        int i;
        if (this.groups.isEmpty()) {
            return;
        }
        HashMap<String, Group> groupMap = new HashMap<String, Group>(this.groups.size());
        HashMap<String, Definition> defs = new HashMap<String, Definition>(this.definitions.size());
        for (Definition definition : this.definitions) {
            String defName;
            if (definition.getParentGroup() != null || defs.containsKey(defName = definition.getIdentifier().getName())) continue;
            defs.put(defName, definition);
        }
        int size = this.groups.size();
        for (i = 0; i < size; ++i) {
            Group group = this.groups.get(i);
            String groupName = group.getIdentifier().getName();
            if (defs.containsKey(groupName)) {
                group.getIdentifier().getLocation().reportSemanticError(MessageFormat.format("Group name `{0}'' clashes with a definition", groupName));
                ((Definition)defs.get(groupName)).getIdentifier().getLocation().reportSingularSemanticError(MessageFormat.format("Definition of `{0}'' is here", groupName));
            }
            if (groupMap.containsKey(groupName)) {
                ((Group)groupMap.get(groupName)).getIdentifier().getLocation().reportSingularSemanticError(MessageFormat.format("Duplicate group definition with name `{0}'' was first defined here", groupName));
                group.getIdentifier().getLocation().reportSemanticError(MessageFormat.format("Duplicate group definition with name `{0}'' was defined here again", groupName));
                continue;
            }
            groupMap.put(groupName, group);
        }
        size = this.groups.size();
        for (i = 0; i < size; ++i) {
            this.groups.get(i).check(timestamp);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastCompilationTimeStamp != null && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        Module module = this.getModuleScope();
        if (module != null && module.getSkippedFromSemanticChecking()) {
            this.lastCompilationTimeStamp = timestamp;
            return;
        }
        this.checkUniqueness(timestamp);
        this.checkGroups(timestamp);
        this.lastCompilationTimeStamp = timestamp;
        Iterator<Definition> iterator = this.definitions.iterator();
        while (iterator.hasNext()) {
            iterator.next().check(timestamp);
            LoadBalancingUtilities.astNodeChecked();
        }
    }

    public void checkWithDefinitions(CompilationTimeStamp timestamp, List<Assignment> assignments) {
        if (this.lastCompilationTimeStamp != null && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        this.checkUniqueness(timestamp);
        this.checkGroups(timestamp);
        this.lastCompilationTimeStamp = timestamp;
        for (Assignment assignmentFrom : assignments) {
            if (!this.definitionMap.containsKey(assignmentFrom.getIdentifier().getName())) continue;
            assignmentFrom.check(timestamp);
            LoadBalancingUtilities.astNodeChecked();
        }
    }

    @Override
    public void postCheck() {
        Module module = this.getModuleScope();
        if (module != null && module.getSkippedFromSemanticChecking()) {
            return;
        }
        Iterator<Definition> iterator = this.definitions.iterator();
        while (iterator.hasNext()) {
            iterator.next().postCheck();
        }
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference) {
        return this.getAssBySRef(timestamp, reference, null);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference, IReferenceChain refChain) {
        Definition result;
        if (reference.getModuleIdentifier() != null) {
            return this.getModuleScope().getAssBySRef(timestamp, reference);
        }
        Identifier identifier = reference.getId();
        if (identifier == null) {
            return this.getModuleScope().getAssBySRef(timestamp, reference);
        }
        if (this.lastUniquenessCheckTimeStamp == null) {
            this.checkUniqueness(timestamp);
        }
        if ((result = this.definitionMap.get(identifier.getName())) != null) {
            return result;
        }
        return this.getParentScope().getAssBySRef(timestamp, reference);
    }

    @Override
    public Definition getLocalAssignmentByID(CompilationTimeStamp timestamp, Identifier id) {
        if (this.lastUniquenessCheckTimeStamp == null) {
            this.checkUniqueness(timestamp);
        }
        return this.definitionMap.get(id.getName());
    }

    @Override
    public boolean hasLocalAssignmentWithID(CompilationTimeStamp timestamp, Identifier identifier) {
        if (this.lastUniquenessCheckTimeStamp == null) {
            this.checkUniqueness(timestamp);
        }
        return this.definitionMap.containsKey(identifier.getName());
    }

    @Override
    public void addProposal(ProposalCollector propCollector) {
        if (propCollector.getReference().getModuleIdentifier() == null) {
            Iterator<Definition> iterator = this.definitions.iterator();
            while (iterator.hasNext()) {
                iterator.next().addProposal(propCollector, 0);
            }
        }
        super.addProposal(propCollector);
    }

    @Override
    public void addSkeletonProposal(ProposalCollector propCollector) {
        for (SkeletonTemplateProposal templateProposal : TTCN3CodeSkeletons.MODULE_LEVEL_SKELETON_PROPOSALS) {
            propCollector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), TTCN3CodeSkeletons.SKELETON_IMAGE);
        }
    }

    @Override
    public void addKeywordProposal(ProposalCollector propCollector) {
        propCollector.addProposal(TTCN3Keywords.MODULE_SCOPE, null, "keyword");
        propCollector.addProposal(TTCN3Keywords.GENERALLY_USABLE, null, "keyword");
        super.addKeywordProposal(propCollector);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector) {
        if (!this.groups.isEmpty()) {
            for (Group item : this.groups) {
                item.addDeclaration(declarationCollector);
            }
        }
        if (declarationCollector.getReference().getModuleIdentifier() == null) {
            Iterator<Definition> iterator = this.definitions.iterator();
            while (iterator.hasNext()) {
                iterator.next().addDeclaration(declarationCollector, 0);
            }
        }
        super.addDeclaration(declarationCollector);
    }

    public void updateSyntax(TTCN3ReparseUpdater reparser, List<ImportModule> importedModules, List<FriendModule> friendModules, ControlPart controlpart) throws ReParseException {
        IVisitableNode temp;
        int i;
        int i2;
        Location tempLocation;
        Location tempLocation2;
        int i3;
        boolean isControlPossible;
        int result = 0;
        if (this.doubleDefinitions != null) {
            this.definitions.addAll(this.doubleDefinitions);
        }
        boolean enveloped = false;
        int nofDamaged = 0;
        int leftBoundary = this.location.getOffset() + 1;
        int rightBoundary = this.location.getEndOffset() - 1;
        int damageOffset = reparser.getDamageStart();
        IVisitableNode lastAppendableBeforeChange = null;
        IVisitableNode lastPrependableBeforeChange = null;
        boolean bl = isControlPossible = controlpart == null;
        if (controlpart != null) {
            Location tempLocation3 = controlpart.getLocation();
            if (reparser.envelopsDamage(tempLocation3)) {
                enveloped = true;
            } else if (!reparser.isDamaged(tempLocation3)) {
                if (tempLocation3.getEndOffset() < damageOffset && tempLocation3.getEndOffset() > leftBoundary) {
                    leftBoundary = tempLocation3.getEndOffset() + 1;
                    lastAppendableBeforeChange = controlpart;
                }
                if (tempLocation3.getOffset() >= damageOffset && tempLocation3.getOffset() < rightBoundary) {
                    rightBoundary = tempLocation3.getOffset();
                    lastPrependableBeforeChange = controlpart;
                }
            }
        }
        int size = this.groups.size();
        for (i3 = 0; i3 < size && !enveloped; ++i3) {
            Group tempGroup = this.groups.get(i3);
            tempLocation2 = tempGroup.getLocation();
            if (reparser.envelopsDamage(tempLocation2)) {
                enveloped = true;
                leftBoundary = tempLocation2.getOffset();
                rightBoundary = tempLocation2.getEndOffset();
                continue;
            }
            if (reparser.isDamaged(tempLocation2)) {
                ++nofDamaged;
                continue;
            }
            if (tempLocation2.getEndOffset() < damageOffset && tempLocation2.getEndOffset() > leftBoundary) {
                leftBoundary = tempLocation2.getEndOffset();
                lastAppendableBeforeChange = tempGroup;
            }
            if (tempLocation2.getOffset() < damageOffset || tempLocation2.getOffset() >= rightBoundary) continue;
            rightBoundary = tempLocation2.getOffset();
            lastPrependableBeforeChange = tempGroup;
        }
        if (!this.groups.isEmpty()) {
            isControlPossible &= this.groups.get(this.groups.size() - 1).getLocation().getEndOffset() <= leftBoundary;
        }
        size = importedModules.size();
        for (i3 = 0; i3 < size && !enveloped; ++i3) {
            ImportModule tempImport = importedModules.get(i3);
            if (tempImport.getParentGroup() != null) continue;
            tempLocation2 = tempImport.getLocation();
            if (reparser.envelopsDamage(tempLocation2)) {
                enveloped = true;
                leftBoundary = tempLocation2.getOffset();
                rightBoundary = tempLocation2.getEndOffset();
                continue;
            }
            if (reparser.isDamaged(tempLocation2)) {
                ++nofDamaged;
                continue;
            }
            if (tempLocation2.getEndOffset() < damageOffset && tempLocation2.getEndOffset() > leftBoundary) {
                leftBoundary = tempLocation2.getEndOffset() + 1;
                lastAppendableBeforeChange = tempImport;
            }
            if (tempLocation2.getOffset() < damageOffset || tempLocation2.getOffset() >= rightBoundary) continue;
            rightBoundary = tempLocation2.getOffset();
            lastPrependableBeforeChange = tempImport;
        }
        if (!importedModules.isEmpty()) {
            isControlPossible &= importedModules.get(importedModules.size() - 1).getLocation().getEndOffset() <= leftBoundary;
        }
        size = friendModules.size();
        for (i3 = 0; i3 < size && !enveloped; ++i3) {
            FriendModule tempFriend = friendModules.get(i3);
            if (tempFriend.getParentGroup() != null) continue;
            tempLocation2 = tempFriend.getLocation();
            if (reparser.envelopsDamage(tempLocation2)) {
                enveloped = true;
                leftBoundary = tempLocation2.getOffset();
                rightBoundary = tempLocation2.getEndOffset();
                continue;
            }
            if (reparser.isDamaged(tempLocation2)) {
                ++nofDamaged;
                continue;
            }
            if (tempLocation2.getEndOffset() < damageOffset && tempLocation2.getEndOffset() > leftBoundary) {
                leftBoundary = tempLocation2.getEndOffset() + 1;
                lastAppendableBeforeChange = tempFriend;
            }
            if (tempLocation2.getOffset() < damageOffset || tempLocation2.getOffset() >= rightBoundary) continue;
            rightBoundary = tempLocation2.getOffset();
            lastPrependableBeforeChange = tempFriend;
        }
        if (!friendModules.isEmpty()) {
            isControlPossible &= friendModules.get(friendModules.size() - 1).getLocation().getEndOffset() <= leftBoundary;
        }
        Iterator<Definition> iterator = this.definitions.iterator();
        while (iterator.hasNext() && !enveloped) {
            Location tempCommentLocation;
            Location cumulativeLocation;
            Definition temp2 = iterator.next();
            if (temp2.getParentGroup() != null) continue;
            tempLocation = temp2.getLocation();
            if (tempLocation.equals(cumulativeLocation = temp2.getCumulativeDefinitionLocation()) && reparser.envelopsDamage(cumulativeLocation)) {
                enveloped = true;
                leftBoundary = cumulativeLocation.getOffset();
                rightBoundary = cumulativeLocation.getEndOffset();
            } else if (reparser.isDamaged(cumulativeLocation)) {
                ++nofDamaged;
                if (reparser.getDamageStart() == cumulativeLocation.getEndOffset()) {
                    lastAppendableBeforeChange = temp2;
                } else if (reparser.getDamageEnd() == cumulativeLocation.getOffset()) {
                    lastPrependableBeforeChange = temp2;
                }
            } else {
                if (cumulativeLocation.getEndOffset() < damageOffset && cumulativeLocation.getEndOffset() > leftBoundary) {
                    leftBoundary = cumulativeLocation.getEndOffset() + 1;
                    lastAppendableBeforeChange = temp2;
                }
                if (cumulativeLocation.getOffset() >= damageOffset && cumulativeLocation.getOffset() < rightBoundary) {
                    rightBoundary = cumulativeLocation.getOffset();
                    lastPrependableBeforeChange = temp2;
                }
            }
            if ((tempCommentLocation = temp2.getCommentLocation()) == null || !reparser.isDamaged(tempCommentLocation)) continue;
            ++nofDamaged;
            rightBoundary = tempLocation.getEndOffset() + 1;
        }
        if (!this.definitions.isEmpty()) {
            isControlPossible &= this.definitions.get(this.definitions.size() - 1).getLocation().getEndOffset() <= leftBoundary;
        }
        if (!enveloped && reparser.isDamaged(this.location)) {
            List<Integer> temp3;
            boolean isBeingExtended;
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            if (lastAppendableBeforeChange != null && (isBeingExtended = reparser.startsWithFollow(lastAppendableBeforeChange.getPossibleExtensionStarterTokens()))) {
                leftBoundary = lastAppendableBeforeChange.getLocation().getOffset();
                ++nofDamaged;
                enveloped = false;
                reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            }
            if (lastPrependableBeforeChange != null && (temp3 = lastPrependableBeforeChange.getPossiblePrefixTokens()) != null && reparser.endsWithToken(temp3)) {
                rightBoundary = lastPrependableBeforeChange.getLocation().getEndOffset();
                ++nofDamaged;
                enveloped = false;
                reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            }
            if (nofDamaged != 0) {
                this.removeStuffInRange(reparser, importedModules, friendModules);
                if (this.doubleDefinitions != null) {
                    this.doubleDefinitions.clear();
                }
                this.lastUniquenessCheckTimeStamp = null;
                this.lastCompilationTimeStamp = null;
            }
        }
        for (i2 = 0; i2 < this.groups.size(); ++i2) {
            Group temp4 = this.groups.get(i2);
            tempLocation = temp4.getLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            try {
                temp4.updateSyntax(reparser, importedModules, this.definitions, friendModules);
                continue;
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    this.groups.remove(i2);
                    --i2;
                    reparser.extendDamagedRegion(tempLocation);
                    result = 1;
                    continue;
                }
                if (this.doubleDefinitions != null) {
                    this.doubleDefinitions.clear();
                }
                this.lastUniquenessCheckTimeStamp = null;
                e.decreaseDepth();
                throw e;
            }
        }
        for (i2 = 0; i2 < importedModules.size(); ++i2) {
            ImportModule temp5 = importedModules.get(i2);
            if (temp5.getParentGroup() != null || !reparser.isAffected(tempLocation = temp5.getLocation())) continue;
            try {
                boolean isDamaged = enveloped && reparser.envelopsDamage(tempLocation);
                temp5.updateSyntax(reparser, enveloped && reparser.envelopsDamage(tempLocation));
                if (!isDamaged) continue;
                ((TTCN3Module)this.parentScope).checkRoot();
                continue;
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    importedModules.remove(i2);
                    --i2;
                    reparser.extendDamagedRegion(tempLocation);
                    result = 1;
                    continue;
                }
                if (this.doubleDefinitions != null) {
                    this.doubleDefinitions.clear();
                }
                this.lastUniquenessCheckTimeStamp = null;
                e.decreaseDepth();
                throw e;
            }
        }
        for (i2 = 0; i2 < friendModules.size(); ++i2) {
            FriendModule temp6 = friendModules.get(i2);
            if (temp6.getParentGroup() != null || !reparser.isAffected(tempLocation = temp6.getLocation())) continue;
            try {
                boolean isDamaged = enveloped && reparser.envelopsDamage(tempLocation);
                temp6.updateSyntax(reparser, enveloped && reparser.envelopsDamage(tempLocation));
                if (!isDamaged) continue;
                ((TTCN3Module)this.parentScope).checkRoot();
                continue;
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    friendModules.remove(i2);
                    --i2;
                    reparser.extendDamagedRegion(tempLocation);
                    result = 1;
                    continue;
                }
                if (this.doubleDefinitions != null) {
                    this.doubleDefinitions.clear();
                }
                this.lastUniquenessCheckTimeStamp = null;
                e.decreaseDepth();
                throw e;
            }
        }
        for (Definition temp7 : this.definitions) {
            if (temp7.getParentGroup() != null) continue;
            tempLocation = temp7.getLocation();
            Location cumulativeLocation = temp7.getCumulativeDefinitionLocation();
            if (!reparser.isAffected(cumulativeLocation)) continue;
            try {
                boolean isDamaged = enveloped && reparser.envelopsDamage(tempLocation);
                temp7.updateSyntax(reparser, isDamaged);
                if (reparser.getNameChanged()) {
                    if (this.doubleDefinitions != null) {
                        this.doubleDefinitions.clear();
                    }
                    this.lastUniquenessCheckTimeStamp = null;
                    reparser.setNameChanged(false);
                }
                if (!isDamaged) continue;
                temp7.checkRoot();
            }
            catch (ReParseException e) {
                if (e.getDepth() == 1) {
                    enveloped = false;
                    this.definitions.remove(temp7);
                    reparser.extendDamagedRegion(cumulativeLocation);
                    result = 1;
                    continue;
                }
                if (this.doubleDefinitions != null) {
                    this.doubleDefinitions.clear();
                }
                this.lastUniquenessCheckTimeStamp = null;
                e.decreaseDepth();
                throw e;
            }
        }
        if (result == 1) {
            this.removeStuffInRange(reparser, importedModules, friendModules);
            if (this.doubleDefinitions != null) {
                this.doubleDefinitions.clear();
            }
            this.lastUniquenessCheckTimeStamp = null;
            this.lastCompilationTimeStamp = null;
        }
        size = this.groups.size();
        for (i = 0; i < size; ++i) {
            temp = this.groups.get(i);
            Location tempLocation4 = ((Group)temp).getLocation();
            if (!reparser.isAffected(tempLocation4)) continue;
            reparser.updateLocation(tempLocation4);
        }
        size = importedModules.size();
        for (i = 0; i < size; ++i) {
            Location tempLocation5;
            temp = importedModules.get(i);
            if (((ImportModule)temp).getParentGroup() != null || !reparser.isAffected(tempLocation5 = ((ImportModule)temp).getLocation())) continue;
            reparser.updateLocation(tempLocation5);
        }
        size = friendModules.size();
        for (i = 0; i < size; ++i) {
            Location tempLocation6;
            temp = friendModules.get(i);
            if (((FriendModule)temp).getParentGroup() != null || !reparser.isAffected(tempLocation6 = ((FriendModule)temp).getLocation())) continue;
            reparser.updateLocation(tempLocation6);
        }
        for (Definition temp8 : this.definitions) {
            if (temp8.getParentGroup() != null) continue;
            tempLocation = temp8.getLocation();
            Location cumulativeLocation = temp8.getCumulativeDefinitionLocation();
            if (!reparser.isAffected(tempLocation)) continue;
            if (tempLocation != cumulativeLocation) {
                reparser.updateLocation(cumulativeLocation);
            }
            reparser.updateLocation(tempLocation);
        }
        boolean tempIsControlPossible = isControlPossible;
        if (!enveloped && reparser.envelopsDamage(this.location)) {
            reparser.extendDamagedRegion(leftBoundary, rightBoundary);
            result = this.reparse(reparser, tempIsControlPossible);
            result = Math.max(result - 1, 0);
            this.lastCompilationTimeStamp = null;
        }
        if (result == 0) {
            if (this.doubleDefinitions != null) {
                this.definitions.removeAll(this.doubleDefinitions);
            }
        } else {
            if (this.doubleDefinitions != null) {
                this.doubleDefinitions.clear();
            }
            this.lastUniquenessCheckTimeStamp = null;
            throw new ReParseException(result);
        }
    }

    private int reparse(TTCN3ReparseUpdater aReparser, final boolean aTempIsControlPossible) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                ArrayList<Definition> allDefinitions = new ArrayList<Definition>();
                ArrayList<Definition> localDefinitions = new ArrayList<Definition>();
                ArrayList<Group> localGroups = new ArrayList<Group>();
                ArrayList<ImportModule> allImports = new ArrayList<ImportModule>();
                ArrayList<ImportModule> localImports = new ArrayList<ImportModule>();
                ArrayList<FriendModule> allFriends = new ArrayList<FriendModule>();
                ArrayList<FriendModule> localFriends = new ArrayList<FriendModule>();
                ArrayList<ControlPart> controlParts = null;
                if (aTempIsControlPossible) {
                    controlParts = new ArrayList<ControlPart>();
                }
                TTCN3Module module = (TTCN3Module)Definitions.this.parentScope;
                parser.setModule((TTCN3Module)Definitions.this.parentScope);
                parser.pr_reparse_ModuleDefinitionsList(null, allDefinitions, localDefinitions, localGroups, allImports, localImports, allFriends, localFriends, controlParts);
                if (parser.isErrorListEmpty()) {
                    Definitions.this.addDefinitions(allDefinitions);
                    if (Definitions.this.doubleDefinitions != null) {
                        Definitions.this.doubleDefinitions.clear();
                    }
                    Definitions.this.lastUniquenessCheckTimeStamp = null;
                    for (ImportModule impmod : allImports) {
                        module.addImportedModule(impmod);
                    }
                    for (Group group : localGroups) {
                        Definitions.this.addGroup(group);
                    }
                    for (FriendModule friend : allFriends) {
                        module.addFriendModule(friend);
                    }
                    if (controlParts != null && controlParts.size() == 1) {
                        ((TTCN3Module)Definitions.this.parentScope).addControlpart((ControlPart)controlParts.get(0));
                    }
                }
            }
        });
    }

    private void removeStuffInRange(TTCN3ReparseUpdater reparser, List<ImportModule> importedModules, List<FriendModule> friendModules) {
        int i;
        for (i = this.groups.size() - 1; i >= 0; --i) {
            Group group = this.groups.get(i);
            if (!reparser.isDamaged(group.getLocation())) continue;
            reparser.extendDamagedRegion(group.getLocation());
            this.groups.remove(i);
        }
        for (i = importedModules.size() - 1; i >= 0; --i) {
            ImportModule importModule = importedModules.get(i);
            if (!reparser.isDamaged(importModule.getLocation())) continue;
            reparser.extendDamagedRegion(importModule.getLocation());
            importedModules.remove(i);
        }
        for (i = friendModules.size() - 1; i >= 0; --i) {
            FriendModule friendModule = friendModules.get(i);
            if (!reparser.isDamaged(friendModule.getLocation())) continue;
            reparser.extendDamagedRegion(friendModule.getLocation());
            friendModules.remove(i);
        }
        for (Definition definition : this.definitions) {
            if (!reparser.isDamaged(definition.getCumulativeDefinitionLocation())) continue;
            reparser.extendDamagedRegion(definition.getCumulativeDefinitionLocation());
            this.definitions.remove(definition);
        }
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        if (this.definitions == null) {
            return null;
        }
        for (Definition definition : this.definitions) {
            if (!definition.getLocation().containsOffset(offset)) continue;
            return definition;
        }
        return null;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        ArrayList<Definition> tempList = new ArrayList<Definition>(this.definitions);
        for (Definition definition : tempList) {
            definition.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        for (Definition definition : this.definitions) {
            if (definition.accept(v)) continue;
            return false;
        }
        for (Group g : this.groups) {
            if (g.accept(v)) continue;
            return false;
        }
        return v.leave(this) != 2;
    }

    @Override
    public Iterator<Assignment> iterator() {
        return new Iterator<Assignment>(){
            Iterator<Definition> it;
            {
                this.it = Definitions.this.definitions.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Assignment next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

