/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuard;
import org.eclipse.titan.designer.AST.TTCN3.statements.Else_Altguard;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class AltGuards
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String SHADOWEDBYELSE = "Control never reaches this branch of alternative because of a previous [else] branch";
    private static final String FULLNAMEPART = ".alt_guard_";
    private final ArrayList<AltGuard> altGuards = new ArrayList();
    private boolean freed = false;
    private Location location = NULL_Location.INSTANCE;

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.altGuards.size();
        for (int i = 0; i < size; ++i) {
            if (this.altGuards.get(i) != child) continue;
            return builder.append(FULLNAMEPART).append(String.valueOf(i + 1));
        }
        return builder;
    }

    public void addAltGuard(AltGuard altGuard) {
        if (altGuard != null) {
            this.altGuards.add(altGuard);
            altGuard.setFullNameParent(this);
        }
    }

    public int getNofAltguards() {
        return this.altGuards.size();
    }

    public AltGuard getAltguardByIndex(int i) {
        return this.altGuards.get(i);
    }

    @Override
    public void setMyScope(Scope scope) {
        this.altGuards.trimToSize();
        int size = this.altGuards.size();
        for (int i = 0; i < size; ++i) {
            this.altGuards.get(i).setMyScope(scope);
        }
    }

    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        int size = this.altGuards.size();
        for (int i = 0; i < size; ++i) {
            this.altGuards.get(i).setMyStatementBlock(statementBlock, index);
        }
    }

    public void setMyDefinition(Definition definition) {
        int size = this.altGuards.size();
        for (int i = 0; i < size; ++i) {
            this.altGuards.get(i).setMyDefinition(definition);
        }
    }

    public void setMyAltguards(AltGuards altGuards) {
        int size = this.altGuards.size();
        for (int i = 0; i < size; ++i) {
            this.altGuards.get(i).setMyAltguards(altGuards);
        }
    }

    public boolean hasElse() {
        int size = this.altGuards.size();
        for (int i = 0; i < size; ++i) {
            AltGuard guard = this.altGuards.get(i);
            if (guard.getType() != AltGuard.altguard_type.AG_ELSE) continue;
            return true;
        }
        return false;
    }

    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        StatementBlock.ReturnStatus_type result = StatementBlock.ReturnStatus_type.RS_MAYBE;
        int size = this.altGuards.size();
        for (int i = 0; i < size; ++i) {
            AltGuard guard = this.altGuards.get(i);
            switch (guard.hasReturn(timestamp)) {
                case RS_NO: {
                    if (result == StatementBlock.ReturnStatus_type.RS_YES) {
                        return StatementBlock.ReturnStatus_type.RS_MAYBE;
                    }
                    result = StatementBlock.ReturnStatus_type.RS_NO;
                    break;
                }
                case RS_YES: {
                    if (result == StatementBlock.ReturnStatus_type.RS_NO) {
                        return StatementBlock.ReturnStatus_type.RS_MAYBE;
                    }
                    result = StatementBlock.ReturnStatus_type.RS_YES;
                    break;
                }
                default: {
                    return StatementBlock.ReturnStatus_type.RS_MAYBE;
                }
            }
            if (guard instanceof Else_Altguard) break;
        }
        return result;
    }

    public void check(CompilationTimeStamp timestamp) {
        boolean unreachableFound = false;
        int size = this.altGuards.size();
        for (int i = 0; i < size; ++i) {
            AltGuard guard = this.altGuards.get(i);
            guard.check(timestamp);
            if (unreachableFound) {
                guard.getLocation().reportConfigurableSemanticProblem(Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportUnnecessaryControls", "warning", null), SHADOWEDBYELSE);
            }
            if (!AltGuard.altguard_type.AG_ELSE.equals((Object)guard.getType())) continue;
            unreachableFound = true;
        }
    }

    public void checkAllowedInterleave() {
        int size = this.altGuards.size();
        for (int i = 0; i < size; ++i) {
            this.altGuards.get(i).checkAllowedInterleave();
        }
    }

    public void postCheck() {
        int size = this.altGuards.size();
        for (int i = 0; i < size; ++i) {
            this.altGuards.get(i).postCheck();
        }
    }

    public void free() {
        if (StatementBlock.minimiseMemoryUsage && !this.freed) {
            this.freed = true;
            this.altGuards.clear();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.freed = false;
            boolean enveloped = false;
            int nofDamaged = 0;
            int leftBoundary = this.location.getOffset() + 1;
            int rightBoundary = this.location.getEndOffset() - 1;
            int damageOffset = reparser.getDamageStart();
            int size = this.altGuards.size();
            for (int i = 0; i < size && !enveloped; ++i) {
                AltGuard altGuard = this.altGuards.get(i);
                Location temporalLocation = altGuard.getLocation();
                if (reparser.envelopsDamage(temporalLocation)) {
                    enveloped = true;
                    leftBoundary = temporalLocation.getOffset();
                    rightBoundary = temporalLocation.getEndOffset();
                    continue;
                }
                if (reparser.isDamaged(temporalLocation)) {
                    ++nofDamaged;
                    continue;
                }
                if (temporalLocation.getEndOffset() < damageOffset && temporalLocation.getEndOffset() > leftBoundary) {
                    leftBoundary = temporalLocation.getEndOffset() + 1;
                }
                if (temporalLocation.getOffset() < damageOffset || temporalLocation.getOffset() >= rightBoundary) continue;
                rightBoundary = temporalLocation.getOffset();
            }
            if (nofDamaged != 0) {
                throw new ReParseException();
            }
            for (AltGuard altGuard : this.altGuards) {
                Location temporalLocation = altGuard.getLocation();
                if (!reparser.isAffectedAppended(temporalLocation)) continue;
                altGuard.updateSyntax(reparser, enveloped && reparser.envelopsDamage(temporalLocation));
                reparser.updateLocation(altGuard.getLocation());
            }
            return;
        }
        int size = this.altGuards.size();
        for (int i = 0; i < size; ++i) {
            AltGuard guard = this.altGuards.get(i);
            guard.updateSyntax(reparser, false);
            reparser.updateLocation(guard.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.altGuards == null) {
            return;
        }
        for (AltGuard ag : this.altGuards) {
            ag.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.altGuards != null) {
            for (AltGuard ag : this.altGuards) {
                if (ag.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

