/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstances;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SelectCase
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private static final String NEVERREACH1 = "Control never reaches this code because of previous effective cases(s)";
    private static final String FULLNAMEPART1 = ".templateinstances";
    private static final String FULLNAMEPART2 = ".block";
    private final TemplateInstances templateInstances;
    private final StatementBlock statementblock;
    private Location location = NULL_Location.INSTANCE;

    public SelectCase(TemplateInstances templateInstances, StatementBlock statementblock) {
        this.templateInstances = templateInstances;
        this.statementblock = statementblock;
        if (templateInstances != null) {
            templateInstances.setFullNameParent(this);
        }
        if (statementblock != null) {
            statementblock.setFullNameParent(this);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.templateInstances == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.statementblock == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    public StatementBlock getStatementBlock() {
        return this.statementblock;
    }

    @Override
    public void setMyScope(Scope scope) {
        if (this.templateInstances != null) {
            this.templateInstances.setMyScope(scope);
        }
        if (this.statementblock != null) {
            this.statementblock.setMyScope(scope);
        }
    }

    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        if (this.statementblock != null) {
            this.statementblock.setMyStatementBlock(statementBlock, index);
        }
    }

    public void setMyDefinition(Definition definition) {
        if (this.statementblock != null) {
            this.statementblock.setMyDefinition(definition);
        }
    }

    public void setMyAltguards(AltGuards altGuards) {
        if (this.statementblock != null) {
            this.statementblock.setMyAltguards(altGuards);
        }
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public boolean hasElse() {
        return this.templateInstances == null;
    }

    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        if (this.statementblock != null) {
            return this.statementblock.hasReturn(timestamp);
        }
        return StatementBlock.ReturnStatus_type.RS_NO;
    }

    public boolean check(CompilationTimeStamp timestamp, IType governor, boolean unreachable) {
        if (unreachable) {
            this.location.reportConfigurableSemanticProblem(Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportUnnecessaryControls", "warning", null), NEVERREACH1);
        }
        boolean unreachable2 = unreachable;
        if (this.templateInstances != null) {
            for (int i = 0; i < this.templateInstances.getNofTis(); ++i) {
                this.templateInstances.getInstanceByIndex(i).check(timestamp, governor);
            }
        } else {
            unreachable2 = true;
        }
        this.statementblock.check(timestamp);
        return unreachable2;
    }

    public void checkAllowedInterleave() {
        if (this.statementblock != null) {
            this.statementblock.checkAllowedInterleave();
        }
    }

    public void postCheck() {
        if (this.statementblock != null) {
            this.statementblock.postCheck();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.templateInstances != null) {
            this.templateInstances.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstances.getLocation());
        }
        if (this.statementblock != null) {
            this.statementblock.updateSyntax(reparser, false);
            reparser.updateLocation(this.statementblock.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInstances != null) {
            this.templateInstances.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.statementblock != null) {
            this.statementblock.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.templateInstances != null && !this.templateInstances.accept(v)) {
            return false;
        }
        return this.statementblock == null || this.statementblock.accept(v);
    }
}

