/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITemplateListItem;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class ListOfTemplates
extends ASTNode
implements IIncrementallyUpdateable,
Iterable<ITemplateListItem> {
    private final List<ITemplateListItem> templates = new ArrayList<ITemplateListItem>();

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        int size = this.templates.size();
        for (int i = 0; i < size; ++i) {
            this.templates.get(i).setMyScope(scope);
        }
    }

    public void addTemplate(ITemplateListItem template) {
        this.templates.add(template);
    }

    public int getNofTemplates() {
        return this.templates.size();
    }

    public ITemplateListItem getTemplateByIndex(int index) {
        return this.templates.get(index);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        int size = this.templates.size();
        for (int i = 0; i < size; ++i) {
            ITemplateListItem template = this.templates.get(i);
            template.updateSyntax(reparser, false);
            reparser.updateLocation(template.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templates == null) {
            return;
        }
        for (ITemplateListItem template : this.templates) {
            template.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.templates != null) {
            for (ITemplateListItem t : this.templates) {
                if (t.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<ITemplateListItem> iterator() {
        return this.templates.iterator();
    }
}

