/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Referenced_Template
extends TTCN3Template {
    public static final String CIRCULARTEMPLATEREFERENCE = "circular template reference chain: `{0}''";
    private static final String TYPEMISSMATCH1 = "Type mismatch: a signature template of type `{0}'' was expected instead of `{1}''";
    private static final String TYPEMISSMATCH2 = "Type mismatch: a value or template of type `{0}'' was expected instead of `{1}''";
    private static final String INADEQUATETEMPLATERESTRICTION = "Inadequate restriction on the referenced {0} `{1}'', this may cause a dynamic test case error at runtime";
    private final Reference reference;

    public Referenced_Template(Reference reference) {
        this.reference = reference;
        if (reference != null) {
            reference.setFullNameParent(this);
        }
    }

    public Referenced_Template(CompilationTimeStamp timestamp, SpecificValue_Template original) {
        this.copyGeneralProperties(original);
        IValue value = original.getSpecificValue();
        switch (value.getValuetype()) {
            case REFERENCED_VALUE: {
                this.reference = ((Referenced_Value)value).getReference();
                break;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                Identifier identifier = ((Undefined_LowerIdentifier_Value)value).getIdentifier();
                FieldSubReference subReference = new FieldSubReference(identifier);
                subReference.setLocation(value.getLocation());
                this.reference = new Reference(null);
                this.reference.addSubReference(subReference);
                this.reference.setLocation(value.getLocation());
                this.reference.setFullNameParent(this);
                this.reference.setMyScope(value.getMyScope());
                break;
            }
            default: {
                this.reference = null;
            }
        }
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.TEMPLATE_REFD;
    }

    @Override
    public String createStringRepresentation() {
        TTCN3Template last = this.getTemplateReferencedLast(CompilationTimeStamp.getBaseTimestamp());
        if (ITTCN3Template.Template_type.TEMPLATE_REFD.equals((Object)last.getTemplatetype())) {
            return this.reference.getDisplayName();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(last.createStringRepresentation());
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public Location getLocation() {
        return new Location(this.reference.getLocation());
    }

    @Override
    public void setLocation(Location location) {
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous referenced template";
        }
        return "reference template";
    }

    public Reference getReference() {
        return this.reference;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.reference != null) {
            this.reference.setMyScope(scope);
        }
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        Assignment assignment = this.reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return null;
        }
        IType type = assignment.getType(timestamp).getFieldType(timestamp, this.reference, 1, expectedValue, false);
        if (type == null) {
            this.setIsErroneous(true);
        }
        return type;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        IType type = this.getExpressionGovernor(timestamp, expectedValue);
        if (type == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return type.getTypeRefdLast(timestamp).getTypetypeTtcn3();
    }

    private ITTCN3Template getTemplateReferenced(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.reference == null) {
            this.setIsErroneous(true);
            return null;
        }
        Assignment ass = this.reference.getRefdAssignment(timestamp, true);
        if (ass == null || !Assignment.Assignment_type.A_TEMPLATE.equals(ass.getAssignmentType())) {
            this.setIsErroneous(true);
            return this;
        }
        List<ISubReference> subreferences = this.reference.getSubreferences();
        ITTCN3Template template = ((Def_Template)ass).getTemplate(timestamp);
        if ((template = template.getReferencedSubTemplate(timestamp, this.reference, referenceChain)) != null) {
            return template;
        }
        if (subreferences == null || !this.reference.hasUnfoldableIndexSubReference(timestamp)) {
            if (this.reference.getUsedInIsbound()) {
                return this;
            }
            this.setIsErroneous(true);
        }
        return this;
    }

    @Override
    public TTCN3Template getTemplateReferencedLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.reference == null) {
            this.setIsErroneous(true);
            return this;
        }
        boolean newChain = null == referenceChain;
        IReferenceChain tempReferenceChain = newChain ? ReferenceChain.getInstance(CIRCULARTEMPLATEREFERENCE, true) : referenceChain;
        TTCN3Template template = this;
        Assignment ass = this.reference.getRefdAssignment(timestamp, true);
        if (ass != null) {
            switch (ass.getAssignmentType()) {
                case A_TEMPLATE: 
                case A_VAR_TEMPLATE: 
                case A_FUNCTION_RTEMP: 
                case A_MODULEPAR_TEMPLATE: 
                case A_PAR_TEMP_IN: 
                case A_PAR_TEMP_OUT: 
                case A_PAR_TEMP_INOUT: {
                    tempReferenceChain.markState();
                    if (tempReferenceChain.add(this)) {
                        ITTCN3Template refd = this.getTemplateReferenced(timestamp, tempReferenceChain);
                        if (refd != this) {
                            template = refd.getTemplateReferencedLast(timestamp, referenceChain);
                        }
                    } else {
                        this.setIsErroneous(true);
                    }
                    tempReferenceChain.previousState();
                    break;
                }
                default: {
                    this.setIsErroneous(true);
                    break;
                }
            }
        } else {
            this.setIsErroneous(true);
        }
        if (newChain) {
            tempReferenceChain.release();
        }
        return template;
    }

    private boolean hasTemplateImpliciteOmit(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        Assignment ass;
        boolean newChain = null == referenceChain;
        IReferenceChain tempReferenceChain = newChain ? ReferenceChain.getInstance(CIRCULARTEMPLATEREFERENCE, true) : referenceChain;
        boolean result = false;
        if (this.reference != null && (ass = this.reference.getRefdAssignment(timestamp, true)) != null && ass.getAssignmentType() == Assignment.Assignment_type.A_TEMPLATE) {
            Def_Template templateDefinition = (Def_Template)ass;
            if (templateDefinition.hasImplicitOmitAttribute(timestamp)) {
                result = true;
            } else {
                tempReferenceChain.markState();
                if (tempReferenceChain.add(this)) {
                    ITTCN3Template refd = this.getTemplateReferenced(timestamp, tempReferenceChain);
                    if (refd != this && refd instanceof Referenced_Template) {
                        result = ((Referenced_Template)refd).hasTemplateImpliciteOmit(timestamp, referenceChain);
                    }
                } else {
                    this.setIsErroneous(true);
                }
                tempReferenceChain.previousState();
            }
        }
        if (newChain) {
            tempReferenceChain.release();
        }
        return result;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        TTCN3Template temp = this.getTemplateReferencedLast(timestamp);
        if (temp != this && !temp.getIsErroneous(timestamp)) {
            temp.checkSpecificValue(timestamp, allowOmit);
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.reference != null) {
            ActualParameterList parameterList;
            ISubReference subReference = this.reference.getSubreferences().get(0);
            if (subReference instanceof ParameterisedSubReference && (parameterList = ((ParameterisedSubReference)subReference).getActualParameters()) != null) {
                parameterList.checkRecursions(timestamp, referenceChain);
            }
            ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            ITTCN3Template template = this.getTemplateReferenced(timestamp, tempReferenceChain);
            tempReferenceChain.release();
            if (template != null && !template.getIsErroneous(timestamp) && !this.equals(template)) {
                template.checkRecursions(timestamp, referenceChain);
            }
        }
    }

    @Override
    public void checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit) {
        TTCN3Template temp;
        if (this.getIsErroneous(timestamp) || this.reference == null) {
            return;
        }
        Assignment assignment = this.reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return;
        }
        assignment.check(timestamp);
        IType governor = assignment.getType(timestamp);
        if (governor != null) {
            governor = governor.getFieldType(timestamp, this.reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
        }
        if (governor == null) {
            this.setIsErroneous(true);
            return;
        }
        TypeCompatibilityInfo info = new TypeCompatibilityInfo(type, governor, true);
        if (!type.isCompatible(timestamp, governor, info, null, null)) {
            IType last = type.getTypeRefdLast(timestamp);
            switch (last.getTypetype()) {
                case TYPE_PORT: {
                    break;
                }
                case TYPE_SIGNATURE: {
                    this.getLocation().reportSemanticError(MessageFormat.format(TYPEMISSMATCH1, type.getTypename(), governor.getTypename()));
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.getLocation().reportSemanticError(MessageFormat.format(TYPEMISSMATCH2, type.getTypename(), governor.getTypename()));
                    this.setIsErroneous(true);
                }
            }
        }
        if ((temp = this.getTemplateReferencedLast(timestamp)) != this) {
            ReferenceChain referenceChain = ReferenceChain.getInstance(CIRCULARTEMPLATEREFERENCE, true);
            boolean referencedHasImplicitOmit = this.hasTemplateImpliciteOmit(timestamp, referenceChain);
            referenceChain.release();
        }
    }

    @Override
    protected void checkTemplateSpecificLengthRestriction(CompilationTimeStamp timestamp, IType.Type_type typeType) {
        TTCN3Template last = this.getTemplateReferencedLast(timestamp);
        last.checkTemplateSpecificLengthRestriction(timestamp, typeType);
    }

    @Override
    public boolean checkValueomitRestriction(CompilationTimeStamp timestamp, String definitionName, boolean omitAllowed, Location usageLocation) {
        if (this.reference == null) {
            if (omitAllowed) {
                this.checkRestrictionCommon(timestamp, this.getTemplateTypeName(), TemplateRestriction.Restriction_type.TR_OMIT, usageLocation);
            } else {
                this.checkRestrictionCommon(timestamp, this.getTemplateTypeName(), TemplateRestriction.Restriction_type.TR_VALUE, usageLocation);
            }
        } else {
            Assignment ass = this.reference.getRefdAssignment(timestamp, true);
            switch (ass.getAssignmentType()) {
                case A_TEMPLATE: {
                    TTCN3Template templateLast = this.getTemplateReferencedLast(timestamp);
                    if (!this.equals(templateLast)) {
                        templateLast.checkValueomitRestriction(timestamp, this.getTemplateTypeName(), omitAllowed, usageLocation);
                    }
                }
                case A_VAR_TEMPLATE: 
                case A_FUNCTION_RTEMP: 
                case A_PAR_TEMP_IN: 
                case A_PAR_TEMP_OUT: 
                case A_PAR_TEMP_INOUT: 
                case A_EXT_FUNCTION_RTEMP: {
                    if (ass instanceof Definition) {
                        TemplateRestriction.Restriction_type refdTemplateRestriction = ((Definition)ass).getTemplateRestriction();
                        if (TemplateRestriction.isLessRestrictive(omitAllowed ? TemplateRestriction.Restriction_type.TR_OMIT : TemplateRestriction.Restriction_type.TR_VALUE, refdTemplateRestriction = TemplateRestriction.getSubRestriction(refdTemplateRestriction, timestamp, this.reference))) {
                            this.getLocation().reportSemanticWarning(MessageFormat.format(INADEQUATETEMPLATERESTRICTION, ass.getAssignmentName(), this.reference.getDisplayName()));
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean checkPresentRestriction(CompilationTimeStamp timestamp, String definitionName, Location usageLocation) {
        this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_PRESENT, usageLocation);
        if (this.reference != null) {
            Assignment ass = this.reference.getRefdAssignment(timestamp, true);
            switch (ass.getAssignmentType()) {
                case A_TEMPLATE: {
                    TTCN3Template templateLast = this.getTemplateReferencedLast(timestamp);
                    return templateLast.checkPresentRestriction(timestamp, definitionName, usageLocation);
                }
                case A_VAR_TEMPLATE: 
                case A_FUNCTION_RTEMP: 
                case A_PAR_TEMP_IN: 
                case A_PAR_TEMP_OUT: 
                case A_PAR_TEMP_INOUT: 
                case A_EXT_FUNCTION_RTEMP: {
                    if (ass instanceof Definition) {
                        TemplateRestriction.Restriction_type refdTemplateRestriction = ((Definition)ass).getTemplateRestriction();
                        if (TemplateRestriction.isLessRestrictive(TemplateRestriction.Restriction_type.TR_PRESENT, refdTemplateRestriction = TemplateRestriction.getSubRestriction(refdTemplateRestriction, timestamp, this.reference))) {
                            this.getLocation().reportSemanticError(MessageFormat.format(INADEQUATETEMPLATERESTRICTION, ass.getAssignmentName(), this.reference.getDisplayName()));
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.updateSyntax(reparser, false);
            reparser.updateLocation(this.lengthRestriction.getLocation());
        }
        if (this.baseTemplate instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.baseTemplate)).updateSyntax(reparser, false);
            reparser.updateLocation(this.baseTemplate.getLocation());
        } else if (this.baseTemplate != null) {
            throw new ReParseException();
        }
        if (this.reference != null) {
            this.reference.updateSyntax(reparser, false);
            reparser.updateLocation(this.reference.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.reference == null) {
            return;
        }
        this.reference.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.reference == null || this.reference.accept(v);
    }
}

