/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.Type_Assignment;
import org.eclipse.titan.designer.AST.ASN1.Undefined_Assignment;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Referenced_Type
extends ASN1Type
implements IReferencingType {
    private final Reference reference;
    private IType refd;
    private IType refdLast;
    private boolean componentInternal;

    public Referenced_Type(Reference reference) {
        this.reference = reference;
        this.componentInternal = false;
        if (reference != null) {
            reference.setFullNameParent(this);
            this.setLocation(reference.getLocation());
            this.setMyScope(reference.getMyScope());
        }
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_REFERENCED;
    }

    public Reference getReference() {
        return this.reference;
    }

    @Override
    public Location getLocation() {
        if (this.reference != null && this.reference.getLocation() != null) {
            return new Location(this.reference.getLocation());
        }
        return NULL_Location.INSTANCE;
    }

    @Override
    public void setLocation(Location location) {
    }

    @Override
    public IASN1Type newInstance() {
        return new Referenced_Type(this.reference);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.reference != null) {
            this.reference.setMyScope(scope);
        }
    }

    @Override
    public String chainedDescription() {
        return "type reference: " + this.reference;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType t1 = this.getTypeRefdLast(timestamp);
        IType t2 = otherType.getTypeRefdLast(timestamp);
        if (t1.getIsErroneous(timestamp) || t2.getIsErroneous(timestamp)) {
            return true;
        }
        return t1.isCompatible(timestamp, t2, info, null, null);
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType t1 = this.getTypeRefdLast(timestamp);
        IType t2 = type.getTypeRefdLast(timestamp);
        if (t1.getIsErroneous(timestamp) || t2.getIsErroneous(timestamp)) {
            return true;
        }
        return t1.isIdentical(timestamp, t2);
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        if (this.isErroneous || this.refdLast == null || this.refdLast == this) {
            return "Referenced type";
        }
        return this.refdLast.getTypename();
    }

    @Override
    public String getOutlineIcon() {
        return "referenced.gif";
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        if (this.lastTimeChecked == null) {
            this.check(timestamp);
        }
        if (reference.getSubreferences().size() == 1) {
            return this;
        }
        if (this.refdLast != null && this != this.refdLast && !this.getIsErroneous(timestamp)) {
            Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
            IType temp = this.refdLast.getFieldType(timestamp, reference, actualSubReference, internalExpectation, refChain, interruptIfOptional);
            if (reference.getIsErroneous(timestamp)) {
                this.setIsErroneous(true);
            }
            return temp;
        }
        return this;
    }

    @Override
    public boolean getSubrefsAsArray(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, List<Integer> subrefsArray, List<IType> typeArray) {
        if (reference.getSubreferences().size() == 1) {
            return true;
        }
        if (this == this.refdLast) {
            return false;
        }
        return this.refdLast.getSubrefsAsArray(timestamp, reference, actualSubReference, subrefsArray, typeArray);
    }

    @Override
    public boolean getFieldTypesAsArray(Reference reference, int actualSubReference, List<IType> typeArray) {
        if (reference.getSubreferences().size() == 1) {
            return true;
        }
        if (this == this.refdLast || this.refdLast == null) {
            return false;
        }
        return this.refdLast.getFieldTypesAsArray(reference, actualSubReference, typeArray);
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        Assignment ass = this.lastTimeChecked == null ? this.reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), true) : this.reference.getRefdAssignment(this.lastTimeChecked, true);
        if (ass != null && Assignment.Assignment_type.A_TYPE.equals(ass.getAssignmentType())) {
            if (ass instanceof Def_Type) {
                Def_Type defType = (Def_Type)ass;
                return builder.append(defType.getIdentifier().getDisplayName());
            }
            if (ass instanceof Type_Assignment) {
                return builder.append(((Type_Assignment)ass).getIdentifier().getDisplayName());
            }
        }
        return builder.append("unknown_referred_type");
    }

    @Override
    public boolean isComponentInternal(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.componentInternal;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.componentInternal = false;
        this.isErroneous = false;
        this.refd = null;
        this.parseAttributes(timestamp);
        this.refdLast = this.getTypeRefdLast(timestamp);
        if (this.refdLast != null && !this.refdLast.getIsErroneous(timestamp)) {
            this.refdLast.check(timestamp);
            this.componentInternal = this.refdLast.isComponentInternal(timestamp);
        }
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
        IType typeLast = this.getTypeRefdLast(timestamp);
        ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IType typeParent = this.getTypeRefd(timestamp, tempReferenceChain);
        tempReferenceChain.release();
        if (!typeLast.getIsErroneous(timestamp) && !typeParent.getIsErroneous(timestamp)) {
            this.checkSubtypeRestrictions(timestamp, typeLast.getSubtypeType(), typeParent.getSubtype());
        }
    }

    @Override
    public void checkComponentInternal(CompilationTimeStamp timestamp, Set<IType> typeSet, String operation) {
        IType last = this.getTypeRefdLast(timestamp);
        if (last != null && !last.getIsErroneous(timestamp) && last != this) {
            last.checkComponentInternal(timestamp, typeSet, operation);
        }
    }

    @Override
    public void checkEmbedded(CompilationTimeStamp timestamp, Location errorLocation, boolean defaultAllowed, String errorMessage) {
        IType last = this.getTypeRefdLast(timestamp);
        if (last != null && !last.getIsErroneous(timestamp) && last != this) {
            last.checkEmbedded(timestamp, errorLocation, defaultAllowed, errorMessage);
        }
    }

    @Override
    public IValue checkThisValueRef(CompilationTimeStamp timestamp, IValue value) {
        if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)value.getValuetype())) {
            ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IType refd = this.getTypeRefd(timestamp, tempReferenceChain);
            tempReferenceChain.release();
            if (refd == null || this.equals(refd)) {
                return value;
            }
            return refd.checkThisValueRef(timestamp, value);
        }
        return value;
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        IType tempType = this.getTypeRefdLast(timestamp);
        if (tempType != this) {
            String referingModuleName;
            tempType.checkThisValue(timestamp, value, new IType.ValueCheckingOptions(valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.omit_allowed, false, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem));
            Definition def = value.getDefiningAssignment();
            if (def != null && !def.referingHere.contains(referingModuleName = this.getMyScope().getModuleScope().getName())) {
                def.referingHere.add(referingModuleName);
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, value);
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        this.registerUsage(template);
        IType tempType = this.getTypeRefdLast(timestamp);
        if (tempType != this) {
            tempType.checkThisTemplate(timestamp, template, isModified, implicitOmit);
        }
    }

    @Override
    public IType getTypeRefd(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (refChain.add(this) && this.reference != null && !this.getIsErroneous(timestamp)) {
            if (this.refd != null) {
                return this.refd;
            }
            Assignment ass = this.reference.getRefdAssignment(timestamp, true, refChain);
            if (ass != null && Assignment.Assignment_type.A_UNDEF.equals(ass.getAssignmentType())) {
                ass = ((Undefined_Assignment)ass).getRealAssignment(timestamp);
            }
            if (ass == null || ass.getIsErroneous()) {
                this.isErroneous = true;
                this.lastTimeChecked = timestamp;
                return this;
            }
            switch (ass.getAssignmentType()) {
                case A_TYPE: {
                    IType tempType = ass.getType(timestamp);
                    if (tempType == null || tempType.getIsErroneous(timestamp)) break;
                    tempType.check(timestamp);
                    tempType = tempType.getFieldType(timestamp, this.reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, refChain, false);
                    if (tempType == null) {
                        this.setIsErroneous(true);
                        return this;
                    }
                    this.refd = tempType;
                    return this.refd;
                }
                case A_VS: {
                    IType tempType = ass.getType(timestamp);
                    if (tempType == null) {
                        this.isErroneous = true;
                        this.lastTimeChecked = timestamp;
                        return this;
                    }
                    this.refd = tempType;
                    return this.refd;
                }
                case A_OC: 
                case A_OBJECT: 
                case A_OS: {
                    ISetting setting = this.reference.getRefdSetting(timestamp);
                    if (setting == null || setting.getIsErroneous(timestamp)) {
                        this.isErroneous = true;
                        this.lastTimeChecked = timestamp;
                        return this;
                    }
                    if (!ISetting.Setting_type.S_T.equals((Object)setting.getSettingtype())) {
                        this.reference.getLocation().reportSemanticError(MessageFormat.format("`{0}'' is not a reference to a type", this.reference.getDisplayName()));
                        this.isErroneous = true;
                        this.lastTimeChecked = timestamp;
                        return this;
                    }
                    this.refd = (Type)setting;
                    return this.refd;
                }
                default: {
                    this.reference.getLocation().reportSemanticError(MessageFormat.format("`{0}'' is not a reference to a type", this.reference.getDisplayName()));
                }
            }
        }
        this.isErroneous = true;
        this.lastTimeChecked = timestamp;
        return this;
    }

    @Override
    public IType getTypeRefdLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        boolean newChain = null == referenceChain;
        IReferenceChain tempReferenceChain = newChain ? ReferenceChain.getInstance("Circular reference chain: `{0}''", true) : referenceChain;
        IType t = this;
        while (t != null && t instanceof IReferencingType && !t.getIsErroneous(timestamp)) {
            t = ((IReferencingType)((Object)t)).getTypeRefd(timestamp, tempReferenceChain);
        }
        if (newChain) {
            tempReferenceChain.release();
        }
        if (t != null && t.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
        }
        return t;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IType t = this.getTypeRefd(timestamp, tempReferenceChain);
            tempReferenceChain.release();
            if (t != null && !t.getIsErroneous(timestamp) && !this.equals(t)) {
                t.checkRecursions(timestamp, referenceChain);
            }
        }
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (this.refdLast != null && !this.equals(this.refdLast)) {
            this.refdLast.addProposal(propCollector, i);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (this.refdLast != null && !this.equals(this.refdLast)) {
            this.refdLast.addDeclaration(declarationCollector, i);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        this.reference.updateSyntax(reparser, false);
        reparser.updateLocation(this.reference.getLocation());
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.reference != null) {
            this.reference.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.reference == null || this.reference.accept(v);
    }
}

