/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceableElement;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.IndexedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Indexed_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.PermutationMatch_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SubsetMatch_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SupersetMatch_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.AbstractOfType;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeFactory;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class SequenceOf_Type
extends AbstractOfType
implements IReferenceableElement {
    public static final String SEQOFVALUEEXPECTED = "SEQUENCE OF value was expected";
    public static final String RECORDOFVALUEEXPECTED = "record of value was expected";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for recordof type `{1}''";
    private static final String REDUNDANTLENGTHRESTRICTION = "Redundant usage of length restriction with `omit''";
    public static final String NOTUSEDNOTALLOWED1 = "Not used symbol `-' is not allowed in this context";
    public static final String NOTUSEDNOTALLOWED2 = "Not used symbol `-' cannot be used here because there is no corresponding element in the base template";
    public static final String TOOBIGINDEXTEMPLATE = "An integer value less than `{0}'' was expected for indexing type `{1}'' instead of `{2}''";
    public static final String NONNEGATIVEINDEXEXPECTEDTEMPLATE = "A non-negative integer value was expected for indexing type `{0}'' instead of `{1}''";
    public static final String DUPLICATEINDEX = "Duplicate index value `{0}'' for component `{1}'' and `{2}''";
    public static final String NONNEGATIVINDEXEXPECTED = "A non-negative integer value was expected as index instead of `{0}''";
    public static final String TOOBIGINDEX = "Integer value `{0}'' is too big for indexing type `{1}''";
    public static final String INTEGERINDEXEXPECTED = "The index should be an integer value";
    private static final String NOTCOMPATIBLESETSETOF = "set/SET and set of/SET OF types are compatible only with other set/SET and set of/SET OF types";
    private static final String NOTCOMPATIBLEUNIONANYTYPE = "union/CHOICE/anytype types are compatible only with other union/CHOICE/anytype types";

    public SequenceOf_Type(IType ofType) {
        super(ofType);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_SEQUENCE_OF;
    }

    @Override
    public IASN1Type newInstance() {
        if (this.getOfType() instanceof ASN1Type) {
            return new SequenceOf_Type(((IASN1Type)this.getOfType()).newInstance());
        }
        return this;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType lastOtherType = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || lastOtherType.getIsErroneous(timestamp) || this == lastOtherType) {
            return true;
        }
        if (info == null || noStructuredTypeCompatibility) {
            IType last = this.getTypeRefdLast(timestamp);
            return last.isStronglyCompatible(timestamp, lastOtherType, info, leftChain, rightChain);
        }
        switch (lastOtherType.getTypetype()) {
            case TYPE_ASN1_SEQUENCE: {
                if (!this.isSubtypeCompatible(timestamp, lastOtherType)) {
                    info.setErrorStr("Incompatible record of/SEQUENCE OF subtypes");
                    return false;
                }
                ASN1_Sequence_Type tempType = (ASN1_Sequence_Type)lastOtherType;
                int tempTypeNofComps = tempType.getNofComponents(timestamp);
                if (tempTypeNofComps == 0) {
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < tempTypeNofComps; ++i) {
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    IType ofType = this.getOfType().getTypeRefdLast(timestamp);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(ofType, tempTypeCfType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(ofType);
                    rChain.add(tempTypeCfType);
                    if (!(ofType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || ofType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        if (infoTemp.getOp1RefStr().length() > 0) {
                            info.appendOp1Ref("[]");
                        }
                        info.appendOp1Ref(infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCf.getIdentifier().getDisplayName() + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_TTCN3_SEQUENCE: {
                if (!this.isSubtypeCompatible(timestamp, lastOtherType)) {
                    info.setErrorStr("Incompatible record of/SEQUENCE OF subtypes");
                    return false;
                }
                TTCN3_Sequence_Type tempType = (TTCN3_Sequence_Type)lastOtherType;
                int tempTypeNofComps = tempType.getNofComponents();
                if (tempTypeNofComps == 0) {
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < tempTypeNofComps; ++i) {
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    IType ofType = this.getOfType().getTypeRefdLast(timestamp);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(ofType, tempTypeCfType, false);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(ofType);
                    rChain.add(tempTypeCfType);
                    if (!(ofType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || ofType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        if (infoTemp.getOp1RefStr().length() > 0) {
                            info.appendOp1Ref("[]");
                        }
                        info.appendOp1Ref(infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCf.getIdentifier().getDisplayName() + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_SEQUENCE_OF: {
                if (!this.isSubtypeCompatible(timestamp, lastOtherType)) {
                    info.setErrorStr("Incompatible record of/SEQUENCE OF subtypes");
                    return false;
                }
                SequenceOf_Type tempType = (SequenceOf_Type)lastOtherType;
                if (this == tempType) {
                    return true;
                }
                IType tempTypeOfType = tempType.getOfType().getTypeRefdLast(timestamp);
                IType ofType = this.getOfType().getTypeRefdLast(timestamp);
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                lChain.markState();
                rChain.markState();
                lChain.add(ofType);
                rChain.add(tempTypeOfType);
                TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(ofType, tempTypeOfType, false);
                if (!(ofType.equals(tempTypeOfType) || lChain.hasRecursion() && rChain.hasRecursion() || ofType.isCompatible(timestamp, tempTypeOfType, infoTemp, lChain, rChain))) {
                    if (info.getOp1RefStr().length() > 0) {
                        info.appendOp1Ref("[]");
                    }
                    if (info.getOp2RefStr().length() > 0) {
                        info.appendOp2Ref("[]");
                    }
                    info.appendOp1Ref(infoTemp.getOp1RefStr());
                    info.appendOp2Ref(infoTemp.getOp2RefStr());
                    info.setOp1Type(infoTemp.getOp1Type());
                    info.setOp2Type(infoTemp.getOp2Type());
                    info.setErrorStr(infoTemp.getErrorStr());
                    lChain.previousState();
                    rChain.previousState();
                    return false;
                }
                info.setNeedsConversion(true);
                lChain.previousState();
                rChain.previousState();
                return true;
            }
            case TYPE_ARRAY: {
                if (!this.isSubtypeCompatible(timestamp, lastOtherType)) {
                    info.setErrorStr("Incompatible record of/SEQUENCE OF subtypes");
                    return false;
                }
                Array_Type tempType = (Array_Type)lastOtherType;
                IType tempTypeElementType = tempType.getElementType().getTypeRefdLast(timestamp);
                IType ofType = this.getOfType().getTypeRefdLast(timestamp);
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                lChain.markState();
                rChain.markState();
                lChain.add(ofType);
                rChain.add(tempTypeElementType);
                TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(ofType, tempTypeElementType, false);
                if (!(ofType.equals(tempTypeElementType) || lChain.hasRecursion() && rChain.hasRecursion() || ofType.isCompatible(timestamp, tempTypeElementType, infoTemp, lChain, rChain))) {
                    if (infoTemp.getOp1RefStr().length() > 0) {
                        info.appendOp1Ref("[]");
                    }
                    info.appendOp1Ref(infoTemp.getOp1RefStr());
                    info.appendOp2Ref(infoTemp.getOp2RefStr());
                    info.setOp1Type(infoTemp.getOp1Type());
                    info.setOp2Type(infoTemp.getOp2Type());
                    info.setErrorStr(infoTemp.getErrorStr());
                    lChain.previousState();
                    rChain.previousState();
                    return false;
                }
                info.setNeedsConversion(true);
                lChain.previousState();
                rChain.previousState();
                return true;
            }
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_CHOICE: 
            case TYPE_ANYTYPE: {
                info.setErrorStr(NOTCOMPATIBLEUNIONANYTYPE);
                return false;
            }
            case TYPE_ASN1_SET: 
            case TYPE_TTCN3_SET: 
            case TYPE_SET_OF: {
                info.setErrorStr(NOTCOMPATIBLESETSETOF);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isStronglyCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        IType lastOtherType = otherType.getTypeRefdLast(timestamp);
        if (IType.Type_type.TYPE_SEQUENCE_OF.equals((Object)lastOtherType.getTypetype())) {
            IType oftOther = ((SequenceOf_Type)lastOtherType).getOfType();
            IType oft = this.getOfType().getTypeRefdLast(timestamp);
            if (oft != null && oftOther != null) {
                switch (oft.getTypetype()) {
                    case TYPE_BOOL: 
                    case TYPE_BITSTRING: 
                    case TYPE_OCTETSTRING: 
                    case TYPE_INTEGER: 
                    case TYPE_REAL: 
                    case TYPE_CHARSTRING: 
                    case TYPE_HEXSTRING: 
                    case TYPE_UCHARSTRING: 
                    case TYPE_INTEGER_A: 
                    case TYPE_ASN1_ENUMERATED: 
                    case TYPE_BITSTRING_A: 
                    case TYPE_UTF8STRING: 
                    case TYPE_NUMERICSTRING: 
                    case TYPE_PRINTABLESTRING: 
                    case TYPE_TELETEXSTRING: 
                    case TYPE_VIDEOTEXSTRING: 
                    case TYPE_IA5STRING: 
                    case TYPE_GRAPHICSTRING: 
                    case TYPE_VISIBLESTRING: 
                    case TYPE_GENERALSTRING: 
                    case TYPE_UNIVERSALSTRING: 
                    case TYPE_BMPSTRING: 
                    case TYPE_UNRESTRICTEDSTRING: 
                    case TYPE_UTCTIME: 
                    case TYPE_GENERALIZEDTIME: 
                    case TYPE_OBJECTDESCRIPTOR: {
                        if (!oft.isStronglyCompatible(timestamp, oftOther, info, leftChain, rightChain)) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public String getOutlineIcon() {
        return "record_of.gif";
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_RECORDOF;
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        if (IValue.Value_type.UNDEFINED_BLOCK.equals((Object)last.getValuetype())) {
            last = last.setValuetype(timestamp, IValue.Value_type.SEQUENCEOF_VALUE);
        }
        if (last.getIsErroneous(timestamp)) {
            return;
        }
        switch (last.getValuetype()) {
            case SEQUENCEOF_VALUE: {
                this.checkThisValueSequenceOf(timestamp, (SequenceOf_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case SETOF_VALUE: {
                this.checkThisValueSetOf(timestamp, (SetOf_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                if (value.isAsn()) {
                    value.getLocation().reportSemanticError(SEQOFVALUEEXPECTED);
                } else {
                    value.getLocation().reportSemanticError(RECORDOFVALUEEXPECTED);
                }
                value.setIsErroneous(true);
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
    }

    public void checkThisValueSequenceOf(CompilationTimeStamp timestamp, SequenceOf_Value value, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean implicitOmit, boolean strElem) {
        if (value.isIndexed()) {
            boolean checkHoles = Expected_Value_type.EXPECTED_CONSTANT.equals((Object)expectedValue);
            BigInteger maxIndex = BigInteger.valueOf(-1L);
            HashMap<BigInteger, Integer> indexMap = new HashMap<BigInteger, Integer>(value.getNofComponents());
            int size = value.getNofComponents();
            for (int i = 0; i < size; ++i) {
                IValue component = value.getValueByIndex(i);
                IValue index = value.getIndexByIndex(i);
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                IValue indexLast = index.getValueRefdLast(timestamp, referenceChain);
                referenceChain.release();
                Type tempType = TypeFactory.createType(IType.Type_type.TYPE_INTEGER);
                tempType.check(timestamp);
                indexLast.setMyGovernor(tempType);
                IValue temporalValue = tempType.checkThisValueRef(timestamp, indexLast);
                tempType.checkThisValue(timestamp, temporalValue, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, true, false, true, false, false));
                if (indexLast.getIsErroneous(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)temporalValue.getValuetype())) {
                    checkHoles = false;
                } else {
                    BigInteger tempIndex = ((Integer_Value)temporalValue).getValueValue();
                    if (tempIndex.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
                        index.getLocation().reportSemanticError(MessageFormat.format("A integer value less than `{0}'' was expected for indexing type `{1}'' instead of `{2}''", Integer.MAX_VALUE, this.getTypename(), tempIndex));
                        checkHoles = false;
                    } else if (tempIndex.compareTo(BigInteger.ZERO) == -1) {
                        index.getLocation().reportSemanticError(MessageFormat.format(NONNEGATIVEINDEXEXPECTEDTEMPLATE, this.getTypename(), tempIndex));
                        checkHoles = false;
                    } else if (indexMap.containsKey(tempIndex)) {
                        index.getLocation().reportSemanticError(MessageFormat.format("Duplicate index value `{0}'' for components {1} and {2}", tempIndex, indexMap.get(tempIndex), i + 1));
                        checkHoles = false;
                    } else {
                        indexMap.put(tempIndex, i + 1);
                        if (maxIndex.compareTo(tempIndex) == -1) {
                            maxIndex = tempIndex;
                        }
                    }
                }
                component.setMyGovernor(this.getOfType());
                IValue tempValue2 = this.getOfType().checkThisValueRef(timestamp, component);
                this.getOfType().checkThisValue(timestamp, tempValue2, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, implicitOmit, strElem));
            }
            if (checkHoles && maxIndex.compareTo(BigInteger.valueOf(indexMap.size() - 1)) != 0) {
                value.getLocation().reportSemanticError("It's not allowed to create hole(s) in constant values");
            }
        } else {
            int size = value.getNofComponents();
            for (int i = 0; i < size; ++i) {
                IValue component = value.getValueByIndex(i);
                component.setMyGovernor(this.getOfType());
                if (IValue.Value_type.NOTUSED_VALUE.equals((Object)component.getValuetype())) {
                    if (incompleteAllowed) continue;
                    component.getLocation().reportSemanticError(NOTUSEDNOTALLOWED1);
                    continue;
                }
                IValue tempValue2 = this.getOfType().checkThisValueRef(timestamp, component);
                this.getOfType().checkThisValue(timestamp, tempValue2, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, implicitOmit, strElem));
            }
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        switch (template.getTemplatetype()) {
            case OMIT_VALUE: {
                if (template.getLengthRestriction() == null) break;
                template.getLocation().reportSemanticWarning(REDUNDANTLENGTHRESTRICTION);
                break;
            }
            case PERMUTATION_MATCH: {
                PermutationMatch_Template permutationTemplate = (PermutationMatch_Template)template;
                int nofComponents = permutationTemplate.getNofTemplates();
                for (int i = 0; i < nofComponents; ++i) {
                    ITTCN3Template templateComponent = permutationTemplate.getTemplateByIndex(i);
                    templateComponent.setMyGovernor(this.getOfType());
                    templateComponent = this.getOfType().checkThisTemplateRef(timestamp, templateComponent);
                    templateComponent.checkThisTemplateGeneric(timestamp, this.getOfType(), false, false, true, true, implicitOmit);
                }
                break;
            }
            case SUPERSET_MATCH: {
                SupersetMatch_Template supersetTemplate = (SupersetMatch_Template)template;
                int nofComponents = supersetTemplate.getNofTemplates();
                for (int i = 0; i < nofComponents; ++i) {
                    ITTCN3Template templateComponent = supersetTemplate.getTemplateByIndex(i);
                    templateComponent.setMyGovernor(this.getOfType());
                    templateComponent = this.getOfType().checkThisTemplateRef(timestamp, templateComponent);
                    templateComponent.checkThisTemplateGeneric(timestamp, this.getOfType(), false, false, true, true, implicitOmit);
                }
                break;
            }
            case SUBSET_MATCH: {
                SubsetMatch_Template subsetTemplate = (SubsetMatch_Template)template;
                int nofComponents = subsetTemplate.getNofTemplates();
                for (int i = 0; i < nofComponents; ++i) {
                    ITTCN3Template templateComponent = subsetTemplate.getTemplateByIndex(i);
                    templateComponent.setMyGovernor(this.getOfType());
                    templateComponent = this.getOfType().checkThisTemplateRef(timestamp, templateComponent);
                    templateComponent.checkThisTemplateGeneric(timestamp, this.getOfType(), false, false, true, true, implicitOmit);
                }
                break;
            }
            case TEMPLATE_LIST: {
                ITTCN3Template.Completeness_type completeness = template.getCompletenessConditionSeof(timestamp, isModified);
                Template_List base = null;
                int nofBaseComps = 0;
                if (ITTCN3Template.Completeness_type.PARTIAL.equals((Object)completeness)) {
                    ITTCN3Template tempBase = template.getBaseTemplate();
                    if (tempBase != null) {
                        tempBase = tempBase.getTemplateReferencedLast(timestamp);
                    }
                    if (tempBase == null) {
                        this.setIsErroneous(true);
                        return;
                    }
                    base = (Template_List)tempBase;
                    nofBaseComps = base.getNofTemplates();
                }
                Template_List templateList = (Template_List)template;
                int nofComponents = templateList.getNofTemplates();
                block15: for (int i = 0; i < nofComponents; ++i) {
                    ITTCN3Template component = templateList.getTemplateByIndex(i);
                    component.setMyGovernor(this.getOfType());
                    if (base != null && nofBaseComps > i) {
                        component.setBaseTemplate(base.getTemplateByIndex(i));
                    } else {
                        component.setBaseTemplate(null);
                    }
                    component = this.getOfType().checkThisTemplateRef(timestamp, component);
                    switch (component.getTemplatetype()) {
                        case PERMUTATION_MATCH: 
                        case SUPERSET_MATCH: 
                        case SUBSET_MATCH: {
                            component.checkThisTemplateGeneric(timestamp, this, false, false, true, true, implicitOmit);
                            continue block15;
                        }
                        case TEMPLATE_NOTUSED: {
                            if (ITTCN3Template.Completeness_type.MUST_COMPLETE.equals((Object)completeness)) {
                                component.getLocation().reportSemanticError(NOTUSEDNOTALLOWED1);
                                continue block15;
                            }
                            if (!ITTCN3Template.Completeness_type.PARTIAL.equals((Object)completeness) || i < nofBaseComps) continue block15;
                            component.getLocation().reportSemanticError(NOTUSEDNOTALLOWED2);
                            continue block15;
                        }
                        default: {
                            boolean embeddedModified = completeness == ITTCN3Template.Completeness_type.MAY_INCOMPLETE || completeness == ITTCN3Template.Completeness_type.PARTIAL && i < nofBaseComps;
                            component.checkThisTemplateGeneric(timestamp, this.getOfType(), embeddedModified, false, true, true, implicitOmit);
                        }
                    }
                }
                break;
            }
            case INDEXED_TEMPLATE_LIST: {
                HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>();
                Indexed_Template_List indexedTemplateList = (Indexed_Template_List)template;
                int size = indexedTemplateList.getNofTemplates();
                for (int i = 0; i < size; ++i) {
                    IndexedTemplate indexedTemplate = indexedTemplateList.getIndexedTemplateByIndex(i);
                    Value indexValue = indexedTemplate.getIndex().getValue();
                    ITTCN3Template templateComponent = indexedTemplate.getTemplate();
                    ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    IValue lastValue = indexValue.getValueRefdLast(timestamp, chain);
                    chain.release();
                    Type tempType = TypeFactory.createType(IType.Type_type.TYPE_INTEGER);
                    tempType.check(timestamp);
                    lastValue.setMyGovernor(tempType);
                    IValue temporalValue = tempType.checkThisValueRef(timestamp, lastValue);
                    tempType.checkThisValue(timestamp, temporalValue, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, true, false, true, false, false));
                    if (!temporalValue.getIsErroneous(timestamp) && IValue.Value_type.INTEGER_VALUE.equals((Object)temporalValue.getValuetype())) {
                        long index = ((Integer_Value)lastValue).getValue();
                        if (index > Integer.MAX_VALUE) {
                            indexValue.getLocation().reportSemanticError(MessageFormat.format(TOOBIGINDEXTEMPLATE, Integer.MAX_VALUE, this.getTypename(), index));
                            indexValue.setIsErroneous(true);
                        } else if (index < 0L) {
                            indexValue.getLocation().reportSemanticError(MessageFormat.format(NONNEGATIVEINDEXEXPECTEDTEMPLATE, this.getTypename(), index));
                            indexValue.setIsErroneous(true);
                        } else if (indexMap.containsKey(index)) {
                            indexValue.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEINDEX, index, i + 1, indexMap.get(index)));
                            indexValue.setIsErroneous(true);
                        } else {
                            indexMap.put(index, i);
                        }
                    }
                    templateComponent.setMyGovernor(this.getOfType());
                    templateComponent = this.getOfType().checkThisTemplateRef(timestamp, templateComponent);
                    templateComponent.checkThisTemplateGeneric(timestamp, this.getOfType(), true, false, true, true, implicitOmit);
                }
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
            }
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                Value indexValue = ((ArraySubReference)subreference).getValue();
                if (indexValue != null) {
                    indexValue.setLoweridToReference(timestamp);
                    IType.Type_type tempType = indexValue.getExpressionReturntype(timestamp, expectedIndex);
                    switch (tempType) {
                        case TYPE_INTEGER: {
                            IValue last = indexValue.getValueRefdLast(timestamp, expectedIndex, refChain);
                            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype())) break;
                            Integer_Value lastInteger = (Integer_Value)last;
                            if (lastInteger.isNative()) {
                                long temp = lastInteger.getValue();
                                if (temp >= 0L) break;
                                indexValue.getLocation().reportSemanticError(MessageFormat.format(NONNEGATIVINDEXEXPECTED, last));
                                indexValue.setIsErroneous(true);
                                break;
                            }
                            indexValue.getLocation().reportSemanticError(MessageFormat.format(TOOBIGINDEX, indexValue, this.getTypename()));
                            indexValue.setIsErroneous(true);
                            break;
                        }
                        case TYPE_UNDEFINED: {
                            indexValue.setIsErroneous(true);
                            break;
                        }
                        default: {
                            indexValue.getLocation().reportSemanticError(INTEGERINDEXEXPECTED);
                            indexValue.setIsErroneous(true);
                        }
                    }
                }
                if (this.getOfType() != null) {
                    return this.getOfType().getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
                }
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        builder.append("sequence of ");
        if (this.getOfType() != null) {
            this.getOfType().getProposalDescription(builder);
        }
        return builder;
    }

    @Override
    public Declaration resolveReference(Reference reference, int subRefIdx, ISubReference lastSubreference) {
        if (this.getOfType() == null) {
            return null;
        }
        IType refdLastOfType = this.getOfType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (refdLastOfType instanceof IReferenceableElement) {
            return ((IReferenceableElement)((Object)refdLastOfType)).resolveReference(reference, subRefIdx + 1, lastSubreference);
        }
        return null;
    }
}

