/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.Integer_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Integer_Value
extends Value
implements Comparable<Integer_Value> {
    private static final BigInteger MAX_INTEGER = BigInteger.valueOf(Integer.MAX_VALUE);
    private BigInteger value;

    public Integer_Value(long value) {
        this.value = BigInteger.valueOf(value);
    }

    public Integer_Value(String value) {
        this.value = new BigInteger(value);
    }

    public Integer_Value(BigInteger value) {
        this.value = value;
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.INTEGER_VALUE;
    }

    @Override
    public String createStringRepresentation() {
        return this.value.toString();
    }

    @Override
    public Value setValuetype(CompilationTimeStamp timestamp, IValue.Value_type newType) {
        if (IValue.Value_type.REAL_VALUE.equals((Object)newType)) {
            return new Real_Value(this.value.floatValue());
        }
        return super.setValuetype(timestamp, newType);
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' can not be indexed", type.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return false;
    }

    public long getValue() {
        return this.value.longValue();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public BigInteger getValueValue() {
        return this.value;
    }

    public void changeSign() {
        this.value = this.value.negate();
    }

    public boolean isNative() {
        return this.value.compareTo(MAX_INTEGER) <= 0;
    }

    public Integer_Value negate() {
        return new Integer_Value(this.value.negate());
    }

    public int signum() {
        return this.value.signum();
    }

    public Integer_Value and(Integer_Value val) {
        return new Integer_Value(this.value.and(val.getValueValue()));
    }

    public Integer_Value shiftRight(int n) {
        return new Integer_Value(this.value.shiftRight(n));
    }

    public Integer_Value shiftLeft(int n) {
        return new Integer_Value(this.value.shiftLeft(n));
    }

    public Integer_Value abs() {
        return new Integer_Value(this.value.abs());
    }

    public Integer_Value add(Integer_Value val) {
        return new Integer_Value(this.value.add(val.getValueValue()));
    }

    public Integer_Value subtract(Integer_Value val) {
        return new Integer_Value(this.value.subtract(val.getValueValue()));
    }

    public Integer_Value multiply(Integer_Value val) {
        return new Integer_Value(this.value.multiply(val.getValueValue()));
    }

    public Integer_Value divide(Integer_Value val) {
        return new Integer_Value(this.value.divide(val.getValueValue()));
    }

    public Integer_Value remainder(Integer_Value val) {
        return new Integer_Value(this.value.remainder(val.getValueValue()));
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_INTEGER;
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        return new Integer_Type();
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        return IValue.Value_type.INTEGER_VALUE.equals((Object)last.getValuetype()) && this.value.equals(((Integer_Value)last).getValueValue());
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object x) {
        if (this == x) {
            return true;
        }
        if (!(x instanceof Integer_Value)) {
            return false;
        }
        return this.value.equals(((Integer_Value)x).getValueValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(Integer_Value val) {
        return this.value.compareTo(val.getValueValue());
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        return true;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }
}

