/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferencingElement;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ITypeWithComponents;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class NamedValue
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable,
IReferencingElement {
    private final Identifier name;
    private final IValue value;
    private Location location = NULL_Location.INSTANCE;
    private final boolean parsed;

    public NamedValue(Identifier name, IValue value) {
        this.name = name;
        this.value = value;
        this.parsed = true;
        if (value != null && value.getNameParent() == null) {
            value.setFullNameParent(this);
        }
    }

    public NamedValue(Identifier name, IValue value, boolean parsed) {
        this.name = name;
        this.value = value;
        this.parsed = parsed;
        if (value != null && value.getFullName() == null) {
            value.setFullNameParent(this);
        }
    }

    public Identifier getName() {
        return this.name;
    }

    public IValue getValue() {
        return this.value;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        reparser.updateLocation(this.name.getLocation());
        if (this.value instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.value)).updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        } else if (this.value != null) {
            throw new ReParseException();
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.name != null && !this.name.accept(v)) {
            return false;
        }
        return this.value == null || this.value.accept(v);
    }

    @Override
    public Declaration getDeclaration() {
        INamedNode inamedNode = this.getNameParent();
        while (!(inamedNode instanceof IValue)) {
            if (inamedNode == null) {
                return null;
            }
            inamedNode = inamedNode.getNameParent();
        }
        IValue iValue = (IValue)inamedNode;
        IType type = iValue.getMyGovernor();
        if (type == null) {
            return null;
        }
        if ((type = type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp())) instanceof ITypeWithComponents) {
            Identifier id = ((ITypeWithComponents)((Object)type)).getComponentIdentifierByName(this.getName());
            return Declaration.createInstance(type.getDefiningAssignment(), id);
        }
        return null;
    }
}

