/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Referenced_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.Boolean_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class IsBoundExpression
extends Expression_Value {
    private static final String OPERANDERROR = "Cannot determine the argument type of `isbound()' operation";
    private static final String CONSTEXPECTED1 = "Reference to a constant was expected instead of an in-line modified template";
    private static final String CONSTEXPECTED2 = "Reference to a constant value was expected instead of {0}";
    private static final String STATICEXPECTED1 = "Reference to a static was expected instead of an in-line modified template";
    private static final String STATICEXPECTED2 = "Reference to a static value was expected instead of {0}";
    private final TemplateInstance templateInstance;

    public IsBoundExpression(TemplateInstance templateInstance) {
        this.templateInstance = templateInstance;
        if (templateInstance != null) {
            templateInstance.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.ISBOUND_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("isbound(");
        builder.append(this.templateInstance.createStringRepresentation());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.templateInstance != null) {
            this.templateInstance.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.templateInstance == child) {
            return builder.append(".<operand>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_BOOL;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.templateInstance == null) {
            return true;
        }
        ITTCN3Template template = this.templateInstance.getTemplateBody().setLoweridToReference(timestamp);
        if (this.templateInstance.getDerivedReference() != null) {
            return true;
        }
        if (ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)template.getTemplatetype())) {
            IValue specificValue = ((SpecificValue_Template)template).getValue();
            if (IValue.Value_type.REFERENCED_VALUE.equals((Object)specificValue.getValuetype())) {
                Reference reference = ((Referenced_Value)specificValue).getReference();
                Assignment ass = reference.getRefdAssignment(timestamp, false);
                if (ass == null) {
                    return true;
                }
                switch (ass.getAssignmentType()) {
                    case A_OBJECT: 
                    case A_OS: 
                    case A_CONST: 
                    case A_EXT_CONST: 
                    case A_MODULEPAR: 
                    case A_VAR: 
                    case A_FUNCTION_RVAL: 
                    case A_EXT_FUNCTION_RVAL: 
                    case A_PAR_VAL: 
                    case A_PAR_VAL_IN: 
                    case A_PAR_VAL_OUT: 
                    case A_PAR_VAL_INOUT: {
                        break;
                    }
                    default: {
                        return true;
                    }
                }
                IValue last = specificValue.getValueRefdLast(timestamp, expectedValue, null);
                if (last == null) {
                    return true;
                }
                if (last == this) {
                    return this.getIsErroneous(timestamp);
                }
                return last.isUnfoldable(timestamp, expectedValue, referenceChain);
            }
            return specificValue.isUnfoldable(timestamp, expectedValue, referenceChain);
        }
        if (ITTCN3Template.Template_type.TEMPLATE_REFD.equals((Object)template.getTemplatetype())) {
            Reference reference = ((Referenced_Template)template).getReference();
            Assignment ass = reference.getRefdAssignment(timestamp, true);
            if (ass == null) {
                return true;
            }
            switch (ass.getAssignmentType()) {
                case A_TEMPLATE: {
                    break;
                }
                default: {
                    return true;
                }
            }
            TTCN3Template last = template.getTemplateReferencedLast(timestamp);
            if (last == null) {
                return true;
            }
            if (last == template) {
                return last.getIsErroneous(timestamp);
            }
            if (ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)last.getTemplatetype())) {
                return ((SpecificValue_Template)last).getValue().isUnfoldable(timestamp, expectedValue, referenceChain);
            }
        }
        return true;
    }

    @Override
    public IValue setLoweridToReference(CompilationTimeStamp timestamp) {
        if (this.templateInstance != null && this.templateInstance.getType() != null && this.templateInstance.getDerivedReference() != null) {
            this.templateInstance.getTemplateBody().setLoweridToReference(timestamp);
        }
        return this;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        Expected_Value_type internalExpectation = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? Expected_Value_type.EXPECTED_TEMPLATE : expectedValue;
        IType governor = this.templateInstance.getExpressionGovernor(timestamp, internalExpectation);
        if (governor == null) {
            ITTCN3Template template = this.templateInstance.getTemplateBody().setLoweridToReference(timestamp);
            governor = template.getExpressionGovernor(timestamp, internalExpectation);
        }
        if (governor == null) {
            this.templateInstance.getLocation().reportSemanticError(OPERANDERROR);
            this.setIsErroneous(true);
        } else {
            this.templateInstance.getExpressionReturntype(timestamp, internalExpectation);
            IsBoundExpression.checkExpressionTemplateInstance(timestamp, this, this.templateInstance, governor, referenceChain, expectedValue);
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.templateInstance == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        if (this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        TTCN3Template template = this.templateInstance.getTemplateBody();
        template = template.getTemplateReferencedLast(timestamp);
        boolean result = false;
        if (template.getTemplatetype() == ITTCN3Template.Template_type.TEMPLATE_REFD) {
            TTCN3Template last = template.getTemplateReferencedLast(timestamp);
            if (last != null && ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)last.getTemplatetype())) {
                result = ((SpecificValue_Template)last).getValue().evaluateIsbound(timestamp, ((Referenced_Template)template).getReference(), 1);
            }
        } else if (template.getTemplatetype() == ITTCN3Template.Template_type.SPECIFIC_VALUE) {
            IValue value = ((SpecificValue_Template)template).getValue();
            result = value.getValuetype() == IValue.Value_type.REFERENCED_VALUE ? value.evaluateIsbound(timestamp, ((Referenced_Value)value).getReference(), 1) : !value.getIsErroneous(timestamp);
        }
        this.lastValue = new Boolean_Value(result);
        this.lastValue.copyGeneralProperties(this);
        return this.lastValue;
    }

    private static void checkExpressionTemplateInstance(CompilationTimeStamp timestamp, Expression_Value expression, TemplateInstance instance, IType type, IReferenceChain referenceChain, Expected_Value_type expectedValue) {
        TTCN3Template template;
        IValue value;
        Expected_Value_type internalExpectation = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? Expected_Value_type.EXPECTED_TEMPLATE : expectedValue;
        TTCN3Template body = instance.getTemplateBody();
        if (body.getTemplatetype() == ITTCN3Template.Template_type.TEMPLATE_REFD) {
            ((Referenced_Template)body).getReference().setUsedInIsbound();
        } else if (body.getTemplatetype() == ITTCN3Template.Template_type.SPECIFIC_VALUE && (value = ((SpecificValue_Template)body).getValue()).getValuetype() == IValue.Value_type.REFERENCED_VALUE) {
            ((Referenced_Value)value).getReference().setUsedInIsbound();
        }
        instance.check(timestamp, type);
        if (!Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)internalExpectation) && instance.getDerivedReference() != null) {
            if (Expected_Value_type.EXPECTED_CONSTANT.equals((Object)internalExpectation)) {
                instance.getLocation().reportSemanticError(CONSTEXPECTED1);
            } else {
                instance.getLocation().reportSemanticError(STATICEXPECTED1);
            }
            expression.setIsErroneous(true);
        }
        if ((template = instance.getTemplateBody()).getIsErroneous(timestamp)) {
            expression.setIsErroneous(true);
            return;
        }
        switch (template.getTemplatetype()) {
            case TEMPLATE_REFD: {
                if (Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)internalExpectation)) {
                    if (!(template = template.getTemplateReferencedLast(timestamp, referenceChain)).getIsErroneous(timestamp)) break;
                    expression.setIsErroneous(true);
                    break;
                }
                if (Expected_Value_type.EXPECTED_CONSTANT.equals((Object)internalExpectation)) {
                    instance.getLocation().reportSemanticError(MessageFormat.format(CONSTEXPECTED2, ((Referenced_Template)template).getReference().getRefdAssignment(timestamp, true).getDescription()));
                } else {
                    instance.getLocation().reportSemanticError(MessageFormat.format(STATICEXPECTED2, ((Referenced_Template)template).getReference().getRefdAssignment(timestamp, true).getDescription()));
                }
                expression.setIsErroneous(true);
                break;
            }
            case SPECIFIC_VALUE: {
                IValue tempValue = ((SpecificValue_Template)template).getSpecificValue();
                switch (tempValue.getValuetype()) {
                    case REFERENCED_VALUE: {
                        type.checkThisValueRef(timestamp, tempValue);
                        break;
                    }
                    case EXPRESSION_VALUE: {
                        tempValue.getValueRefdLast(timestamp, referenceChain);
                        break;
                    }
                }
                if (!tempValue.getIsErroneous(timestamp)) break;
                expression.setIsErroneous(true);
                break;
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.templateInstance != null) {
            this.templateInstance.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInstance == null) {
            return;
        }
        this.templateInstance.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.templateInstance == null || this.templateInstance.accept(v);
    }
}

