/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Array_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Hexstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Octetstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.RotateRightExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class RotateLeftExpression
extends Expression_Value {
    private static final String FIRSTOPERANDERROR = "The first operand of the `<@' operation should be a string, `record of', `set of' or an array value";
    private static final String SECONDOPERANDERROR = "The second operand of the `<@' operation should be an integer value";
    private static final String EFFECTLESSROTATION = "Rotating will not change the value";
    private static final String NEGATIVEROTATEPROBLEM = "Rotating to the right should be used instead of rotating to the left with a negative value";
    private static final String ZEROROTATEPROBLEM = "Rotating to the left with 0 will not change the original value";
    private static final String TOOBIGROTATEPROBLEM = "Rotating a {0} long value to the left with {1} will have the same effect as rotating by {2}";
    private static final String LARGEINTEGERSECONDOPERANDERROR = "Using a large integer value ({0}) as the second operand of the `<@'' operation is not supported";
    private final Value value1;
    private final Value value2;

    public RotateLeftExpression(Value value1, Value value2) {
        this.value1 = value1;
        this.value2 = value2;
        if (value1 != null) {
            value1.setFullNameParent(this);
        }
        if (value2 != null) {
            value2.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.ROTATELEFT_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append('(').append(this.value1.createStringRepresentation());
        builder.append(" <@ ");
        builder.append(this.value2.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value1 != null) {
            this.value1.setMyScope(scope);
        }
        if (this.value2 != null) {
            this.value2.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value1 == child) {
            return builder.append(".<operand1>");
        }
        if (this.value2 == child) {
            return builder.append(".<operand2>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        IValue last = this.getValueRefdLast(timestamp, expectedValue, null);
        if (last == null || this.value1 == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        if (last.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return IType.Type_type.TYPE_UNDEFINED;
        }
        this.value1.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.value1.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_BITSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_CHARSTRING: 
            case TYPE_UCHARSTRING: 
            case TYPE_SET_OF: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_ARRAY: {
                return tempType;
            }
            case TYPE_UNDEFINED: {
                return tempType;
            }
        }
        this.setIsErroneous(true);
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value1 == null || this.value2 == null || this.getIsErroneous(timestamp)) {
            return true;
        }
        if (this.value1.isUnfoldable(timestamp, expectedValue, referenceChain) || this.value2.isUnfoldable(timestamp, expectedValue, referenceChain)) {
            return true;
        }
        this.value1.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.value1.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_BITSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_OCTETSTRING: 
            case TYPE_CHARSTRING: 
            case TYPE_UCHARSTRING: {
                return false;
            }
        }
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        IValue tempValue;
        IType.Type_type tempType1 = null;
        IType.Type_type tempType2 = null;
        long valueSize = 0L;
        long rotationSize = 0L;
        if (this.value1 != null) {
            this.value1.setLoweridToReference(timestamp);
            tempType1 = this.value1.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType1) {
                case TYPE_BITSTRING: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (!IValue.Value_type.BITSTRING_VALUE.equals((Object)tempValue.getValuetype())) break;
                    valueSize = ((Bitstring_Value)tempValue).getValueLength();
                    break;
                }
                case TYPE_HEXSTRING: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (!IValue.Value_type.HEXSTRING_VALUE.equals((Object)tempValue.getValuetype())) break;
                    valueSize = ((Hexstring_Value)tempValue).getValueLength();
                    break;
                }
                case TYPE_OCTETSTRING: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (!IValue.Value_type.OCTETSTRING_VALUE.equals((Object)tempValue.getValuetype())) break;
                    valueSize = ((Octetstring_Value)tempValue).getValueLength();
                    break;
                }
                case TYPE_CHARSTRING: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (!IValue.Value_type.CHARSTRING_VALUE.equals((Object)tempValue.getValuetype())) break;
                    valueSize = ((Charstring_Value)tempValue).getValueLength();
                    break;
                }
                case TYPE_UCHARSTRING: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (!IValue.Value_type.UNIVERSALCHARSTRING_VALUE.equals((Object)tempValue.getValuetype())) break;
                    valueSize = ((UniversalCharstring_Value)tempValue).getValueLength();
                    break;
                }
                case TYPE_SET_OF: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (IValue.Value_type.SEQUENCEOF_VALUE.equals((Object)tempValue.getValuetype())) {
                        tempValue = tempValue.setValuetype(timestamp, IValue.Value_type.SETOF_VALUE);
                    }
                    if (!IValue.Value_type.SETOF_VALUE.equals((Object)tempValue.getValuetype())) break;
                    valueSize = ((SetOf_Value)tempValue).getNofComponents();
                    break;
                }
                case TYPE_SEQUENCE_OF: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (IValue.Value_type.SEQUENCEOF_VALUE.equals((Object)tempValue.getValuetype())) {
                        valueSize = ((SequenceOf_Value)tempValue).getNofComponents();
                        break;
                    }
                    if (!IValue.Value_type.SETOF_VALUE.equals((Object)tempValue.getValuetype())) break;
                    valueSize = ((SetOf_Value)tempValue).getNofComponents();
                    break;
                }
                case TYPE_ARRAY: {
                    tempValue = this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (IValue.Value_type.SEQUENCEOF_VALUE.equals((Object)tempValue.getValuetype())) {
                        tempValue = tempValue.setValuetype(timestamp, IValue.Value_type.ARRAY_VALUE);
                    }
                    if (!IValue.Value_type.ARRAY_VALUE.equals((Object)tempValue.getValuetype())) break;
                    valueSize = ((Array_Value)tempValue).getNofComponents();
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(FIRSTOPERANDERROR);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.value2 != null) {
            this.value2.setLoweridToReference(timestamp);
            tempType2 = this.value2.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType2) {
                case TYPE_INTEGER: {
                    tempValue = this.value2.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (!IValue.Value_type.INTEGER_VALUE.equals((Object)tempValue.getValuetype()) || this.getIsErroneous(timestamp)) break;
                    if (!((Integer_Value)tempValue).isNative()) {
                        this.value2.getLocation().reportSemanticError(MessageFormat.format(LARGEINTEGERSECONDOPERANDERROR, tempValue));
                        this.setIsErroneous(true);
                        break;
                    }
                    rotationSize = ((Integer_Value)tempValue).getValue();
                    if (this.value1 == null || this.value1.isUnfoldable(timestamp)) break;
                    String severtiy = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportIncorrectShiftRotateSize", "warning", null);
                    if (valueSize == 0L || valueSize == 1L) {
                        this.location.reportConfigurableSemanticProblem(severtiy, EFFECTLESSROTATION);
                        break;
                    }
                    if (rotationSize < 0L) {
                        this.location.reportConfigurableSemanticProblem(severtiy, NEGATIVEROTATEPROBLEM);
                        break;
                    }
                    if (rotationSize == 0L) {
                        this.location.reportConfigurableSemanticProblem(severtiy, ZEROROTATEPROBLEM);
                        break;
                    }
                    if (rotationSize <= valueSize) break;
                    this.location.reportConfigurableSemanticProblem(severtiy, MessageFormat.format(TOOBIGROTATEPROBLEM, valueSize, rotationSize, rotationSize % valueSize));
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(SECONDOPERANDERROR);
                    this.setIsErroneous(true);
                }
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value1 == null || this.value2 == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        if (this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        IValue last1 = this.value1.getValueRefdLast(timestamp, referenceChain);
        IValue last2 = this.value2.getValueRefdLast(timestamp, referenceChain);
        switch (last1.getValuetype()) {
            case BITSTRING_VALUE: {
                String string = ((Bitstring_Value)last1).getValue();
                int shiftSize = ((Integer_Value)last2).intValue();
                this.lastValue = new Bitstring_Value(RotateLeftExpression.rotateLeft(string, shiftSize));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case HEXSTRING_VALUE: {
                String string = ((Hexstring_Value)last1).getValue();
                int shiftSize = ((Integer_Value)last2).intValue();
                this.lastValue = new Hexstring_Value(RotateLeftExpression.rotateLeft(string, shiftSize));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case OCTETSTRING_VALUE: {
                String string = ((Octetstring_Value)last1).getValue();
                int shiftSize = ((Integer_Value)last2).intValue() * 2;
                this.lastValue = new Octetstring_Value(RotateLeftExpression.rotateLeft(string, shiftSize));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case CHARSTRING_VALUE: {
                String string = ((Charstring_Value)last1).getValue();
                int shiftSize = ((Integer_Value)last2).intValue();
                this.lastValue = new Charstring_Value(RotateLeftExpression.rotateLeft(string, shiftSize));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case UNIVERSALCHARSTRING_VALUE: {
                UniversalCharstring string2 = ((UniversalCharstring_Value)last1).getValue();
                int shiftSize = ((Integer_Value)last2).intValue();
                this.lastValue = new UniversalCharstring_Value(RotateLeftExpression.rotateLeft(string2, shiftSize));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            default: {
                this.setIsErroneous(true);
            }
        }
        return this.lastValue;
    }

    public static String rotateLeft(String string, int rotateSize) {
        if (string.length() == 0) {
            return "";
        }
        if (rotateSize < 0) {
            return RotateRightExpression.rotateRight(string, -rotateSize);
        }
        int realAmmount = rotateSize % string.length();
        if (realAmmount == 0) {
            return string;
        }
        return string.substring(realAmmount) + string.substring(0, realAmmount);
    }

    public static UniversalCharstring rotateLeft(UniversalCharstring string, int rotateSize) {
        if (string.length() == 0) {
            return new UniversalCharstring();
        }
        if (rotateSize < 0) {
            return RotateRightExpression.rotateRight(string, -rotateSize);
        }
        int realAmmount = rotateSize % string.length();
        if (realAmmount == 0) {
            return new UniversalCharstring(string);
        }
        return string.substring(realAmmount).append(string.substring(0, realAmmount));
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.value1 != null) {
                referenceChain.markState();
                this.value1.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.value2 != null) {
                referenceChain.markState();
                this.value2.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value1 != null) {
            this.value1.updateSyntax(reparser, false);
            reparser.updateLocation(this.value1.getLocation());
        }
        if (this.value2 != null) {
            this.value2.updateSyntax(reparser, false);
            reparser.updateLocation(this.value2.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value1 != null) {
            this.value1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value2 != null) {
            this.value2.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value1 != null && !this.value1.accept(v)) {
            return false;
        }
        return this.value2 == null || this.value2.accept(v);
    }

    public Value getValue1() {
        return this.value1;
    }

    public Value getValue2() {
        return this.value2;
    }
}

