/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.brokenpartsanalyzers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ImportModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.IBaseAnalyzer;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.SelectionAlgorithm;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.SelectionMethodBase;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public final class OriginalModuleSelection
extends SelectionMethodBase
implements IBaseAnalyzer {
    private final boolean doIncrementalParsing = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useIncrementalParsing", false, null);

    public OriginalModuleSelection() {
        super(SelectionAlgorithm.MODULESELECTIONORIGINAL);
        this.header = "\n**Selection with Original algorithm is started at:";
        this.footer = "**Selection with Original algorithm is started at:";
    }

    @Override
    public void execute() {
        if (this.writeDebugInfo) {
            TITANDebugConsole.println(String.format(this.format, this.header, this.simpleDateFormat.format(new Date())));
        }
        this.start = System.nanoTime();
        boolean foundSkippable = true;
        while (foundSkippable) {
            foundSkippable = this.calculateModulesToSkip(this.allModules, this.modulesToSkip);
        }
        this.modulesToCheck.addAll(this.allModules);
        if (this.doIncrementalParsing) {
            this.incrementalParsing();
        }
        this.end = System.nanoTime() - this.start;
        if (this.writeDebugInfo) {
            TITANDebugConsole.println(String.format(this.format, this.footer, this.simpleDateFormat.format(new Date())));
            this.infoAfterExecute();
        }
    }

    private boolean calculateModulesToSkip(List<Module> modulesToCheck, List<Module> modulesToSkip) {
        if (modulesToCheck.isEmpty()) {
            return false;
        }
        boolean foundSkippable = false;
        ArrayList<Module> failed = new ArrayList<Module>();
        ArrayList<Module> modulesToCheckCopy = new ArrayList<Module>();
        modulesToCheckCopy.addAll(modulesToCheck);
        MessageConsoleStream stream = TITANDebugConsole.getConsole().newMessageStream();
        for (Module module : modulesToCheckCopy) {
            if (module == null || failed.contains(module) || modulesToSkip.contains(module)) continue;
            if (module.getLastCompilationTimeStamp() == null || !this.semanticallyChecked.contains(module.getName())) {
                if (this.writeDebugInfo) {
                    TITANDebugConsole.println("  ** Module " + module.getName() + " can not be skipped as it was not yet analyzed.", stream);
                }
                failed.add(module);
                continue;
            }
            ArrayList<Module> reachableModules = new ArrayList<Module>();
            reachableModules.add(module);
            boolean valid = true;
            for (int i = 0; i < reachableModules.size() && valid; ++i) {
                Module module2 = (Module)reachableModules.get(i);
                if (module2 == null) {
                    valid = false;
                    TITANDebugConsole.println("  ** Module " + module.getName() + " can not be skipped as it reaches a module that could not be parsed.", stream);
                    continue;
                }
                if (failed.contains(module2)) {
                    valid = false;
                    continue;
                }
                if (module2.getLastCompilationTimeStamp() != null || !this.semanticallyChecked.contains(module2.getName())) {
                    if (module2.hasUnhandledImportChanges()) {
                        valid = false;
                        failed.add(module2);
                        if (!this.writeDebugInfo) continue;
                        TITANDebugConsole.println("  ** Module " + module2.getName() + " can not be skipped as it has unhandled import changes.", stream);
                        if (module == module2) continue;
                        TITANDebugConsole.println("  ** Module " + module.getName() + " can not be skipped as it depends on " + module2.getName() + " which has unhandled import changes.", stream);
                        continue;
                    }
                    List<Module> importedModules = module2.getImportedModules();
                    if (importedModules.isEmpty()) continue;
                    boolean allElements = true;
                    for (int j = 0; j < importedModules.size() && allElements; ++j) {
                        Module module3 = importedModules.get(j);
                        if (module3 == null) {
                            List<ImportModule> impModules;
                            allElements = false;
                            if (!this.writeDebugInfo) continue;
                            if (module2 instanceof TTCN3Module && j < (impModules = ((TTCN3Module)module2).getImports()).size()) {
                                TITANDebugConsole.println("  ** Module " + module.getName() + " can not be skipped as it imports `" + impModules.get(j).getName() + "' that could not be parsed.", stream);
                            }
                            TITANDebugConsole.println("  ** Module " + module.getName() + " can not be skipped as it imports a module that could not be parsed.", stream);
                            continue;
                        }
                        if (failed.contains(module3)) {
                            allElements = false;
                            if (!this.writeDebugInfo) continue;
                            TITANDebugConsole.println("  ** Module " + module.getName() + " can not be skipped as it depends on " + module3.getName() + " which needs to be checked.", stream);
                            continue;
                        }
                        if (modulesToSkip.contains(module3)) continue;
                        if (module3.getLastCompilationTimeStamp() == null || !this.semanticallyChecked.contains(module3.getName())) {
                            allElements = false;
                            if (!this.writeDebugInfo) continue;
                            TITANDebugConsole.println("  ** Module " + module.getName() + " can not be skipped as it depends on " + module3.getName() + " which was not yet analyzed.", stream);
                            continue;
                        }
                        if (reachableModules.contains(module3)) continue;
                        reachableModules.add(module3);
                    }
                    if (allElements) continue;
                    valid = false;
                    continue;
                }
                valid = false;
                TITANDebugConsole.println("  ** Module " + module.getName() + " can not be skipped as it depends on " + module2.getName() + " which was not yet checked.", stream);
            }
            if (valid) {
                modulesToSkip.addAll(reachableModules);
                modulesToCheck.removeAll(reachableModules);
                foundSkippable = true;
                continue;
            }
            failed.add(module);
        }
        if (this.writeDebugInfo) {
            TITANDebugConsole.println("  ** Found " + modulesToCheck.size() + " modules that needs to be checked and " + modulesToSkip.size() + " modules to skip.", stream);
        }
        return foundSkippable;
    }

    public void incrementalParsing() {
        ArrayList<Module> modulesToCheck2 = new ArrayList<Module>();
        for (Module module2 : this.modulesToCheck) {
            List<Module> importedModules;
            if (module2.getLastCompilationTimeStamp() == null || !this.semanticallyChecked.contains(module2.getName()) || (importedModules = module2.getImportedModules()) == null || importedModules.isEmpty()) continue;
            for (Module module3 : importedModules) {
                if (module3 == null || this.modulesToCheck.contains(module3) || modulesToCheck2.contains(module3)) continue;
                modulesToCheck2.add(module3);
            }
        }
        this.modulesToCheck.addAll(modulesToCheck2);
        this.modulesToSkip.removeAll(modulesToCheck2);
    }
}

