/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.core.TITANBuilder;
import org.eclipse.titan.designer.core.TITANBuilderResourceVisitor;
import org.eclipse.titan.designer.core.TITANJob;
import org.eclipse.titan.designer.properties.data.ProjectBuildPropertyData;
import org.eclipse.ui.console.MessageConsole;

public final class SymbolicLinkHandler {
    static final String LINK_EXTENSION = ".lnk";
    static final String EMPTY_STRING = "";
    static final String LINK_CREATION = "ln";
    static final String FORCE_LINK_CREATION = "-sf";
    static final String APOSTROPHE = "'";
    static final String GENERATING_SYMBOLIC_LINKS = "Generating symbolic links";
    static final String TRUE = "true";
    static final String SYMBOLIC_LINK_CREATION_PROCESS = "Symbolic link creation";
    static final String REMOVE = "rm";
    static final String CREATING_OUTDATED_LINK_REMOVAL = "Creating command for removing possibly outdated symbolic links";
    static final String REMOVING_OUTDATED_LINK = "Removing possibly outdated symbolic link";
    static final String FORCE_EXECUTION = "-f";

    private SymbolicLinkHandler() {
    }

    public static void addSymlinkCreationCommand(Map<String, IFile> files, String workingDirectory, TITANJob buildJob, Map<String, IFile> lastTimeRemovedFiles, IProgressMonitor monitor, boolean automaticMakefileManagement) {
        ArrayList<String> symlinkFiles = new ArrayList<String>();
        boolean win32 = "win32".equals(Platform.getOS());
        String extension = win32 ? LINK_EXTENSION : EMPTY_STRING;
        IProgressMonitor internalMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        internalMonitor.beginTask("Checking the symbolic links of files", files.size());
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        for (IFile file : files.values()) {
            if (automaticMakefileManagement && (file.getName().contentEquals("Makefile") || file.getName().contentEquals("makefile"))) continue;
            IPath path = file.getLocation();
            if (path == null) {
                try {
                    file.copy((IPath)new Path(workingDirectory + file.getName()), 1, monitor);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((String)("While copying the file `" + file.getLocationURI() + "' to the working directory"), (Throwable)e);
                }
                internalMonitor.worked(1);
                continue;
            }
            String lastSegment = path.lastSegment();
            boolean tempFileRemoved = lastTimeRemovedFiles.containsKey(lastSegment);
            File tempFile = new File(workingDirectory + File.separatorChar + lastSegment + extension);
            if (tempFile.exists() && !tempFileRemoved) {
                if (win32) {
                    symlinkFiles.add(lastSegment);
                    internalMonitor.worked(1);
                    continue;
                }
                try {
                    String canonicalPath = tempFile.getCanonicalPath();
                    String absolutePath = tempFile.getAbsolutePath();
                    if (!absolutePath.equals(canonicalPath) && path.toString().equals(canonicalPath)) {
                        symlinkFiles.add(lastSegment);
                        internalMonitor.worked(1);
                        continue;
                    }
                }
                catch (IOException e) {
                    ErrorReporter.logExceptionStackTrace((String)("While getting the canonical path of `" + tempFile.getName() + APOSTROPHE), (Throwable)e);
                }
            }
            if (tempFile.getAbsolutePath().equals(file.getLocation().toOSString())) {
                symlinkFiles.add(lastSegment);
                internalMonitor.worked(1);
                continue;
            }
            if (!symlinkFiles.contains(lastSegment)) {
                symlinkFiles.add(lastSegment);
                ArrayList<String> command = new ArrayList<String>();
                command.add(LINK_CREATION);
                command.add(FORCE_LINK_CREATION);
                command.add(APOSTROPHE + PathConverter.convert((String)file.getLocation().toOSString(), (boolean)reportDebugInformation, (MessageConsole)TITANDebugConsole.getConsole()) + APOSTROPHE);
                command.add(APOSTROPHE + lastSegment + APOSTROPHE);
                buildJob.addCommand(command, GENERATING_SYMBOLIC_LINKS);
            }
            internalMonitor.worked(1);
        }
        internalMonitor.done();
    }

    public static void copyExternalFileToWorkingDirectory(Map<String, IFile> files, String workingDirectory, IProgressMonitor monitor) {
        IProgressMonitor internalMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        internalMonitor.beginTask("Checking the symbolic links of external files", files.size());
        for (IFile file : files.values()) {
            IPath path = file.getLocation();
            if (path != null) continue;
            try {
                URI uri = file.getLocationURI();
                IFileStore source = EFS.getFileSystem((String)uri.getScheme()).getStore(uri);
                Path destinationPath = new Path(workingDirectory + File.separator + file.getName());
                if (!destinationPath.toFile().exists()) {
                    IFileStore destination = EFS.getLocalFileSystem().getStore((IPath)destinationPath);
                    source.copy(destination, 2, internalMonitor);
                }
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While processing file `" + file.getName() + APOSTROPHE), (Throwable)e);
            }
            internalMonitor.worked(1);
        }
        internalMonitor.done();
    }

    public static boolean createSymlinks(IResource resource) {
        IProject rProject = resource.getProject();
        if (!TITANBuilder.isBuilderEnabled(rProject)) {
            return true;
        }
        if (!ProjectBuildPropertyData.useSymbolicLinks(rProject)) {
            return true;
        }
        IPath workingDir = ProjectBasedBuilder.getProjectBasedBuilder(rProject).getWorkingDirectoryPath(true);
        if (workingDir == null || !workingDir.toFile().exists()) {
            return true;
        }
        if (ResourceExclusionHelper.isExcluded(resource) || SymbolicLinkHandler.isInCentralStorage(resource)) {
            return true;
        }
        TITANBuilderResourceVisitor visitor = ProjectBasedBuilder.getProjectBasedBuilder(rProject).getResourceVisitor();
        if (visitor.getFiles().isEmpty()) {
            return true;
        }
        TITANJob buildJob = new TITANJob(SYMBOLIC_LINK_CREATION_PROCESS, visitor.getFiles(), workingDir.toFile(), rProject);
        buildJob.setPriority(50);
        buildJob.setUser(true);
        buildJob.setRule((ISchedulingRule)rProject);
        SymbolicLinkHandler.addSymlinkCreationCommand(visitor.getFiles(), workingDir.toOSString(), buildJob, new HashMap<String, IFile>(), null, ProjectBuildPropertyData.useAutomaticMakefilegeneration(rProject));
        buildJob.schedule();
        return true;
    }

    public static boolean removeSymlinksForExcluded(IProject project) {
        if (!TITANBuilder.isBuilderEnabled(project)) {
            return true;
        }
        IPath workingDir = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryPath(true);
        if (workingDir == null) {
            return false;
        }
        TITANBuilderResourceVisitor visitor = ProjectBasedBuilder.getProjectBasedBuilder(project).getResourceVisitor();
        Map<String, IFile> excludedFiles = visitor.getExcludedFiles();
        TITANJob buildJob = new TITANJob("symbolic link removal", excludedFiles, workingDir.toFile(), project);
        buildJob.setPriority(50);
        buildJob.setUser(true);
        buildJob.setRule((ISchedulingRule)project);
        SymbolicLinkHandler.addSymlinkRemovingCommandForExcludedFiles(workingDir.toOSString(), buildJob, excludedFiles, (IProgressMonitor)new NullProgressMonitor());
        buildJob.schedule();
        return true;
    }

    public static void addSymlinkRemovingCommandForRemovedFiles(String workingDirectory, TITANJob job, Map<String, IFile> files, IProgressMonitor monitor) {
        if (files.isEmpty()) {
            return;
        }
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        String extension = "win32".equals(Platform.getOS()) ? LINK_EXTENSION : EMPTY_STRING;
        monitor.beginTask(CREATING_OUTDATED_LINK_REMOVAL, files.size());
        for (String key : files.keySet()) {
            File tempFile = new File(workingDirectory + File.separatorChar + key + extension);
            ArrayList<String> command = new ArrayList<String>();
            command.add(REMOVE);
            command.add(FORCE_EXECUTION);
            command.add(APOSTROPHE + PathConverter.convert((String)tempFile.getAbsolutePath(), (boolean)reportDebugInformation, (MessageConsole)TITANDebugConsole.getConsole()) + APOSTROPHE);
            job.addCommand(command, REMOVING_OUTDATED_LINK);
            monitor.worked(1);
        }
        monitor.done();
    }

    public static void addSymlinkRemovingCommandForExcludedFiles(String workingDirectory, TITANJob job, Map<String, IFile> files, IProgressMonitor monitor) {
        if (files.isEmpty()) {
            return;
        }
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        boolean isWindows = "win32".equals(Platform.getOS());
        String extension = isWindows ? LINK_EXTENSION : EMPTY_STRING;
        monitor.beginTask(CREATING_OUTDATED_LINK_REMOVAL, files.size());
        for (Map.Entry<String, IFile> entry : files.entrySet()) {
            File tempFile = new File(workingDirectory + File.separatorChar + entry.getKey() + extension);
            IPath location = entry.getValue().getLocation();
            if (location == null) continue;
            String originalLocation = location.toOSString();
            try {
                if (tempFile.exists() && (isWindows || originalLocation.equals(tempFile.getCanonicalPath()))) {
                    ArrayList<String> command = new ArrayList<String>();
                    command.add(REMOVE);
                    command.add(FORCE_EXECUTION);
                    command.add(APOSTROPHE + PathConverter.convert((String)tempFile.getAbsolutePath(), (boolean)reportDebugInformation, (MessageConsole)TITANDebugConsole.getConsole()) + APOSTROPHE);
                    job.addCommand(command, REMOVING_OUTDATED_LINK);
                }
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((String)("While removing symlink for `" + tempFile.getName() + APOSTROPHE), (Throwable)e);
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    public static boolean isInCentralStorage(IResource resource) {
        IResource temp = resource;
        while (temp.getType() != 4) {
            if (temp.getType() == 2) {
                try {
                    if (TRUE.equals(temp.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "centralStorage")))) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    return true;
                }
            }
            temp = temp.getParent();
        }
        return false;
    }
}

