/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.LoggingSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.LoggerTreeContentProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.LoggerTreeLabelProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.LoggingPage;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.NewComponentDialog;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.NewPluginDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public final class LoggingTreeSubPage {
    private TreeViewer componentpluginViewer;
    private Tree componentpluginTree;
    private Button addComponent;
    private Button addPlugin;
    private Button removeSelected;
    private ConfigEditor editor;
    private LoggingPage loggingPage;
    private LoggingSectionHandler loggingSectionHandler;

    public LoggingTreeSubPage(ConfigEditor editor, LoggingPage loggingPage) {
        this.editor = editor;
        this.loggingPage = loggingPage;
    }

    void createSectionComponent(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 384);
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        section.setText("Components and plugins");
        section.setDescription("In this section you can manage your components and plugins. For each component and plugin different log setting are available on the right section of the page. The settings of the default component/plugin are valid for all components/plugins unless it is overriden by component/plugin specific settings.");
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        client.setLayout((Layout)layout);
        section.setClient((Control)client);
        toolkit.paintBordersFor(client);
        this.createMainPart(toolkit, client);
    }

    private void createMainPart(FormToolkit toolkit, Composite parent) {
        Composite components = toolkit.createComposite(parent, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        components.setLayout((Layout)layout);
        components.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.paintBordersFor(components);
        this.componentpluginTree = toolkit.createTree(components, 66308);
        GridData gd = new GridData(4, 4, true, true);
        this.componentpluginTree.setLayoutData((Object)gd);
        this.componentpluginTree.setEnabled(this.loggingSectionHandler != null);
        this.componentpluginViewer = new TreeViewer(this.componentpluginTree);
        this.componentpluginViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LoggingTreeSubPage.this.selectionRefresh();
            }
        });
        this.componentpluginViewer.setContentProvider((IContentProvider)new LoggerTreeContentProvider());
        this.componentpluginViewer.setLabelProvider((IBaseLabelProvider)new LoggerTreeLabelProvider());
        this.componentpluginViewer.setInput((Object)this.loggingSectionHandler);
        Composite buttons = toolkit.createComposite(components);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(1026));
        this.addComponent = toolkit.createButton(buttons, "Add component...", 8);
        GridData gdButton = new GridData(258);
        this.addComponent.setLayoutData((Object)gdButton);
        this.addComponent.setEnabled(this.loggingSectionHandler != null);
        this.addComponent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name;
                NewComponentDialog dialog;
                if (LoggingTreeSubPage.this.loggingSectionHandler == null) {
                    return;
                }
                if (LoggingTreeSubPage.this.loggingSectionHandler.getLastSectionRoot() == null) {
                    LoggingTreeSubPage.this.loggingPage.createLoggingSection();
                }
                if (0 == (dialog = new NewComponentDialog(LoggingTreeSubPage.this.addComponent.getShell(), LoggingTreeSubPage.this.loggingSectionHandler.getComponents())).open() && (name = dialog.getName()) != null) {
                    LoggingSectionHandler.LogParamEntry lpe = LoggingTreeSubPage.this.loggingSectionHandler.componentPlugin(name, null);
                    LoggingTreeSubPage.this.internalRefresh();
                    LoggingTreeSubPage.this.loggingPage.treeElementAdded(new LoggingSectionHandler.LoggerTreeElement(LoggingTreeSubPage.this.loggingSectionHandler, name, null), lpe);
                    LoggingTreeSubPage.this.editor.setDirty();
                }
            }
        });
        this.addPlugin = toolkit.createButton(buttons, "Add plugin...", 8);
        gdButton = new GridData(258);
        this.addPlugin.setLayoutData((Object)gdButton);
        this.addPlugin.setEnabled(this.loggingSectionHandler != null);
        this.addPlugin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPluginDialog dialog;
                LoggingSectionHandler.LoggerTreeElement lte;
                if (LoggingTreeSubPage.this.loggingSectionHandler == null) {
                    return;
                }
                if (LoggingTreeSubPage.this.loggingSectionHandler.getLastSectionRoot() == null) {
                    LoggingTreeSubPage.this.loggingPage.createLoggingSection();
                }
                if ((lte = LoggingTreeSubPage.this.getSelection()) != null && 0 == (dialog = new NewPluginDialog(LoggingTreeSubPage.this.addPlugin.getShell(), LoggingTreeSubPage.this.loggingSectionHandler.getPlugins(lte.getComponentName()))).open()) {
                    String name = dialog.getName();
                    String path = dialog.getPath();
                    if (name != null) {
                        LoggingSectionHandler.LogParamEntry lpe = LoggingTreeSubPage.this.loggingSectionHandler.componentPlugin(lte.getComponentName(), name);
                        lpe.setPluginPath(path);
                        LoggingTreeSubPage.this.addPluginToList(lte.getComponentName(), name, path);
                        LoggingTreeSubPage.this.internalRefresh();
                        LoggingTreeSubPage.this.loggingPage.treeElementAdded(new LoggingSectionHandler.LoggerTreeElement(LoggingTreeSubPage.this.loggingSectionHandler, lte.getComponentName(), name), lpe);
                        LoggingTreeSubPage.this.editor.setDirty();
                    }
                }
            }
        });
        this.removeSelected = toolkit.createButton(buttons, "Remove selected", 8);
        gdButton = new GridData(258);
        this.removeSelected.setLayoutData((Object)gdButton);
        this.removeSelected.setEnabled(this.loggingSectionHandler != null);
        this.removeSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggingSectionHandler.LoggerTreeElement lte;
                if (LoggingTreeSubPage.this.componentpluginViewer == null || LoggingTreeSubPage.this.loggingSectionHandler == null) {
                    return;
                }
                if (LoggingTreeSubPage.this.loggingSectionHandler.getComponents().isEmpty()) {
                    LoggingTreeSubPage.this.loggingPage.removeLoggingSection();
                }
                if ((lte = LoggingTreeSubPage.this.getSelection()) == null || "*".equals(lte.getPluginName())) {
                    return;
                }
                String tempComponentName = lte.getComponentName();
                if (tempComponentName == null) {
                    tempComponentName = "*";
                }
                Set plugins = LoggingTreeSubPage.this.loggingSectionHandler.getPlugins(tempComponentName);
                String tempPluginName = lte.getPluginName();
                if (tempPluginName == null) {
                    for (String plugin : plugins) {
                        LoggingSectionHandler.LogParamEntry lpe = LoggingTreeSubPage.this.loggingSectionHandler.componentPlugin(tempComponentName, plugin);
                        LoggingTreeSubPage.this.removeLoggingComponents(lpe);
                        LoggingTreeSubPage.this.removeFromPluginList(tempComponentName, plugin);
                    }
                    LoggingSectionHandler.LogParamEntry lpe = LoggingTreeSubPage.this.loggingSectionHandler.componentPlugin(tempComponentName, null);
                    LoggingTreeSubPage.this.removeLoggingComponents(lpe);
                    LoggingTreeSubPage.this.removeFromPluginList(tempComponentName, null);
                } else if (plugins.contains(tempPluginName)) {
                    LoggingSectionHandler.LogParamEntry lpe = LoggingTreeSubPage.this.loggingSectionHandler.componentPlugin(tempComponentName, tempPluginName);
                    LoggingTreeSubPage.this.removeLoggingComponents(lpe);
                    LoggingTreeSubPage.this.removeFromPluginList(tempComponentName, tempPluginName);
                }
                LoggingTreeSubPage.this.loggingSectionHandler.removeTreeElement(lte);
                LoggingTreeSubPage.this.internalRefresh();
                LoggingTreeSubPage.this.loggingPage.refreshData(LoggingTreeSubPage.this.loggingSectionHandler, null);
                LoggingTreeSubPage.this.editor.setDirty();
            }
        });
    }

    public LoggingSectionHandler.LoggerTreeElement getSelection() {
        ITreeSelection selection = (ITreeSelection)this.componentpluginViewer.getSelection();
        Object o = selection.getFirstElement();
        return (LoggingSectionHandler.LoggerTreeElement)o;
    }

    private void internalRefresh() {
        this.addComponent.setEnabled(this.loggingSectionHandler != null);
        this.addPlugin.setEnabled(this.loggingSectionHandler != null);
        this.removeSelected.setEnabled(this.loggingSectionHandler != null);
        this.componentpluginTree.setEnabled(this.loggingSectionHandler != null);
        this.componentpluginViewer.setInput((Object)this.loggingSectionHandler);
    }

    private void selectionRefresh() {
        LoggingSectionHandler.LoggerTreeElement lte = this.loggingPage.getSelectedTreeElement();
        if (lte != null) {
            this.loggingPage.treeElementSelected(lte);
        }
    }

    public void refreshData(LoggingSectionHandler loggingSectionHandler) {
        this.loggingSectionHandler = loggingSectionHandler;
        if (this.componentpluginViewer != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LoggingTreeSubPage.this.internalRefresh();
                    LoggingTreeSubPage.this.selectionRefresh();
                }
            });
        } else {
            this.loggingPage.refreshData(loggingSectionHandler, null);
        }
    }

    private void addPluginToList(String componentName, String pluginName, String path) {
        LoggingSectionHandler.LoggerPluginsEntry entry;
        if (this.loggingSectionHandler == null) {
            return;
        }
        StringBuilder pluginBuilder = new StringBuilder();
        pluginBuilder.append(pluginName);
        if (path != null && path.length() != 0) {
            pluginBuilder.append(" := \"").append(path).append("\"");
        }
        if ((entry = (LoggingSectionHandler.LoggerPluginsEntry)this.loggingSectionHandler.getLoggerPluginsTree().get(componentName)) == null) {
            entry = new LoggingSectionHandler.LoggerPluginsEntry();
            this.loggingSectionHandler.getLoggerPluginsTree().put(componentName, entry);
            ParserRuleContext loggerPluginsRoot = new ParserRuleContext();
            ConfigTreeNodeUtilities.addChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)loggerPluginsRoot);
            entry.setLoggerPluginsRoot((ParseTree)loggerPluginsRoot);
            StringBuilder builder = new StringBuilder();
            builder.append("\n").append(componentName).append(".LoggerPlugins := ");
            ConfigTreeNodeUtilities.addChild((ParseTree)loggerPluginsRoot, (ParseTree)new AddedParseTree(builder.toString()));
            ConfigTreeNodeUtilities.addChild((ParseTree)loggerPluginsRoot, (ParseTree)new AddedParseTree("{"));
            ParserRuleContext loggerPluginsListRoot = new ParserRuleContext();
            entry.setLoggerPluginsListRoot((ParseTree)loggerPluginsListRoot);
            LoggingSectionHandler.LoggerPluginEntry pluginEntry = new LoggingSectionHandler.LoggerPluginEntry();
            ParserRuleContext pluginRoot = new ParserRuleContext();
            pluginEntry.setLoggerPluginRoot((ParseTree)pluginRoot);
            pluginEntry.setName(pluginName);
            pluginEntry.setPath(path);
            ConfigTreeNodeUtilities.addChild((ParseTree)pluginRoot, (ParseTree)new AddedParseTree(pluginBuilder.toString()));
            entry.setPluginRoots(new HashMap(1));
            entry.getPluginRoots().put(pluginName, pluginEntry);
            ConfigTreeNodeUtilities.addChild((ParseTree)loggerPluginsListRoot, (ParseTree)pluginRoot);
            ConfigTreeNodeUtilities.addChild((ParseTree)loggerPluginsRoot, (ParseTree)loggerPluginsListRoot);
            ConfigTreeNodeUtilities.addChild((ParseTree)loggerPluginsRoot, (ParseTree)new AddedParseTree("}"));
            return;
        }
        int childCount = entry.getLoggerPluginsListRoot().getChildCount();
        ConfigTreeNodeUtilities.addChild((ParseTree)entry.getLoggerPluginsListRoot(), (ParseTree)new AddedParseTree((childCount > 0 ? ", " : "") + pluginBuilder.toString()));
    }

    private void removeFromPluginList(String componentName, String pluginName) {
        if (this.loggingSectionHandler == null) {
            return;
        }
        LoggingSectionHandler.LoggerPluginsEntry entry = (LoggingSectionHandler.LoggerPluginsEntry)this.loggingSectionHandler.getLoggerPluginsTree().get(componentName);
        if (entry == null) {
            return;
        }
        if (!entry.getPluginRoots().containsKey(pluginName)) {
            return;
        }
        LoggingSectionHandler.LoggerPluginEntry pluginEntry = (LoggingSectionHandler.LoggerPluginEntry)entry.getPluginRoots().remove(pluginName);
        if (entry.getPluginRoots().size() == 0) {
            ((ParserRuleContext)entry.getLoggerPluginsListRoot()).children.clear();
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)entry.getLoggerPluginsRoot());
            return;
        }
        List list = ((ParserRuleContext)entry.getLoggerPluginsListRoot()).children;
        int size = list.size();
        String childText = pluginEntry.getLoggerPluginRoot().getText();
        for (int i = 0; i < size; ++i) {
            if (!childText.equals(((ParseTree)list.get(i)).getText())) continue;
            list.remove(i);
            if (i > 0) {
                list.remove(i - 1);
            } else if (size > 1) {
                list.remove(i);
            }
            return;
        }
    }

    private void removeLoggingComponents(LoggingSectionHandler.LogParamEntry logentry) {
        ParserRuleContext lastSectionRoot = this.loggingSectionHandler.getLastSectionRoot();
        if (logentry.getAppendFile() != null && logentry.getAppendFileRoot() != null) {
            logentry.setAppendFile(null);
            ConfigTreeNodeUtilities.removeChild((ParseTree)lastSectionRoot, (ParseTree)logentry.getAppendFileRoot());
        }
        if (logentry.getConsoleMask() != null && logentry.getConsoleMaskRoot() != null) {
            logentry.setConsoleMask(null);
            ConfigTreeNodeUtilities.removeChild((ParseTree)lastSectionRoot, (ParseTree)logentry.getConsoleMaskRoot());
        }
        if (logentry.getDiskFullAction() != null && logentry.getDiskFullActionRoot() != null) {
            logentry.setDiskFullAction(null);
            ConfigTreeNodeUtilities.removeChild((ParseTree)lastSectionRoot, (ParseTree)logentry.getDiskFullActionRoot());
        }
        if (logentry.getFileMask() != null && logentry.getFileMaskRoot() != null) {
            logentry.setFileMask(null);
            ConfigTreeNodeUtilities.removeChild((ParseTree)lastSectionRoot, (ParseTree)logentry.getFileMaskRoot());
        }
        if (logentry.getLogEntityName() != null && logentry.getLogEntityNameRoot() != null) {
            logentry.setLogEntityName(null);
            ConfigTreeNodeUtilities.removeChild((ParseTree)lastSectionRoot, (ParseTree)logentry.getLogEntityNameRoot());
        }
        if (logentry.getLogeventTypes() != null && logentry.getLogeventTypesRoot() != null) {
            logentry.setLogeventTypes(null);
            ConfigTreeNodeUtilities.removeChild((ParseTree)lastSectionRoot, (ParseTree)logentry.getLogeventTypesRoot());
        }
        if (logentry.getLogFile() != null && logentry.getLogFileRoot() != null) {
            logentry.setLogFile(null);
            ConfigTreeNodeUtilities.removeChild((ParseTree)lastSectionRoot, (ParseTree)logentry.getLogFileRoot());
        }
        if (logentry.getLogfileNumber() != null && logentry.getLogfileNumberRoot() != null) {
            logentry.setLogfileNumber(null);
            ConfigTreeNodeUtilities.removeChild((ParseTree)lastSectionRoot, (ParseTree)logentry.getLogfileNumberRoot());
        }
        if (logentry.getLogfileSize() != null && logentry.getLogfileSizeRoot() != null) {
            logentry.setLogfileSize(null);
            ConfigTreeNodeUtilities.removeChild((ParseTree)lastSectionRoot, (ParseTree)logentry.getLogfileSizeRoot());
        }
        if (logentry.getMatchingHints() != null && logentry.getMatchingHintsRoot() != null) {
            logentry.setMatchingHints(null);
            ConfigTreeNodeUtilities.removeChild((ParseTree)lastSectionRoot, (ParseTree)logentry.getMatchingHintsRoot());
        }
        if (logentry.getSourceInfoFormat() != null && logentry.getSourceInfoFormatRoot() != null) {
            logentry.setSourceInfoFormat(null);
            ConfigTreeNodeUtilities.removeChild((ParseTree)lastSectionRoot, (ParseTree)logentry.getSourceInfoFormatRoot());
        }
        if (logentry.getTimestampFormat() != null && logentry.getTimestampFormatRoot() != null) {
            logentry.setTimestampFormat(null);
            ConfigTreeNodeUtilities.removeChild((ParseTree)lastSectionRoot, (ParseTree)logentry.getTimestampFormatRoot());
        }
        for (LoggingSectionHandler.PluginSpecificParam psp : logentry.getPluginSpecificParam()) {
            ConfigTreeNodeUtilities.removeChild((ParseTree)lastSectionRoot, (ParseTree)psp.getRoot());
            psp.setParamName(null);
        }
        this.loggingPage.removeLoggingSection();
        this.loggingPage.refreshData(this.loggingSectionHandler);
    }
}

